/*
 * Decompiled with CFR 0.152.
 */
package nu.fw.jeti.util;

import java.io.BufferedReader;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.PrintStream;
import java.text.DateFormat;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import nu.fw.jeti.events.JavaErrorListener;
import nu.fw.jeti.jabber.Backend;
import nu.fw.jeti.jabber.elements.Packet;
import nu.fw.jeti.util.Preferences;

public class Log {
    private static Date date = new Date();
    private static DateFormat dateFormat = DateFormat.getTimeInstance();
    private static LinkedList xml = new LinkedList();
    private static LinkedList xmlErrors = new LinkedList();
    private static volatile LinkedList errors = new LinkedList();
    private static Backend backend;
    private static PrintStream diskLog;
    static /* synthetic */ Class class$nu$fw$jeti$events$JavaErrorListener;

    public Log(Backend backend) {
        Log.backend = backend;
        this.catchExceptions();
        if (Preferences.getBoolean("jeti", "debugToFile", false)) {
            String string = Preferences.getString("jeti", "debugFile", "out.log");
            try {
                diskLog = new PrintStream(new FileOutputStream(string, true));
            }
            catch (IOException iOException) {
                System.err.println("Failed to open debug log '" + string + "': " + iOException);
            }
        }
    }

    private void catchExceptions() {
        try {
            Thread thread = new Thread(){
                PipedInputStream piNormal = new PipedInputStream();
                PipedOutputStream poNormal = new PipedOutputStream(this.piNormal);

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    try {
                        System.setErr(new PrintStream(this.poNormal, true));
                    }
                    catch (Exception exception) {
                        System.out.println("Error logging setup failed");
                    }
                    try {
                        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(this.piNormal));
                        String string = null;
                        while ((string = bufferedReader.readLine()) != null) {
                            System.out.println(string);
                            Object object = errors;
                            synchronized (object) {
                                errors.add(Log.gettime() + " " + string);
                            }
                            try {
                                object = backend.getListeners(class$nu$fw$jeti$events$JavaErrorListener == null ? Log.class$("nu.fw.jeti.events.JavaErrorListener") : class$nu$fw$jeti$events$JavaErrorListener);
                                while (object.hasNext()) {
                                    ((JavaErrorListener)object.next()).error();
                                }
                            }
                            catch (Exception exception) {
                                System.out.println(exception.getMessage());
                            }
                        }
                        bufferedReader.close();
                        this.piNormal.close();
                    }
                    catch (IOException iOException) {
                        try {
                            this.piNormal.close();
                            this.poNormal.close();
                        }
                        catch (IOException iOException2) {
                            System.out.println("foutje");
                        }
                        Log.this.catchExceptions();
                    }
                }
            };
            thread.setDaemon(true);
            thread.start();
        }
        catch (IOException iOException) {
            System.out.println("foutje");
        }
    }

    private static String gettime() {
        date.setTime(System.currentTimeMillis());
        return dateFormat.format(date);
    }

    private static void loggedAdd(LinkedList linkedList, String string) {
        linkedList.add(string);
        if (diskLog != null) {
            diskLog.println(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clear() {
        LinkedList linkedList = xml;
        synchronized (linkedList) {
            xml.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void xmlPacket(Packet packet) {
        LinkedList linkedList = xml;
        synchronized (linkedList) {
            Log.loggedAdd(xml, Log.gettime() + " - p: " + packet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void completeXML(StringBuffer stringBuffer) {
        LinkedList linkedList = xml;
        synchronized (linkedList) {
            Log.loggedAdd(xml, Log.gettime() + " - c: " + stringBuffer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void sendXML(String string) {
        LinkedList linkedList = xml;
        synchronized (linkedList) {
            Log.loggedAdd(xml, Log.gettime() + " +  : " + string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List getXML() {
        LinkedList linkedList = xml;
        synchronized (linkedList) {
            return (List)xml.clone();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void notParsedXML(String string) {
        LinkedList linkedList = xmlErrors;
        synchronized (linkedList) {
            xmlErrors.add(Log.gettime() + " not parsed: " + string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void xmlParseException(Exception exception) {
        LinkedList linkedList = xmlErrors;
        synchronized (linkedList) {
            xmlErrors.add(Log.gettime() + " " + exception.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void xmlReceivedError(String string) {
        LinkedList linkedList = xmlErrors;
        synchronized (linkedList) {
            xmlErrors.add(Log.gettime() + " " + string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List getXMLErrors() {
        LinkedList linkedList = xmlErrors;
        synchronized (linkedList) {
            return (List)xmlErrors.clone();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void notSend(String string) {
        LinkedList linkedList = errors;
        synchronized (linkedList) {
            errors.add(Log.gettime() + " not Send " + string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void error(String string) {
        LinkedList linkedList = errors;
        synchronized (linkedList) {
            errors.add(Log.gettime() + " error " + string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List getErrors() {
        LinkedList linkedList = errors;
        synchronized (linkedList) {
            return (List)errors.clone();
        }
    }

    static {
        diskLog = null;
    }
}

