/*
 * Decompiled with CFR 0.152.
 */
package nu.fw.jeti.ui.models;

import java.util.LinkedList;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import nu.fw.jeti.backend.roster.JIDStatusGroup;
import nu.fw.jeti.backend.roster.JIDStatusTree;
import nu.fw.jeti.backend.roster.PrimaryJIDStatus;
import nu.fw.jeti.events.RosterListener;
import nu.fw.jeti.jabber.JIDStatus;
import nu.fw.jeti.util.I18N;

public class RosterTreeModel
implements TreeModel,
RosterListener {
    private LinkedList treeModelListeners = new LinkedList();
    private JIDStatusTree tree;

    public void rosterReplaced(JIDStatusTree jIDStatusTree) {
        this.tree = jIDStatusTree;
        TreeModelEvent treeModelEvent = new TreeModelEvent((Object)this, new Object[]{this.tree});
        for (int i = 0; i < this.treeModelListeners.size(); ++i) {
            ((TreeModelListener)this.treeModelListeners.get(i)).treeStructureChanged(treeModelEvent);
        }
    }

    public void groupAdded(JIDStatusGroup jIDStatusGroup, int n) {
        int n2 = this.treeModelListeners.size();
        TreeModelEvent treeModelEvent = new TreeModelEvent((Object)this, new Object[]{this.tree}, new int[]{n}, new Object[]{jIDStatusGroup});
        for (int i = 0; i < n2; ++i) {
            ((TreeModelListener)this.treeModelListeners.get(i)).treeNodesInserted(treeModelEvent);
        }
    }

    public void groupDeleted(JIDStatusGroup jIDStatusGroup, int n) {
        int n2 = this.treeModelListeners.size();
        TreeModelEvent treeModelEvent = new TreeModelEvent((Object)this, new Object[]{this.tree}, new int[]{n}, new Object[]{jIDStatusGroup});
        for (int i = 0; i < n2; ++i) {
            ((TreeModelListener)this.treeModelListeners.get(i)).treeNodesRemoved(treeModelEvent);
        }
    }

    public void groupUpdated(JIDStatusGroup jIDStatusGroup, int n) {
        int n2 = this.treeModelListeners.size();
        TreeModelEvent treeModelEvent = new TreeModelEvent((Object)this, new Object[]{this.tree}, new int[]{n}, new Object[]{jIDStatusGroup});
        for (int i = 0; i < n2; ++i) {
            ((TreeModelListener)this.treeModelListeners.get(i)).treeNodesChanged(treeModelEvent);
        }
    }

    public void primaryAdded(JIDStatusGroup jIDStatusGroup, PrimaryJIDStatus primaryJIDStatus, int n) {
        int n2 = this.treeModelListeners.size();
        TreeModelEvent treeModelEvent = new TreeModelEvent((Object)this, new Object[]{this.tree, jIDStatusGroup}, new int[]{n}, new Object[]{primaryJIDStatus});
        for (int i = 0; i < n2; ++i) {
            ((TreeModelListener)this.treeModelListeners.get(i)).treeNodesInserted(treeModelEvent);
        }
    }

    public void primaryDeleted(JIDStatusGroup jIDStatusGroup, PrimaryJIDStatus primaryJIDStatus, int n) {
        int n2 = this.treeModelListeners.size();
        TreeModelEvent treeModelEvent = new TreeModelEvent((Object)this, new Object[]{this.tree, jIDStatusGroup}, new int[]{n}, new Object[]{primaryJIDStatus});
        for (int i = 0; i < n2; ++i) {
            ((TreeModelListener)this.treeModelListeners.get(i)).treeNodesRemoved(treeModelEvent);
        }
    }

    public void primaryUpdated(JIDStatusGroup jIDStatusGroup, PrimaryJIDStatus primaryJIDStatus, int n) {
        int n2 = this.treeModelListeners.size();
        TreeModelEvent treeModelEvent = new TreeModelEvent((Object)this, new Object[]{this.tree, jIDStatusGroup}, new int[]{n}, new Object[]{primaryJIDStatus});
        for (int i = 0; i < n2; ++i) {
            ((TreeModelListener)this.treeModelListeners.get(i)).treeNodesChanged(treeModelEvent);
        }
    }

    public void jidStatusAdded(JIDStatusGroup jIDStatusGroup, PrimaryJIDStatus primaryJIDStatus, JIDStatus jIDStatus, int n) {
        int n2 = this.treeModelListeners.size();
        TreeModelEvent treeModelEvent = new TreeModelEvent((Object)this, new Object[]{this.tree, jIDStatusGroup, primaryJIDStatus}, new int[]{n}, new Object[]{jIDStatus});
        for (int i = 0; i < n2; ++i) {
            ((TreeModelListener)this.treeModelListeners.get(i)).treeNodesInserted(treeModelEvent);
        }
    }

    public void jidStatusDeleted(JIDStatusGroup jIDStatusGroup, PrimaryJIDStatus primaryJIDStatus, JIDStatus jIDStatus, int n) {
        int n2 = this.treeModelListeners.size();
        TreeModelEvent treeModelEvent = new TreeModelEvent((Object)this, new Object[]{this.tree, jIDStatusGroup, primaryJIDStatus}, new int[]{n}, new Object[]{jIDStatus});
        for (int i = 0; i < n2; ++i) {
            ((TreeModelListener)this.treeModelListeners.get(i)).treeNodesRemoved(treeModelEvent);
        }
    }

    public void jidStatussenUpdated(JIDStatusGroup jIDStatusGroup, PrimaryJIDStatus primaryJIDStatus) {
        int n = this.treeModelListeners.size();
        TreeModelEvent treeModelEvent = new TreeModelEvent((Object)this, new Object[]{this.tree, jIDStatusGroup, primaryJIDStatus});
        for (int i = 0; i < n; ++i) {
            ((TreeModelListener)this.treeModelListeners.get(i)).treeStructureChanged(treeModelEvent);
        }
    }

    public void add() {
        if (this.tree != null && !this.tree.existGroup(I18N.gettext("main.error.Error"))) {
            final JIDStatusGroup jIDStatusGroup = this.tree.getGroup(I18N.gettext("main.error.Error"));
            Runnable runnable = new Runnable(){

                public void run() {
                    int n = RosterTreeModel.this.treeModelListeners.size();
                    TreeModelEvent treeModelEvent = new TreeModelEvent((Object)this, new Object[]{RosterTreeModel.this.tree}, new int[]{RosterTreeModel.this.tree.indexOfGroup(jIDStatusGroup)}, new Object[]{jIDStatusGroup});
                    for (int i = 0; i < n; ++i) {
                        ((TreeModelListener)RosterTreeModel.this.treeModelListeners.get(i)).treeNodesInserted(treeModelEvent);
                    }
                }
            };
            try {
                SwingUtilities.invokeLater(runnable);
            }
            catch (Exception exception) {
                System.out.println(exception.getMessage());
            }
        }
    }

    public void remove() {
        if (this.tree != null && this.tree.existGroup(I18N.gettext("main.error.Error"))) {
            JIDStatusGroup jIDStatusGroup = this.tree.getGroup(I18N.gettext("main.error.Error"));
            int n = this.tree.indexOfGroup(jIDStatusGroup);
            this.tree.removeGroup(jIDStatusGroup);
            this.groupDeleted(jIDStatusGroup, n);
        }
    }

    public Object getRoot() {
        return this.tree;
    }

    public Object getChild(Object object, int n) {
        if (object instanceof JIDStatusTree) {
            return this.tree.get(n);
        }
        if (object instanceof JIDStatusGroup) {
            return ((JIDStatusGroup)object).getPrimaryJIDStatus(n);
        }
        return ((PrimaryJIDStatus)object).getJIDStatus(n);
    }

    public int getChildCount(Object object) {
        if (object instanceof JIDStatusTree) {
            return this.tree.getSize();
        }
        if (object instanceof JIDStatusGroup) {
            return ((JIDStatusGroup)object).size();
        }
        if (object instanceof PrimaryJIDStatus) {
            return ((PrimaryJIDStatus)object).size();
        }
        System.out.println("no parent");
        return 0;
    }

    public boolean isLeaf(Object object) {
        if (object instanceof JIDStatusTree) {
            return false;
        }
        if (object instanceof JIDStatusGroup) {
            return false;
        }
        return !(object instanceof PrimaryJIDStatus);
    }

    public void valueForPathChanged(TreePath treePath, Object object) {
        throw new UnsupportedOperationException("Method valueForPathChanged() not yet implemented");
    }

    public int getIndexOfChild(Object object, Object object2) {
        if (object instanceof JIDStatusTree) {
            return ((JIDStatusTree)object).indexOfGroup(object2);
        }
        if (object instanceof JIDStatusGroup) {
            return ((JIDStatusGroup)object).indexOfPrimaryJIDStatus(object2);
        }
        return ((PrimaryJIDStatus)object).indexOfJIDStatus(object2);
    }

    public void addTreeModelListener(TreeModelListener treeModelListener) {
        this.treeModelListeners.add(treeModelListener);
    }

    public void removeTreeModelListener(TreeModelListener treeModelListener) {
        this.treeModelListeners.remove(treeModelListener);
    }
}

