/*
 * Decompiled with CFR 0.152.
 */
package nu.fw.jeti.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.MessageFormat;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import nu.fw.jeti.backend.LoginInfo;
import nu.fw.jeti.backend.Start;
import nu.fw.jeti.events.LoginListener;
import nu.fw.jeti.images.StatusIcons;
import nu.fw.jeti.jabber.Backend;
import nu.fw.jeti.ui.login.LoginWindow;
import nu.fw.jeti.util.I18N;

public class LoginStatusWindow
extends JFrame
implements LoginListener {
    private Backend backend;
    private JLabel lblStatus;
    private JButton button;
    private JLabel lblInfo;
    private JLabel[] ligths = new JLabel[5];
    private int tryCounter = 0;
    private LoginInfo info;

    public LoginStatusWindow(final LoginInfo loginInfo, final Backend backend, int n) {
        this.info = loginInfo;
        this.setCursor(Cursor.getDefaultCursor());
        this.backend = backend;
        if (n > 1) {
            this.tryCounter = n + 1;
        }
        this.setIconImage(StatusIcons.getImageIcon("jeti").getImage());
        this.setTitle(I18N.gettext("main.loginstatus.Logging_in"));
        JPanel jPanel = new JPanel(new BorderLayout());
        this.lblInfo = new JLabel(I18N.gettext("main.loginstatus.Logging_in") + "...");
        jPanel.add((Component)this.lblInfo, "North");
        JPanel jPanel2 = new JPanel();
        for (int i = 0; i < 5; ++i) {
            this.ligths[i] = new JLabel(StatusIcons.getOfflineIcon());
            jPanel2.add(this.ligths[i]);
        }
        jPanel.add((Component)jPanel2, "Center");
        this.button = new JButton();
        I18N.setTextAndMnemonic("Abort", this.button);
        jPanel.add((Component)this.button, "South");
        this.getContentPane().add((Component)jPanel, "Center");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                backend.removeListener(class$nu$fw$jeti$events$LoginListener == null ? (class$nu$fw$jeti$events$LoginListener = LoginStatusWindow.class$("nu.fw.jeti.events.LoginListener")) : class$nu$fw$jeti$events$LoginListener, LoginStatusWindow.this);
                LoginStatusWindow.this.dispose();
            }
        });
        this.button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (LoginStatusWindow.this.button.getText().equals(I18N.gettext("Abort"))) {
                    backend.abortLogin();
                    LoginStatusWindow.this.tryCounter = 0;
                    LoginStatusWindow.this.reset();
                } else {
                    I18N.setTextAndMnemonic("Abort", LoginStatusWindow.this.button);
                    LoginStatusWindow.this.lblInfo.setText(I18N.gettext("main.loginstatus.Logging_in") + "...");
                    backend.login(loginInfo);
                    LoginStatusWindow.this.setCursor(Cursor.getPredefinedCursor(3));
                }
            }
        });
        this.lblStatus = new JLabel(I18N.gettext("main.loginstatus.Logging_in_on_your_jabber_account") + ".......");
        this.getContentPane().add((Component)this.lblStatus, "South");
        backend.addListener(LoginListener.class, this);
        this.pack();
        this.setLocationRelativeTo(null);
        if (n > 1) {
            backend.autoLogin(loginInfo, n);
        } else {
            backend.login(loginInfo);
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        if (!loginInfo.hideStatusWindow()) {
            this.show();
        }
    }

    private void reset() {
        for (int i = 0; i < 5; ++i) {
            this.ligths[i].setIcon(StatusIcons.getOfflineIcon());
        }
        if (this.tryCounter == 0) {
            this.setCursor(Cursor.getDefaultCursor());
            I18N.setTextAndMnemonic("Retry", this.button);
        }
    }

    public void loginMessage(final String string) {
        Runnable runnable = new Runnable(){

            public void run() {
                LoginStatusWindow.this.lblStatus.setText(string);
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    public void loginStatus(final int n) {
        if (n == 5) {
            this.setCursor(Cursor.getDefaultCursor());
            this.backend.removeListener(LoginListener.class, this);
            this.dispose();
            return;
        }
        Runnable runnable = new Runnable(){

            public void run() {
                if (n == 0 && LoginStatusWindow.this.button.getText().equals(I18N.gettext("Retry"))) {
                    I18N.setTextAndMnemonic("Abort", LoginStatusWindow.this.button);
                    LoginStatusWindow.this.lblInfo.setText(I18N.gettext("main.loginstatus.Logging_in") + "...");
                    LoginStatusWindow.this.setCursor(Cursor.getPredefinedCursor(3));
                }
                LoginStatusWindow.this.ligths[n].setIcon(StatusIcons.getStatusIcon(2));
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    public void loginError(final String string) {
        Runnable runnable = new Runnable(){

            public void run() {
                LoginStatusWindow.this.reset();
                if (LoginStatusWindow.this.tryCounter != 0) {
                    LoginStatusWindow.this.lblInfo.setText(MessageFormat.format(I18N.gettext("main.loginstatus.An_error_has_occured,_trying_again_{0}_X"), new Integer(LoginStatusWindow.this.tryCounter)));
                    LoginStatusWindow.this.tryCounter--;
                } else {
                    LoginStatusWindow.this.lblInfo.setText(I18N.gettext("main.loginstatus.An_error_has_occured_while_logging_in"));
                }
                LoginStatusWindow.this.lblStatus.setText(string);
            }
        };
        SwingUtilities.invokeLater(runnable);
        this.show();
    }

    public void unauthorized() {
        if (!Start.applet) {
            new LoginWindow(this.backend, I18N.gettext("main.login.Wrong_Password_Try_again")).show();
        } else {
            new nu.fw.jeti.applet.LoginWindow(this.backend, this.info).show();
        }
        this.backend.removeListener(LoginListener.class, this);
        this.dispose();
    }

    public void abort() {
        this.backend.removeListener(LoginListener.class, this);
        this.dispose();
    }
}

