/*
 * Decompiled with CFR 0.152.
 */
package nu.fw.jeti.images;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.zip.ZipException;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import nu.fw.jeti.backend.Start;
import nu.fw.jeti.backend.XMLDataFile;
import nu.fw.jeti.images.RosterIconsHandler;
import nu.fw.jeti.plugins.PluginsHandler;
import nu.fw.jeti.util.Preferences;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class Icons
extends XMLDataFile {
    private List iconList;
    private SAXParser parser;
    private String iconType;

    public Icons(String string) {
        this.iconList = Preferences.getPlugable(string);
        this.iconType = string;
    }

    private void loadParser() {
        try {
            this.parser = SAXParserFactory.newInstance().newSAXParser();
        }
        catch (FactoryConfigurationError factoryConfigurationError) {
            factoryConfigurationError.printStackTrace();
        }
        catch (SAXException sAXException) {
            sAXException.printStackTrace();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            parserConfigurationException.printStackTrace();
        }
    }

    public Icons(SAXParser sAXParser, String string) throws IOException {
        block6: {
            this.iconType = string;
            this.iconList = Preferences.getPlugable(this.iconType);
            this.parser = sAXParser;
            InputStream inputStream = null;
            inputStream = this.getClass().getResourceAsStream("/" + this.iconType + ".xml");
            if (inputStream != null) {
                this.parseData(inputStream);
            }
            try {
                inputStream = new URL(Start.dataURL + "plugins/" + this.iconType + "/" + this.iconType + ".xml").openStream();
                this.parseData(inputStream);
            }
            catch (IOException iOException) {
                if (!new File(Start.path + "plugins" + File.separator + this.iconType).exists()) break block6;
                this.scanIcons();
            }
        }
        if (this.iconList.isEmpty()) {
            throw new IOException("no " + this.iconType);
        }
        Iterator iterator = this.iconList.iterator();
        while (iterator.hasNext()) {
            Object[] objectArray = (Object[])iterator.next();
            if (objectArray[2] == null) {
                System.out.println(objectArray[0] + "not found or no description");
                iterator.remove();
                continue;
            }
            if (objectArray[3] != null) continue;
            objectArray[3] = this.getType((String)objectArray[0]);
        }
        sAXParser = null;
    }

    private void parseData(InputStream inputStream) {
        if (inputStream != null) {
            try {
                this.parser.parse(new InputSource(new InputStreamReader(inputStream, "UTF-8")), (DefaultHandler)new PluginsHandler(this.iconList));
            }
            catch (SAXException sAXException) {
                sAXException.printStackTrace();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    public void scanIcons() {
        Object object;
        ArrayList arrayList = new ArrayList(this.iconList);
        this.iconList.clear();
        this.searchIcons();
        try {
            object = new BufferedWriter(new FileWriter(Start.path + "plugins" + File.separator + this.iconType + File.separator + this.iconType + ".xml"));
            ((Writer)object).write(this.toString());
            ((BufferedWriter)object).close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        object = arrayList.iterator();
        block2: while (object.hasNext()) {
            Object[] objectArray = (Object[])object.next();
            Iterator iterator = this.iconList.iterator();
            while (iterator.hasNext()) {
                Object[] objectArray2 = (Object[])iterator.next();
                if (!objectArray[0].equals(objectArray2[0])) continue;
                objectArray2[1] = objectArray[1];
                if (objectArray[3].equals("")) continue block2;
                objectArray2[3] = objectArray[3];
                continue block2;
            }
        }
        object = this.getClass().getResourceAsStream("/" + this.iconType + ".xml");
        if (object != null) {
            if (this.parser == null) {
                this.loadParser();
            }
            this.parseData((InputStream)object);
        }
    }

    private void searchIcons() {
        String string = Start.path + "plugins" + File.separator + this.iconType;
        File file = new File(string);
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            return;
        }
        for (int i = 0; i < fileArray.length; ++i) {
            File file2 = fileArray[i];
            if (!file2.isFile()) continue;
            this.getIconInfo(file2);
        }
    }

    private void getIconInfo(File file) {
        try {
            String string = file.getName().substring(0, file.getName().lastIndexOf("."));
            URL uRL = new URL("jar:" + file.toURL() + "!/" + string + "/");
            Object[] objectArray = new Object[6];
            if (this.parser == null) {
                this.loadParser();
            }
            try {
                this.parser.parse(new URL(uRL, "icondef.xml").openStream(), (DefaultHandler)new RosterIconsHandler(uRL, objectArray));
            }
            catch (ZipException zipException) {
                return;
            }
            objectArray[1] = Boolean.TRUE;
            objectArray[3] = this.getType(file.getName());
            objectArray[4] = file.getName();
            this.iconList.add(objectArray);
        }
        catch (IOException iOException) {
            System.err.println(iOException.getMessage());
        }
        catch (SAXException sAXException) {
            System.err.println(sAXException.getMessage() + "while parsing " + file.getName());
        }
    }

    private String getType(String string) {
        if ((string = string.toLowerCase()).indexOf("msn") != -1) {
            return "msn";
        }
        if (string.indexOf("icq") != -1) {
            return "icq";
        }
        if (string.indexOf("aim") != -1) {
            return "aim";
        }
        if (string.indexOf("aol") != -1) {
            return "aim";
        }
        if (string.indexOf("jabber") != -1) {
            return "jabber";
        }
        if (string.indexOf("yahoo") != -1) {
            return "yahoo";
        }
        if (string.indexOf("gadu") != -1) {
            return "gadu-gadu";
        }
        if (string.indexOf("sms") != -1) {
            return "sms";
        }
        if (string.indexOf("smtp") != -1) {
            return "smtp";
        }
        if (string.indexOf("mail") != -1) {
            return "smtp";
        }
        return "unknown";
    }

    public void appendToXML(StringBuffer stringBuffer) {
        this.appendHeader(stringBuffer);
        this.appendOpenTag(stringBuffer, "<plugins>");
        Iterator iterator = this.iconList.iterator();
        while (iterator.hasNext()) {
            this.appendOpenTag(stringBuffer, "<plugin>");
            Object[] objectArray = (Object[])iterator.next();
            this.appendElement(stringBuffer, "name", (String)objectArray[0]);
            this.appendElement(stringBuffer, "description", (String)objectArray[2]);
            this.appendElement(stringBuffer, "version", (String)objectArray[3]);
            this.appendElement(stringBuffer, "min_jeti_version", (String)objectArray[4]);
            this.appendCloseTag(stringBuffer, "</plugin>");
        }
        this.appendCloseTag(stringBuffer, "</plugins>");
    }
}

