/*
 * Decompiled with CFR 0.152.
 */
package nu.fw.jeti.backend.roster;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.SwingUtilities;
import nu.fw.jeti.backend.roster.AutoReconnect;
import nu.fw.jeti.backend.roster.JIDStatusGroup;
import nu.fw.jeti.backend.roster.JIDStatusTree;
import nu.fw.jeti.backend.roster.NormalJIDStatus;
import nu.fw.jeti.backend.roster.PrimaryJIDStatus;
import nu.fw.jeti.events.DiscoveryListener;
import nu.fw.jeti.events.RosterListener;
import nu.fw.jeti.events.ServerListener;
import nu.fw.jeti.jabber.Backend;
import nu.fw.jeti.jabber.JID;
import nu.fw.jeti.jabber.JIDStatus;
import nu.fw.jeti.jabber.elements.DiscoveryInfo;
import nu.fw.jeti.jabber.elements.DiscoveryItem;
import nu.fw.jeti.util.I18N;

public class Server
implements DiscoveryListener {
    private JIDStatusTree jidTree = new JIDStatusTree();
    private Backend backend;
    private boolean fireReady = false;
    private Map jidStatussen;
    private Map availableTransports;

    public Server(Backend backend) {
        this.backend = backend;
        this.availableTransports = new HashMap(5);
    }

    public void addJIDStatussen(Map map) {
        this.jidStatussen = map;
    }

    public void clear() {
        this.fireReady = false;
        this.availableTransports.clear();
        if (this.jidTree.existGroup(I18N.gettext("main.main.roster.Servers"))) {
            this.jidTree.removeGroup(this.jidTree.getGroup(I18N.gettext("main.main.roster.Servers")));
        }
    }

    public void fire() {
        Iterator iterator = this.backend.getListeners(ServerListener.class);
        while (iterator.hasNext()) {
            ((RosterListener)iterator.next()).rosterReplaced(this.jidTree);
        }
        this.fireReady = true;
    }

    public void addServerNoFire(JIDStatus jIDStatus) {
        JIDStatusGroup jIDStatusGroup = this.jidTree.getGroup(I18N.gettext("main.main.roster.Servers"));
        PrimaryJIDStatus primaryJIDStatus = new PrimaryJIDStatus(jIDStatus.getNick(), jIDStatus);
        jIDStatusGroup.addPrimaryJIDStatus(primaryJIDStatus);
        this.backend.getInfo(JID.jidFromString(jIDStatus.getJID().toStringNoResource()), this);
    }

    public void addServer(String string, JIDStatus jIDStatus) {
        this.addServerNoBrowse(string, jIDStatus);
        this.backend.getInfo(JID.jidFromString(jIDStatus.getJID().toStringNoResource()), this);
    }

    private void addServerNoBrowse(final String string, final JIDStatus jIDStatus) {
        Runnable runnable = new Runnable(){

            public void run() {
                JIDStatusGroup jIDStatusGroup;
                String string2 = I18N.gettext("main.main.roster.Servers");
                if (!Server.this.jidTree.existGroup(string2)) {
                    jIDStatusGroup = Server.this.jidTree.getGroup(string2);
                    int n = Server.this.jidTree.indexOfGroup(jIDStatusGroup);
                    Iterator iterator = Server.this.backend.getListeners(class$nu$fw$jeti$events$ServerListener == null ? (class$nu$fw$jeti$events$ServerListener = Server.class$("nu.fw.jeti.events.ServerListener")) : class$nu$fw$jeti$events$ServerListener);
                    while (iterator.hasNext()) {
                        ((RosterListener)iterator.next()).groupAdded(jIDStatusGroup, n);
                    }
                } else {
                    jIDStatusGroup = Server.this.jidTree.getGroup(string2);
                }
                PrimaryJIDStatus primaryJIDStatus = jIDStatusGroup.searchPrimaryJIDStatus(string);
                primaryJIDStatus = new PrimaryJIDStatus(string, jIDStatus);
                jIDStatusGroup.addPrimaryJIDStatus(primaryJIDStatus);
                int n = jIDStatusGroup.indexOfPrimaryJIDStatus(primaryJIDStatus);
                Iterator iterator = Server.this.backend.getListeners(class$nu$fw$jeti$events$ServerListener == null ? (class$nu$fw$jeti$events$ServerListener = Server.class$("nu.fw.jeti.events.ServerListener")) : class$nu$fw$jeti$events$ServerListener);
                while (iterator.hasNext()) {
                    ((RosterListener)iterator.next()).primaryAdded(jIDStatusGroup, primaryJIDStatus, n);
                }
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(runnable);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
            catch (InvocationTargetException invocationTargetException) {
                invocationTargetException.printStackTrace();
            }
        }
    }

    public void removeServer(final String string, final JIDStatus jIDStatus) {
        Runnable runnable = new Runnable(){

            public void run() {
                JIDStatusGroup jIDStatusGroup = Server.this.jidTree.getGroup(I18N.gettext("main.main.roster.Servers"));
                PrimaryJIDStatus primaryJIDStatus = jIDStatusGroup.searchPrimaryJIDStatus(string);
                if (primaryJIDStatus.removeJIDStatus(jIDStatus)) {
                    int n = jIDStatusGroup.indexOfPrimaryJIDStatus(primaryJIDStatus);
                    jIDStatusGroup.removePrimaryJIDStatus(primaryJIDStatus);
                    Iterator iterator = Server.this.backend.getListeners(class$nu$fw$jeti$events$ServerListener == null ? (class$nu$fw$jeti$events$ServerListener = Server.class$("nu.fw.jeti.events.ServerListener")) : class$nu$fw$jeti$events$ServerListener);
                    while (iterator.hasNext()) {
                        ((RosterListener)iterator.next()).primaryDeleted(jIDStatusGroup, primaryJIDStatus, n);
                    }
                    if (jIDStatusGroup.size() < 1) {
                        int n2 = Server.this.jidTree.indexOfGroup(jIDStatusGroup);
                        Server.this.jidTree.removeGroup(jIDStatusGroup);
                        Iterator iterator2 = Server.this.backend.getListeners(class$nu$fw$jeti$events$ServerListener == null ? (class$nu$fw$jeti$events$ServerListener = Server.class$("nu.fw.jeti.events.ServerListener")) : class$nu$fw$jeti$events$ServerListener);
                        while (iterator2.hasNext()) {
                            ((RosterListener)iterator2.next()).groupDeleted(jIDStatusGroup, n2);
                        }
                    }
                }
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(runnable);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
            catch (InvocationTargetException invocationTargetException) {
                invocationTargetException.printStackTrace();
            }
        }
    }

    private void changeNickServer(String string, NormalJIDStatus normalJIDStatus) {
        String string2 = I18N.gettext("main.main.roster.Servers");
        JIDStatusGroup jIDStatusGroup = this.jidTree.getGroup(string2);
        PrimaryJIDStatus primaryJIDStatus = jIDStatusGroup.searchPrimaryJIDStatus(normalJIDStatus.getNick());
        if (primaryJIDStatus.removeJIDStatus(normalJIDStatus)) {
            jIDStatusGroup.removePrimaryJIDStatus(primaryJIDStatus);
        }
        normalJIDStatus.setNick(string);
        jIDStatusGroup = this.jidTree.getGroup(string2);
        primaryJIDStatus = new PrimaryJIDStatus(string, normalJIDStatus);
        jIDStatusGroup.addPrimaryJIDStatus(primaryJIDStatus);
    }

    public void showChange(JIDStatus jIDStatus) {
        final JIDStatusGroup jIDStatusGroup = this.jidTree.getGroup(I18N.gettext("main.main.roster.Servers"));
        final PrimaryJIDStatus primaryJIDStatus = jIDStatusGroup.searchPrimaryJIDStatus(jIDStatus.getNick());
        if (primaryJIDStatus != null) {
            if (!jIDStatus.isOnline() && !((NormalJIDStatus)jIDStatus).isForcedOffline()) {
                new AutoReconnect(this.backend, jIDStatus.getJID());
            }
            Runnable runnable = new Runnable(){

                public void run() {
                    int n = jIDStatusGroup.indexOfPrimaryJIDStatus(primaryJIDStatus);
                    Iterator iterator = Server.this.backend.getListeners(class$nu$fw$jeti$events$ServerListener == null ? (class$nu$fw$jeti$events$ServerListener = Server.class$("nu.fw.jeti.events.ServerListener")) : class$nu$fw$jeti$events$ServerListener);
                    while (iterator.hasNext()) {
                        ((RosterListener)iterator.next()).primaryUpdated(jIDStatusGroup, primaryJIDStatus, n);
                    }
                }
            };
            try {
                SwingUtilities.invokeAndWait(runnable);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
            catch (InvocationTargetException invocationTargetException) {
                invocationTargetException.printStackTrace();
            }
        }
    }

    public void discoveryItemResult(JID jID, DiscoveryItem discoveryItem) {
    }

    public void discoveryInfoResult(JID jID, DiscoveryInfo discoveryInfo) {
        Object object;
        NormalJIDStatus normalJIDStatus = (NormalJIDStatus)Backend.getJIDStatus(jID);
        if (normalJIDStatus == null) {
            System.out.println(jID + " is unknown jidstatus");
            return;
        }
        try {
            if (discoveryInfo.getName() != null && ((object = JID.checkedJIDFromString(normalJIDStatus.getNick())) == null || ((JID)object).equals(jID))) {
                if (this.fireReady) {
                    this.removeServer(normalJIDStatus.getNick(), normalJIDStatus);
                    normalJIDStatus.setNick(discoveryInfo.getName());
                    this.addServerNoBrowse(discoveryInfo.getName(), normalJIDStatus);
                } else {
                    this.changeNickServer(discoveryInfo.getName(), normalJIDStatus);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        object = discoveryInfo.getType();
        if (object == null) {
            object = "unknown";
        }
        this.availableTransports.put(object, normalJIDStatus);
        if (normalJIDStatus.getType().equals("jabber") && !((String)object).equals("jabber")) {
            this.updateTypes(normalJIDStatus, (String)object);
        }
    }

    private void updateTypes(NormalJIDStatus normalJIDStatus, String string) {
        normalJIDStatus.setType(string);
        String string2 = normalJIDStatus.getJID().getDomain();
        Iterator iterator = this.jidStatussen.values().iterator();
        while (iterator.hasNext()) {
            NormalJIDStatus normalJIDStatus2 = (NormalJIDStatus)iterator.next();
            if (!normalJIDStatus2.getJID().getDomain().equals(string2)) continue;
            normalJIDStatus2.setType(string);
        }
    }

    public Map getAvailableTransports() {
        return this.availableTransports;
    }
}

