/*
 * Decompiled with CFR 0.152.
 */
package nu.fw.jeti.backend;

import java.text.MessageFormat;
import java.util.Iterator;
import nu.fw.jeti.backend.Discovery;
import nu.fw.jeti.backend.IQTimerQueue;
import nu.fw.jeti.backend.OwnCapabilities;
import nu.fw.jeti.backend.PacketReceiver;
import nu.fw.jeti.backend.XExecutableExtension;
import nu.fw.jeti.events.IQResultListener;
import nu.fw.jeti.events.MessageEventListener;
import nu.fw.jeti.events.MessageListener;
import nu.fw.jeti.events.PresenceListener;
import nu.fw.jeti.jabber.Backend;
import nu.fw.jeti.jabber.JID;
import nu.fw.jeti.jabber.JIDStatus;
import nu.fw.jeti.jabber.elements.Extension;
import nu.fw.jeti.jabber.elements.IQBrowse;
import nu.fw.jeti.jabber.elements.IQDiscoInfo;
import nu.fw.jeti.jabber.elements.IQDiscoItems;
import nu.fw.jeti.jabber.elements.IQExtension;
import nu.fw.jeti.jabber.elements.IQXCaps;
import nu.fw.jeti.jabber.elements.IQXRoster;
import nu.fw.jeti.jabber.elements.InfoQuery;
import nu.fw.jeti.jabber.elements.Message;
import nu.fw.jeti.jabber.elements.Packet;
import nu.fw.jeti.jabber.elements.Presence;
import nu.fw.jeti.jabber.elements.PresenceBuilder;
import nu.fw.jeti.jabber.elements.RosterItem;
import nu.fw.jeti.jabber.elements.StreamError;
import nu.fw.jeti.jabber.elements.XMPPError;
import nu.fw.jeti.jabber.elements.XMPPErrorTag;
import nu.fw.jeti.jabber.elements.XMessageEvent;
import nu.fw.jeti.ui.AddContact;
import nu.fw.jeti.util.I18N;
import nu.fw.jeti.util.Log;
import nu.fw.jeti.util.Popups;

public class Jabber
implements PacketReceiver {
    private Backend backend;
    private Discovery discovery;
    private IQTimerQueue iqTimerQueue;
    private OwnCapabilities capabilities;
    static /* synthetic */ Class class$nu$fw$jeti$events$MessageEventListener;

    public Jabber(Backend backend, OwnCapabilities ownCapabilities, Discovery discovery, IQTimerQueue iQTimerQueue) {
        this.iqTimerQueue = iQTimerQueue;
        this.backend = backend;
        this.discovery = discovery;
        this.capabilities = ownCapabilities;
    }

    public void receivePackets(Packet packet) {
        if (packet instanceof StreamError) {
            this.backend.streamError((StreamError)packet);
        }
        if (packet instanceof InfoQuery) {
            this.infoQuery((InfoQuery)packet);
        } else if (packet instanceof Message) {
            this.message((Message)packet);
        } else if (packet instanceof Presence) {
            this.presence((Presence)packet);
        }
    }

    private void infoQuery(InfoQuery infoQuery) {
        block5: {
            block6: {
                IQExtension iQExtension;
                block10: {
                    block11: {
                        block7: {
                            block9: {
                                block8: {
                                    block4: {
                                        IQResultListener iQResultListener = this.iqTimerQueue.getInfoQueryListener(infoQuery.getID());
                                        if (iQResultListener == null) break block4;
                                        iQResultListener.iqResult(infoQuery);
                                        break block5;
                                    }
                                    if (!infoQuery.hasExtensions()) break block6;
                                    iQExtension = infoQuery.getIQExtension();
                                    if (!(iQExtension instanceof IQDiscoInfo)) break block7;
                                    if (!infoQuery.getType().equals("result")) break block8;
                                    this.discovery.discoveryInfoResult(infoQuery.getFrom(), infoQuery.getID(), (IQDiscoInfo)iQExtension);
                                    break block5;
                                }
                                if (!infoQuery.getType().equals("get")) break block9;
                                this.capabilities.answerInfoRequest(infoQuery, (IQDiscoInfo)iQExtension);
                                break block5;
                            }
                            if (!infoQuery.getType().equals("error")) break block5;
                            Log.xmlReceivedError("Disco error " + infoQuery.getErrorCode() + " " + infoQuery.getErrorDescription() + " from " + infoQuery.getFrom());
                            this.discovery.discoError(infoQuery.getID(), infoQuery.getFrom());
                            break block5;
                        }
                        if (!(iQExtension instanceof IQDiscoItems)) break block10;
                        if (!infoQuery.getType().equals("result")) break block11;
                        this.discovery.discoveryItemResult(infoQuery.getFrom(), infoQuery.getID(), (IQDiscoItems)iQExtension);
                        break block5;
                    }
                    if (!infoQuery.getType().equals("error")) break block5;
                    Log.xmlReceivedError("Disco error " + infoQuery.getErrorCode() + " " + infoQuery.getErrorDescription() + " from " + infoQuery.getFrom());
                    this.discovery.discoError(infoQuery.getID(), infoQuery.getFrom());
                    break block5;
                }
                if (iQExtension instanceof IQBrowse) break block5;
                iQExtension.execute(infoQuery, this.backend);
                break block5;
            }
            if (infoQuery.getType().equals("set")) {
                XMPPError xMPPError = new XMPPError("cancel", 501);
                xMPPError.addError(new XMPPErrorTag("feature-not-implemented"));
                this.backend.send(new InfoQuery(infoQuery.getFrom(), infoQuery.getID(), xMPPError));
            } else if (infoQuery.getType().equals("result") && infoQuery.getID().indexOf("jj") == 0) {
                Iterator iterator = this.backend.getListeners(IQResultListener.class);
                while (iterator.hasNext()) {
                    ((IQResultListener)iterator.next()).iqResult(infoQuery);
                }
            }
        }
    }

    private void message(Message message) {
        Iterator iterator;
        MessageListener messageListener = this.backend.getMessageListener(message.getFrom());
        if (messageListener != null) {
            messageListener.message(message);
            return;
        }
        if (message.getBody() != null || message.getType().equals("groupchat")) {
            iterator = this.backend.getListeners(MessageListener.class);
            while (iterator.hasNext()) {
                ((MessageListener)iterator.next()).message(message);
            }
        }
        if (message.hasExtensions()) {
            iterator = message.getExtensions();
            while (iterator.hasNext()) {
                Iterator iterator2;
                Extension extension = (Extension)iterator.next();
                if (extension instanceof XExecutableExtension) {
                    ((XExecutableExtension)((Object)extension)).execute(message, this.backend);
                    continue;
                }
                if (!(extension instanceof XMessageEvent)) continue;
                if (message.getBody() == null) {
                    iterator2 = this.backend.getListeners(class$nu$fw$jeti$events$MessageEventListener == null ? Jabber.class$("nu.fw.jeti.events.MessageEventListener") : class$nu$fw$jeti$events$MessageEventListener);
                    while (iterator2.hasNext()) {
                        ((MessageEventListener)iterator2.next()).onComposing(message.getFrom(), message.getThread(), (XMessageEvent)extension);
                    }
                    continue;
                }
                iterator2 = this.backend.getListeners(class$nu$fw$jeti$events$MessageEventListener == null ? Jabber.class$("nu.fw.jeti.events.MessageEventListener") : class$nu$fw$jeti$events$MessageEventListener);
                while (iterator2.hasNext()) {
                    ((MessageEventListener)iterator2.next()).requestComposing(message.getFrom(), message.getID(), message.getThread());
                }
            }
        }
    }

    private void presence(Presence presence) {
        Object object;
        Object object2;
        PresenceListener presenceListener = this.backend.getPresenceListener(presence.getFrom());
        if (presenceListener != null) {
            presenceListener.presenceChanged(presence);
            return;
        }
        String string = presence.getType();
        if (!"error".equals(string) && presence.hasExtensions()) {
            object2 = presence.getExtensions();
            while (object2.hasNext()) {
                object = object2.next();
                if (!(object instanceof IQXCaps)) continue;
                this.backend.setCapability(presence.getFrom(), (IQXCaps)object);
                break;
            }
        }
        if (string.equals("available") || string.equals("unavailable")) {
            object2 = this.backend.getListeners(PresenceListener.class);
            while (object2.hasNext()) {
                ((PresenceListener)object2.next()).presenceChanged(presence);
            }
        } else if ("subscribe".equals(string)) {
            object2 = presence.getFrom();
            if (((JID)object2).getUser() == null) {
                this.sendSubscribed((JID)object2, "subscribed", presence.getID());
                if (Backend.getJIDStatus(presence.getFrom()) == null) {
                    this.backend.send(new Presence((JID)object2, "subscribe"));
                    object = new IQXRoster(new RosterItem((JID)object2, null, null, "subscribe", null));
                    this.backend.send(new InfoQuery("set", (IQExtension)object));
                }
            } else {
                this.fireOnSubscriptionRequestEvent((JID)object2, presence.getID());
            }
        } else if ("unsubscribed".equals(string)) {
            Popups.messagePopup(presence.getFrom() + " unsuscribed you from his presence", "Unsubscribed");
        } else if ("error".equals(string)) {
            Log.xmlReceivedError("Presence error " + presence.getErrorCode() + " " + presence.getErrorDescription() + " from " + presence.getFrom());
        }
    }

    private void fireOnSubscriptionRequestEvent(final JID jID, final String string) {
        JIDStatus jIDStatus = Backend.getJIDStatus(jID);
        if (jIDStatus != null) {
            Popups.OptionChoosed optionChoosed = new Popups.OptionChoosed(){

                public void optionChoosed(int n) {
                    String string2 = "subscribed";
                    if (n == 0) {
                        string2 = "unsubscribed";
                    }
                    Jabber.this.sendSubscribed(jID, string2, string);
                }
            };
            Object[] objectArray = new Object[]{I18N.gettext("main.popup.Deny_subscription"), I18N.gettext("OK")};
            Popups.showOptionDialog(MessageFormat.format(I18N.gettext("main.popup.{0}_wants_to_subscribe_to_your_presence"), jIDStatus.getNick()), I18N.gettext("main.popup.Subscription_request"), 0, 3, null, objectArray, objectArray[1], optionChoosed);
        } else {
            Popups.OptionChoosed optionChoosed = new Popups.OptionChoosed(){

                public void optionChoosed(int n) {
                    String string2 = "subscribed";
                    if (n == 1) {
                        new AddContact(jID, null, Jabber.this.backend).setVisible(true);
                    } else {
                        string2 = "unsubscribed";
                    }
                    Jabber.this.sendSubscribed(jID, string2, string);
                }
            };
            Object[] objectArray = new Object[]{I18N.gettext("main.popup.Deny_subscription"), I18N.gettext("main.popup.Add_to_roster")};
            Popups.showOptionDialog(MessageFormat.format(I18N.gettext("main.popup.{0}_wants_to_subscribe_to_your_presence"), jID), I18N.gettext("main.popup.Subscription_request"), 0, 3, null, objectArray, objectArray[1], optionChoosed);
        }
    }

    private void sendSubscribed(JID jID, String string, String string2) {
        try {
            PresenceBuilder presenceBuilder = new PresenceBuilder();
            presenceBuilder.type = string;
            presenceBuilder.setId(string2);
            presenceBuilder.setTo(jID);
            this.backend.send(presenceBuilder.build());
        }
        catch (InstantiationException instantiationException) {
            instantiationException.printStackTrace();
        }
    }
}

