/*
 * Decompiled with CFR 0.152.
 */
package nu.fw.jeti.backend;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.KeyManagementException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.text.MessageFormat;
import java.util.Date;
import java.util.Iterator;
import javax.net.ssl.HandshakeCompletedEvent;
import javax.net.ssl.HandshakeCompletedListener;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.swing.JOptionPane;
import nu.fw.jeti.backend.ConnectionPacketReceiver;
import nu.fw.jeti.backend.Discovery;
import nu.fw.jeti.backend.Handlers;
import nu.fw.jeti.backend.IQTimerQueue;
import nu.fw.jeti.backend.Input;
import nu.fw.jeti.backend.Jabber;
import nu.fw.jeti.backend.JabberHandler;
import nu.fw.jeti.backend.LoginInfo;
import nu.fw.jeti.backend.Output;
import nu.fw.jeti.backend.OwnCapabilities;
import nu.fw.jeti.events.DiscoveryListener;
import nu.fw.jeti.events.LoginListener;
import nu.fw.jeti.events.StatusChangeListener;
import nu.fw.jeti.jabber.Backend;
import nu.fw.jeti.jabber.JID;
import nu.fw.jeti.jabber.elements.DiscoveryInfo;
import nu.fw.jeti.jabber.elements.DiscoveryItem;
import nu.fw.jeti.jabber.elements.IQAuth;
import nu.fw.jeti.jabber.elements.IQAuthBuilder;
import nu.fw.jeti.jabber.elements.IQExtension;
import nu.fw.jeti.jabber.elements.IQPrivate;
import nu.fw.jeti.jabber.elements.IQXRoster;
import nu.fw.jeti.jabber.elements.InfoQuery;
import nu.fw.jeti.jabber.elements.JetiPrivateExtension;
import nu.fw.jeti.jabber.elements.JetiPrivateRosterExtension;
import nu.fw.jeti.jabber.elements.Packet;
import nu.fw.jeti.jabber.elements.Presence;
import nu.fw.jeti.jabber.elements.PresenceBuilder;
import nu.fw.jeti.jabber.elements.StreamError;
import nu.fw.jeti.plugins.Avatars;
import nu.fw.jeti.plugins.OpenPGP;
import nu.fw.jeti.plugins.PluginsInfo;
import nu.fw.jeti.plugins.XMPP;
import nu.fw.jeti.ui.LoginStatusWindow;
import nu.fw.jeti.util.I18N;
import nu.fw.jeti.util.Log;
import nu.fw.jeti.util.Utils;
import sun.misc.BASE64Encoder;
import sun.net.www.protocol.http.HttpURLConnection;

public class Connect
implements ConnectionPacketReceiver {
    private Output output;
    private Input input;
    private String authenticationId = "yytr";
    private JabberHandler jabberHandler;
    private LoginInfo loginInfo;
    private Backend backend;
    private static JID myJID = new JID("test", "test", "test");
    private boolean authenticated = false;
    private boolean reconnecting = false;
    private long latestConnected = 0L;
    private int show;
    private String status;
    private String connectionID;
    private Discovery discovery;
    private OwnCapabilities capabilities;
    private Socket socket;
    private Thread connectThread;
    private volatile boolean abort = false;
    private OpenPGP openPGP;
    private IQTimerQueue iqTimerQueue;
    private LoginStatusWindow loginStatusWindow;
    private Avatars avatars;
    private Handlers handlers;
    private XMPP xmpp;
    String host;

    public Connect(Backend backend, IQTimerQueue iQTimerQueue, Handlers handlers) {
        this.backend = backend;
        this.iqTimerQueue = iQTimerQueue;
        this.handlers = handlers;
        this.discovery = new Discovery(backend);
        this.capabilities = new OwnCapabilities(backend);
    }

    public void addCapability(String string, String string2) {
        this.capabilities.addCapability(string, string2);
    }

    public void removeCapability(String string, String string2) {
        this.capabilities.removeCapability(string, string2);
    }

    public int getStatus() {
        return this.show;
    }

    public void getItems(JID jID, DiscoveryListener discoveryListener, boolean bl) {
        this.discovery.getItems(jID, discoveryListener, bl);
    }

    public void getItems(JID jID, DiscoveryListener discoveryListener) {
        this.discovery.getItems(jID, discoveryListener);
    }

    public void getInfo(JID jID, DiscoveryListener discoveryListener) {
        this.discovery.getInfo(jID, discoveryListener);
    }

    public void getItems(JID jID, String string, DiscoveryListener discoveryListener) {
        this.discovery.getItems(jID, string, discoveryListener);
    }

    public void getInfo(JID jID, String string, DiscoveryListener discoveryListener) {
        this.discovery.getInfo(jID, string, discoveryListener);
    }

    public boolean isLoggedIn() {
        return this.authenticated;
    }

    public boolean isPasswordValid(String string) {
        return this.loginInfo.getPassword().equals(string);
    }

    private void reconnect() {
        if (this.loginStatusWindow != null) {
            this.loginStatusWindow.abort();
        }
        this.loginStatusWindow = new LoginStatusWindow(this.loginInfo, this.backend, 5);
    }

    public void login(LoginInfo loginInfo) {
        if (PluginsInfo.isPluginLoaded("openpgp")) {
            this.openPGP = (OpenPGP)PluginsInfo.getPluginInstance("openpgp");
        }
        this.abort = false;
        this.loginInfo = loginInfo;
        this.connectThread = new Thread(){

            public void run() {
                Connect.this.connect();
            }
        };
        this.connectThread.start();
    }

    public void autoLogin(LoginInfo loginInfo, final int n) {
        if (System.currentTimeMillis() < this.latestConnected + 60000L) {
            return;
        }
        this.abort = false;
        this.loginInfo = loginInfo;
        this.connectThread = new Thread(){
            int tel = 0;

            public void run() {
                boolean bl = false;
                while (this.tel < n && !(bl = Connect.this.connect())) {
                    try {
                        Thread.sleep(60000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    ++this.tel;
                }
                if (!bl) {
                    Connect.this.sendLoginMessage("login failed, tried " + n + " times, stopping");
                }
            }
        };
        this.connectThread.start();
    }

    public void abort() {
        this.abort = true;
        if (this.socket != null) {
            try {
                this.socket.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        this.connectThread.interrupt();
        this.disconnect();
    }

    public boolean isAborted() {
        return this.abort;
    }

    private synchronized boolean connect() {
        this.latestConnected = System.currentTimeMillis();
        if (this.loginInfo == null) {
            return true;
        }
        if (this.authenticated) {
            this.disconnect();
        }
        if (this.loginInfo.useProxy(1)) {
            System.getProperties().put("proxySet", "true");
            System.getProperties().setProperty("socksProxyHost", this.loginInfo.getProxyServer());
            System.getProperties().setProperty("socksProxyPort", this.loginInfo.getProxyPort());
            System.getProperties().setProperty("socksProxyUserName", this.loginInfo.getProxyUsername());
            if (this.loginInfo.getProxyPassword() != null) {
                System.getProperties().setProperty("socksProxyPassword", this.loginInfo.getProxyPassword());
            }
        }
        this.sendLoginStatus(0);
        this.sendLoginMessage(I18N.gettext("main.loginstatus.Opening_socket") + "...");
        this.jabberHandler = new JabberHandler(this, this.handlers);
        if (this.xmpp == null && PluginsInfo.isPluginLoaded("xmpp")) {
            this.xmpp = (XMPP)((Object)PluginsInfo.newPluginInstance("xmpp"));
            this.handlers.loadExtraHandlers(this.xmpp.getXMPPHandlers());
        }
        try {
            this.host = this.loginInfo.getHost();
            if (this.host == null || this.host.length() == 0) {
                this.host = this.loginInfo.useProxy(0) && PluginsInfo.isPluginLoaded("xmpp") ? this.xmpp.resolveXMPPDomain(this.loginInfo.getServer()) : this.loginInfo.getServer();
            }
            if (this.loginInfo.isSSl()) {
                if (this.loginInfo.isHTTPProxy()) {
                    Socket socket = this.createHTTPTunel(this.host);
                    this.socket = new DummySSLSocketFactory().createSocket(socket, this.host, this.loginInfo.getPort(), true);
                } else {
                    this.socket = new DummySSLSocketFactory().createSocket(this.host, this.loginInfo.getPort());
                }
            } else {
                this.socket = new Socket(this.host, this.loginInfo.getPort());
            }
        }
        catch (UnknownHostException unknownHostException) {
            this.sendLoginError(MessageFormat.format(I18N.gettext("main.loginstatus.Server_{0}_could_not_be_found"), this.loginInfo.getHost()));
            return false;
        }
        catch (IOException iOException) {
            this.sendLoginError(iOException.getMessage());
            return false;
        }
        if (this.abort) {
            return false;
        }
        this.sendLoginStatus(1);
        this.sendLoginMessage(I18N.gettext("main.loginstatus.Opening_Input") + "...");
        try {
            this.input = new Input(this.socket.getInputStream(), this, this.jabberHandler);
        }
        catch (IOException iOException) {
            this.sendLoginError(I18N.gettext("main.loginstatus.Could_not_open_input_because") + " " + iOException.getMessage());
            return false;
        }
        if (this.abort) {
            return false;
        }
        this.sendLoginMessage(I18N.gettext("main.loginstatus.Opening_Output") + "...");
        try {
            this.output = new Output(this.socket, this.loginInfo.getServer(), this, this.socket.getOutputStream());
        }
        catch (IOException iOException) {
            this.sendLoginError(I18N.gettext("main.loginstatus.Could_not_open_output_because") + " " + iOException.getMessage());
            return false;
        }
        this.sendLoginStatus(2);
        this.sendLoginMessage(I18N.gettext("main.loginstatus.Connected") + "...");
        return true;
    }

    public boolean startTls(ConnectionPacketReceiver connectionPacketReceiver) {
        if (this.abort) {
            return false;
        }
        try {
            this.output.disconnect(false);
            this.input.disconnect();
            this.socket = new DummySSLSocketFactory().createSocket(this.socket, this.host, this.loginInfo.getPort(), true);
            System.out.println("opening socket");
            this.jabberHandler = new JabberHandler(connectionPacketReceiver, this.handlers);
            try {
                this.input = new Input(this.socket.getInputStream(), this, this.jabberHandler);
            }
            catch (IOException iOException) {
                this.sendLoginError(I18N.gettext("main.loginstatus.Could_not_open_input_because") + " " + iOException.getMessage());
                return false;
            }
            System.out.println("input opened");
            this.sendLoginMessage(I18N.gettext("main.loginstatus.Opening_Output") + "...");
            try {
                this.output = new Output(this.socket, this.loginInfo.getServer(), this, this.socket.getOutputStream());
            }
            catch (IOException iOException) {
                this.sendLoginError(I18N.gettext("main.loginstatus.Could_not_open_output_because") + " " + iOException.getMessage());
                return false;
            }
            if (this.abort) {
                return false;
            }
            System.out.println("finished");
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return true;
    }

    public Socket getSocket() {
        return this.socket;
    }

    public boolean startCompressed(ConnectionPacketReceiver connectionPacketReceiver, InputStream inputStream, OutputStream outputStream) {
        this.jabberHandler = new JabberHandler(connectionPacketReceiver, this.handlers);
        if (this.abort) {
            return false;
        }
        this.output.disconnect(false);
        Input input = this.input;
        this.input = new Input(inputStream, this, this.jabberHandler);
        this.sendLoginMessage(I18N.gettext("main.loginstatus.Opening_Output") + "...");
        try {
            this.output = new Output(this.socket, this.loginInfo.getServer(), this, outputStream);
        }
        catch (IOException iOException) {
            this.sendLoginError(I18N.gettext("main.loginstatus.Could_not_open_output_because") + " " + iOException.getMessage());
            iOException.printStackTrace();
            return false;
        }
        if (this.abort) {
            return false;
        }
        input.disconnect();
        input.stop();
        System.out.println("finished");
        return true;
    }

    public void startSasl(ConnectionPacketReceiver connectionPacketReceiver) {
        if (this.abort) {
            return;
        }
        this.jabberHandler = new JabberHandler(connectionPacketReceiver, this.handlers);
        try {
            this.input = new Input(this.socket.getInputStream(), this, this.jabberHandler);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        try {
            this.output.writeHeader();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        throw new UnsupportedOperationException("end xmlparser");
    }

    private Socket createHTTPTunel(String string) throws IOException {
        String string2 = this.loginInfo.getProxyServer();
        System.out.println(this.loginInfo.getProxyPort());
        int n = Integer.valueOf(this.loginInfo.getProxyPort());
        Socket socket = new Socket(string2, n);
        this.doTunnelHandshake(socket, string, this.loginInfo.getPort());
        return socket;
    }

    private void doTunnelHandshake(Socket socket, String string, int n) throws IOException {
        String string2;
        Object object;
        Object object2;
        OutputStream outputStream = socket.getOutputStream();
        String string3 = "CONNECT " + string + ":" + n + " HTTP/1.0\n" + "User-Agent: " + HttpURLConnection.userAgent;
        if (this.loginInfo.getProxyUsername() != null && this.loginInfo.getProxyPassword() != null) {
            object2 = new BASE64Encoder();
            object = object2.encode((this.loginInfo.getProxyUsername() + ":" + this.loginInfo.getProxyPassword()).getBytes());
            string3 = string3 + "\nProxy-Authorization: Basic " + (String)object;
        }
        string3 = string3 + "\nContent-Length: 0" + "\nPragma: no-cache" + "\r\n\r\n";
        System.out.println(string3);
        try {
            object2 = string3.getBytes("ASCII7");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            object2 = string3.getBytes();
        }
        outputStream.write((byte[])object2);
        outputStream.flush();
        object = new byte[200];
        int n2 = 0;
        int n3 = 0;
        boolean bl = false;
        InputStream inputStream = socket.getInputStream();
        while (n3 < 2) {
            int n4 = inputStream.read();
            if (n4 < 0) {
                throw new IOException("Unexpected EOF from proxy");
            }
            if (n4 == 10) {
                bl = true;
                ++n3;
                continue;
            }
            if (n4 == 13) continue;
            n3 = 0;
            if (bl || n2 >= ((Object)object).length) continue;
            object[n2++] = (byte)n4;
        }
        try {
            string2 = new String((byte[])object, 0, n2, "ASCII7");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            string2 = new String((byte[])object, 0, n2);
        }
        if (string2.toLowerCase().indexOf("200 connection established") == -1) {
            String string4 = System.getProperty("http.proxyHost");
            String string5 = System.getProperty("http.proxyPort");
            throw new IOException("Unable to tunnel through " + string4 + ":" + string5 + ".  Proxy returns \"" + string2 + "\"");
        }
    }

    private void sendLoginMessage(String string) {
        Iterator iterator = this.backend.getListeners(LoginListener.class);
        while (iterator.hasNext()) {
            ((LoginListener)iterator.next()).loginMessage(string);
        }
    }

    private void sendLoginStatus(int n) {
        Iterator iterator = this.backend.getListeners(LoginListener.class);
        while (iterator.hasNext()) {
            ((LoginListener)iterator.next()).loginStatus(n);
        }
    }

    public void sendLoginError(String string) {
        Iterator iterator = this.backend.getListeners(LoginListener.class);
        while (iterator.hasNext()) {
            ((LoginListener)iterator.next()).loginError(string);
        }
    }

    public void sendUnauthorized() {
        Iterator iterator = this.backend.getListeners(LoginListener.class);
        while (iterator.hasNext()) {
            ((LoginListener)iterator.next()).unauthorized();
        }
    }

    public synchronized void connected(String string, String string2) {
        if (!this.abort) {
            System.out.println(string2);
            if (string2 != null && PluginsInfo.isPluginLoaded("xmpp")) {
                ConnectionPacketReceiver connectionPacketReceiver = this.xmpp.getConnectionPacketReceiver(this.loginInfo, this);
                this.jabberHandler.changePacketReceiver(connectionPacketReceiver);
                connectionPacketReceiver.connected(string, string2);
            } else {
                this.jabberHandler.changePacketReceiver(this);
                this.socket = null;
                this.sendLoginStatus(3);
                this.connectionID = string;
                System.out.println(string);
                this.output.send(new InfoQuery(null, "get", new IQAuth(this.loginInfo.getUsername().toLowerCase(), null, null)));
                this.sendLoginMessage(I18N.gettext("main.loginstatus.Getting_available_login_methods") + "...");
            }
        }
    }

    public void authenticate(IQAuth iQAuth) {
        if (!this.abort) {
            this.sendLoginStatus(4);
            this.sendLoginMessage(I18N.gettext("main.loginstatus.Authenticating") + "...");
            this.authenticationId = "Jeti_Auth_" + new Date().getTime();
            if (iQAuth.hasDigest()) {
                MessageDigest messageDigest = null;
                try {
                    messageDigest = MessageDigest.getInstance("SHA");
                }
                catch (Exception exception) {
                    Log.error(I18N.gettext("main.loginstatus.Could_not_login_with_SHA"));
                    this.output.send(new InfoQuery(null, "set", this.authenticationId, new IQAuth(this.loginInfo.getUsername().toLowerCase(), this.loginInfo.getPassword(), this.loginInfo.getResource())));
                    return;
                }
                messageDigest.update(this.connectionID.getBytes());
                String string = Utils.toString(messageDigest.digest(this.loginInfo.getPassword().getBytes()));
                IQAuthBuilder iQAuthBuilder = new IQAuthBuilder();
                iQAuthBuilder.digest = string;
                iQAuthBuilder.username = this.loginInfo.getUsername().toLowerCase();
                iQAuthBuilder.resource = this.loginInfo.getResource();
                this.output.send(new InfoQuery(null, "set", this.authenticationId, (IQExtension)((Object)iQAuthBuilder.build())));
            } else {
                int n;
                if (!this.loginInfo.isSSl() && (n = JOptionPane.showConfirmDialog(null, I18N.gettext("main.loginstatus.Sending_password_as_plain_text_over_an_unencrypted_connection,_continue?"), "Plain text", 0)) == 1) {
                    this.sendLoginError("Sending password in plain not allowed");
                    return;
                }
                this.output.send(new InfoQuery(null, "set", this.authenticationId, new IQAuth(this.loginInfo.getUsername().toLowerCase(), this.loginInfo.getPassword(), this.loginInfo.getResource())));
            }
        }
    }

    public void authenticated(InfoQuery infoQuery) {
        if (!this.abort) {
            this.sendLoginMessage(I18N.gettext("main.loginstatus.Authenticated") + "...");
            if (infoQuery.getType().equals("error")) {
                if (infoQuery.getErrorCode() == 401) {
                    this.sendUnauthorized();
                } else {
                    this.sendLoginError(I18N.gettext("main.loginstatus.Not_logged_in_because") + " " + infoQuery.getErrorDescription());
                }
                return;
            }
            JID jID = new JID(this.loginInfo.getUsername().toLowerCase(), this.loginInfo.getServer(), this.loginInfo.getResource());
            this.authenticated(jID);
        }
    }

    public void authenticated(JID jID) {
        myJID = jID;
        this.iqTimerQueue.clear();
        this.jabberHandler.changePacketReceiver(new Jabber(this.backend, this.capabilities, this.discovery, this.iqTimerQueue));
        this.authenticated = true;
        this.reconnecting = false;
        this.output.setAuthenticated();
        this.sendLoginMessage(I18N.gettext("main.loginstatus.Loading_roster") + "...");
        this.getItems(new JID(this.loginInfo.getServer()), new DiscoveryListener(){

            public void discoveryItemResult(JID jID, DiscoveryItem discoveryItem) {
                if (discoveryItem.hasItems()) {
                    Iterator iterator = discoveryItem.getItems();
                    while (iterator.hasNext()) {
                        DiscoveryItem discoveryItem2 = (DiscoveryItem)iterator.next();
                        Connect.this.backend.getInfo(discoveryItem2.getJID(), null);
                    }
                }
            }

            public void discoveryInfoResult(JID jID, DiscoveryInfo discoveryInfo) {
            }
        });
        this.output.send(new InfoQuery("get", new IQPrivate(new JetiPrivateExtension())));
        this.output.send(new InfoQuery("get", new IQXRoster()));
        if (this.show == 0) {
            this.show = 2;
        }
        this.latestConnected = System.currentTimeMillis();
    }

    public void connected() {
        this.sendLoginMessage(I18N.gettext("main.loginstatus.Logged_in"));
        this.sendStatus();
        Avatars avatars = this.getAvatarInterface();
        if (avatars != null) {
            avatars.getVCard(this);
        }
        this.send(new InfoQuery("get", new IQPrivate(new JetiPrivateRosterExtension())));
        Iterator iterator = this.backend.getListeners(StatusChangeListener.class);
        while (iterator.hasNext()) {
            ((StatusChangeListener)iterator.next()).connectionChanged(true);
        }
        this.sendLoginStatus(5);
    }

    public void receivePackets(Packet packet) {
        IQExtension iQExtension;
        if (packet instanceof StreamError) {
            this.streamError((StreamError)packet);
        } else if (this.authenticationId.equals(packet.getID())) {
            this.authenticated((InfoQuery)packet);
        } else if (packet instanceof InfoQuery && (iQExtension = packet.getIQExtension()) instanceof IQAuth) {
            if (((InfoQuery)packet).getType().equals("error")) {
                this.sendLoginError(packet.getErrorDescription());
            } else {
                this.authenticate((IQAuth)iQExtension);
            }
        }
    }

    public void inputDeath() {
        System.out.println("input death");
        try {
            if (this.socket != null) {
                this.socket.close();
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        if (this.authenticated || this.reconnecting) {
            this.authenticated = false;
            if (this.reconnecting) {
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            this.reconnecting = true;
            this.output.disconnect(true);
            Iterator iterator = this.backend.getListeners(StatusChangeListener.class);
            while (iterator.hasNext()) {
                ((StatusChangeListener)iterator.next()).connectionChanged(false);
            }
            this.reconnect();
        }
        this.sendLoginError(I18N.gettext("main.loginstatus.Lost_Input"));
    }

    public void streamError(StreamError streamError) {
        if (this.authenticated) {
            this.authenticated = false;
            this.output.disconnect(true);
            Iterator iterator = this.backend.getListeners(StatusChangeListener.class);
            while (iterator.hasNext()) {
                ((StatusChangeListener)iterator.next()).connectionChanged(false);
            }
        }
        this.sendLoginError(streamError.getErrorDescription());
    }

    public void outputDeath() {
        this.authenticated = false;
        Iterator iterator = this.backend.getListeners(StatusChangeListener.class);
        while (iterator.hasNext()) {
            ((StatusChangeListener)iterator.next()).connectionChanged(false);
        }
        this.reconnect();
    }

    public static JID getMyJID() {
        return myJID;
    }

    public boolean getOnline() {
        return this.authenticated;
    }

    public void disconnect() {
        if (this.authenticated) {
            this.send(new Presence(myJID, "unavailable"));
            this.authenticated = false;
            this.output.disconnect(true);
        }
        this.output = null;
        Iterator iterator = this.backend.getListeners(StatusChangeListener.class);
        while (iterator.hasNext()) {
            ((StatusChangeListener)iterator.next()).connectionChanged(false);
        }
    }

    public void exit() {
        if (this.authenticated) {
            this.send(new Presence(myJID, "unavailable"));
            this.authenticated = false;
            this.output.disconnect(true);
        }
        this.output = null;
        Iterator iterator = this.backend.getListeners(StatusChangeListener.class);
        while (iterator.hasNext()) {
            ((StatusChangeListener)iterator.next()).exit();
        }
    }

    public void send(Packet packet) {
        if (this.authenticated) {
            this.output.send(packet);
        } else {
            Log.notSend(packet.toString());
        }
    }

    public void sendWhileConnecting(Packet packet) {
        this.output.send(packet);
    }

    public String getAccountInfo() {
        return MessageFormat.format(I18N.gettext("main.popup.logged_in_as_{0}_on_server_{1}_with_resource_{2}"), this.loginInfo.getUsername(), this.loginInfo.getServer(), this.loginInfo.getResource());
    }

    public void sendStatus() {
        if (!this.authenticated) {
            if (this.loginInfo == null) {
                return;
            }
            new LoginStatusWindow(this.loginInfo, this.backend, 1);
        } else {
            PresenceBuilder presenceBuilder = new PresenceBuilder();
            presenceBuilder.show = this.show;
            presenceBuilder.status = this.status;
            presenceBuilder.priority = this.loginInfo.getPriority();
            Avatars avatars = this.getAvatarInterface();
            presenceBuilder.addExtension(this.capabilities.getCaps());
            if (avatars != null) {
                presenceBuilder.addExtension(avatars.addHash());
            }
            if (this.show != 7 && this.openPGP != null) {
                presenceBuilder.addExtension(this.openPGP.signPresence(this.status));
            }
            try {
                this.send(presenceBuilder.build());
            }
            catch (InstantiationException instantiationException) {
                instantiationException.printStackTrace();
            }
            Iterator iterator = this.backend.getListeners(StatusChangeListener.class);
            while (iterator.hasNext()) {
                ((StatusChangeListener)iterator.next()).ownPresenceChanged(this.show, this.status);
            }
        }
        this.sendLoginMessage(I18N.gettext("main.loginstatus.Logged_in"));
        this.sendLoginStatus(5);
    }

    private Avatars getAvatarInterface() {
        if (this.avatars != null) {
            return this.avatars;
        }
        if (PluginsInfo.isPluginLoaded("ichatavatars")) {
            this.avatars = (Avatars)PluginsInfo.getPluginInstance("ichatavatars");
            return this.avatars;
        }
        return null;
    }

    public void changeStatus(int n, String string) {
        this.show = n;
        this.status = string;
        this.sendStatus();
    }

    private static class DummyTrustManager
    implements X509TrustManager {
        private DummyTrustManager() {
        }

        public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) {
        }

        public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) {
            try {
                x509CertificateArray[0].checkValidity();
            }
            catch (CertificateExpiredException certificateExpiredException) {
            }
            catch (CertificateNotYetValidException certificateNotYetValidException) {
                // empty catch block
            }
        }

        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }
    }

    public static class DummySSLSocketFactory
    extends SSLSocketFactory {
        private SSLSocketFactory factory;

        public DummySSLSocketFactory() {
            try {
                SSLContext sSLContext = SSLContext.getInstance("TLS");
                sSLContext.init(null, new TrustManager[]{new DummyTrustManager()}, new SecureRandom());
                this.factory = sSLContext.getSocketFactory();
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                noSuchAlgorithmException.printStackTrace();
            }
            catch (KeyManagementException keyManagementException) {
                keyManagementException.printStackTrace();
            }
        }

        public Socket createSocket(Socket socket, String string, int n, boolean bl) throws IOException {
            return this.factory.createSocket(socket, string, n, bl);
        }

        public Socket createSocket(InetAddress inetAddress, int n, InetAddress inetAddress2, int n2) throws IOException {
            return this.factory.createSocket(inetAddress, n, inetAddress2, n2);
        }

        public Socket createSocket(InetAddress inetAddress, int n) throws IOException {
            return this.factory.createSocket(inetAddress, n);
        }

        public Socket createSocket(String string, int n, InetAddress inetAddress, int n2) throws IOException {
            return this.factory.createSocket(string, n, inetAddress, n2);
        }

        public Socket createSocket(String string, int n) throws IOException {
            Socket socket = this.factory.createSocket(string, n);
            ((SSLSocket)socket).addHandshakeCompletedListener(new HandshakeCompletedListener(){

                public void handshakeCompleted(HandshakeCompletedEvent handshakeCompletedEvent) {
                    System.out.println("Handshake finished!");
                    System.out.println("\t CipherSuite:" + handshakeCompletedEvent.getCipherSuite());
                    System.out.println("\t SessionId " + handshakeCompletedEvent.getSession());
                    System.out.println("\t PeerHost " + handshakeCompletedEvent.getSession().getPeerHost());
                }
            });
            return socket;
        }

        public String[] getDefaultCipherSuites() {
            return this.factory.getSupportedCipherSuites();
        }

        public String[] getSupportedCipherSuites() {
            return this.factory.getSupportedCipherSuites();
        }
    }
}

