/*
 * Decompiled with CFR 0.152.
 */
package nu.fw.jeti.applet;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import nu.fw.jeti.applet.Jeti;
import nu.fw.jeti.backend.LoginInfo;
import nu.fw.jeti.images.StatusIcons;
import nu.fw.jeti.jabber.Backend;
import nu.fw.jeti.jabber.elements.DiscoItem;
import nu.fw.jeti.ui.LoginStatusWindow;
import nu.fw.jeti.util.I18N;
import nu.fw.jeti.util.Preferences;
import nu.fw.jeti.util.QueryServers;

public class LoginWindow
extends JPanel {
    private JTextField txtUser = new JTextField();
    private JTextField txtPassword = new JPasswordField();
    private JComboBox cmbServer = new JComboBox();
    private JTextField txtResource = new JTextField();
    private JPanel jPanel1 = new JPanel();
    private JCheckBox chkSSL = new JCheckBox();
    private JSpinner spinner = new JSpinner(new SpinnerNumberModel(0, -128, 127, 1));
    private JPanel jPanel2 = new JPanel();
    private JTextField txtPort = new JTextField("5222");
    private JButton btnLogin = new JButton();
    private JButton btnRegister = new JButton();
    private Backend backend;
    private JFrame window;

    public LoginWindow(Backend backend, LoginInfo loginInfo) {
        this.backend = backend;
        this.txtUser.setText(loginInfo.getUsername());
        this.txtResource.setText(loginInfo.getResource());
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.cmbServer.setSelectedItem(loginInfo.getServer());
        this.createWindow();
        this.window.setTitle(I18N.gettext("main.login.Wrong_Password_Try_again"));
    }

    public LoginWindow(Backend backend) {
        this(backend, true);
    }

    public LoginWindow(Backend backend, boolean bl) {
        this.backend = backend;
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (Jeti.loginInfo != null) {
            this.txtUser.setText(Jeti.loginInfo.getUsername());
            this.txtResource.setText(Jeti.loginInfo.getResource());
            this.cmbServer.setSelectedItem(Jeti.loginInfo.getServer());
            this.txtPort.setText("" + Jeti.loginInfo.getPort());
            this.chkSSL.setSelected(Jeti.loginInfo.isSSl());
        }
        if (bl) {
            this.createWindow();
            this.window.setTitle(I18N.gettext("main.login.Login"));
        }
    }

    private void createWindow() {
        this.window = new JFrame();
        this.window.getContentPane().add(this);
        this.window.setIconImage(StatusIcons.getImageIcon("jeti").getImage());
        this.window.setDefaultCloseOperation(2);
        this.window.setResizable(false);
        this.window.pack();
        this.window.setLocationRelativeTo(null);
        this.window.getRootPane().setDefaultButton(this.btnLogin);
        this.window.setVisible(true);
    }

    private void jbInit() throws Exception {
        I18N.setTextAndMnemonic("main.EditProfile.Register", this.btnRegister);
        this.btnRegister.setToolTipText(I18N.gettext("main.EditProfile.Request_new_account"));
        this.txtResource.setText("JetiApplet");
        this.setLayout(new BoxLayout(this, 1));
        JLabel jLabel = new JLabel();
        if (!Preferences.getBoolean("jeti", "hideServerSelect", false)) {
            I18N.setTextAndMnemonic("main.EditProfile.Jabber_Server", jLabel);
            jLabel.setLabelFor(this.cmbServer);
            this.add((Component)jLabel, "North");
            this.add(this.cmbServer);
            this.cmbServer.addItem("");
            this.cmbServer.setAlignmentX(0.0f);
        }
        this.cmbServer.setEditable(true);
        Object object = QueryServers.getServers().iterator();
        while (object.hasNext()) {
            DiscoItem discoItem = (DiscoItem)object.next();
            this.cmbServer.addItem(discoItem.getJID().getDomain());
        }
        jLabel = new JLabel();
        I18N.setTextAndMnemonic("main.EditProfile.Username", jLabel);
        jLabel.setLabelFor(this.txtUser);
        this.add(jLabel);
        this.add(this.txtUser);
        jLabel = new JLabel();
        I18N.setTextAndMnemonic("main.EditProfile.Password", jLabel);
        jLabel.setLabelFor(this.txtPassword);
        this.add(jLabel);
        this.add(this.txtPassword);
        if (!Preferences.getBoolean("jeti", "hideResourceInput", false)) {
            object = new JPanel(new GridLayout(2, 2));
            jLabel = new JLabel();
            I18N.setTextAndMnemonic("main.EditProfile.Resource", jLabel);
            jLabel.setLabelFor(this.txtResource);
            ((Container)object).add(jLabel);
            jLabel = new JLabel();
            I18N.setTextAndMnemonic("main.EditProfile.Priority", jLabel);
            jLabel.setLabelFor(this.spinner);
            ((Container)object).add(jLabel);
            ((Container)object).add((Component)this.txtResource, null);
            ((Container)object).add(this.spinner);
            ((JComponent)object).setAlignmentX(0.0f);
            this.add((Component)object);
        }
        if (!Preferences.getBoolean("jeti", "hidePortSelect", false)) {
            I18N.setTextAndMnemonic("main.EditProfile.Use_SSL", this.chkSSL);
            jLabel = new JLabel();
            I18N.setTextAndMnemonic("main.EditProfile.Port", jLabel);
            this.jPanel2.add(jLabel);
            jLabel.setLabelFor(this.txtPort);
            this.jPanel2.add(this.txtPort);
            this.jPanel2.add(this.chkSSL);
            this.jPanel2.setAlignmentX(0.0f);
            this.txtPort.setPreferredSize(new Dimension(80, 21));
            this.add(this.jPanel2);
        }
        this.btnRegister.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LoginWindow.this.btnRegister_actionPerformed(actionEvent);
            }
        });
        this.btnLogin.setText(I18N.gettext("main.login.Login"));
        this.btnLogin.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LoginWindow.this.btnLogin_actionPerformed(actionEvent);
            }
        });
        this.jPanel1.setAlignmentX(0.0f);
        if (!Preferences.getBoolean("jeti", "hideRegisterButton", false)) {
            this.jPanel1.add(this.btnRegister);
        }
        this.jPanel1.add(this.btnLogin);
        this.add(this.jPanel1);
    }

    void btnLogin_actionPerformed(ActionEvent actionEvent) {
        if (!this.txtUser.getText().equals("") && !this.cmbServer.getSelectedItem().equals("")) {
            int n;
            try {
                n = Integer.parseInt(this.txtPort.getText());
            }
            catch (NumberFormatException numberFormatException) {
                n = this.chkSSL.isSelected() ? 5223 : 5222;
            }
            String string = this.txtResource.getText();
            if (string.equals("")) {
                string = "JetiApplet";
            }
            LoginInfo loginInfo = new LoginInfo((String)this.cmbServer.getSelectedItem(), null, this.txtUser.getText(), this.txtPassword.getText(), string, n, this.chkSSL.isSelected(), ((Number)this.spinner.getValue()).intValue());
            new LoginStatusWindow(loginInfo, this.backend, 1);
            if (this.window != null) {
                this.window.dispose();
            }
        }
    }

    void btnRegister_actionPerformed(ActionEvent actionEvent) {
        String string = (String)this.cmbServer.getSelectedItem();
        if (string == null || string.equals("")) {
            string = JOptionPane.showInputDialog(this, I18N.gettext("main.EditProfile.Jabber_Server"), I18N.gettext("main.EditProfile.Create_New_Account"), 3);
        }
        if (string == null || string.equals("")) {
            return;
        }
        int n = 5222;
        if (Jeti.loginInfo != null) {
            n = Jeti.loginInfo.getPort();
        }
        this.backend.newAccount(string, n, this.txtUser.getText(), this.txtPassword.getText());
    }
}

