/*
 * Decompiled with CFR 0.152.
 */
package nu.fw.jeti.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.LinkedList;
import java.util.List;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import nu.fw.jeti.backend.Start;
import nu.fw.jeti.jabber.JID;
import nu.fw.jeti.jabber.elements.DiscoItem;
import nu.fw.jeti.util.Log;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class QueryServers {
    private static List servers;

    public static List getServers() {
        if (servers == null) {
            QueryServers.readServerXML();
        }
        return servers;
    }

    private static void readServerXML() {
        SAXParser sAXParser = null;
        try {
            sAXParser = SAXParserFactory.newInstance().newSAXParser();
        }
        catch (FactoryConfigurationError factoryConfigurationError) {
            factoryConfigurationError.printStackTrace();
        }
        catch (SAXException sAXException) {
            sAXException.printStackTrace();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            parserConfigurationException.printStackTrace();
        }
        InputStream inputStream = null;
        try {
            inputStream = new URL(Start.dataURL + "servers.xml").openStream();
        }
        catch (IOException iOException) {
            inputStream = QueryServers.class.getResourceAsStream("/servers.xml");
        }
        LinkedList linkedList = new LinkedList();
        if (inputStream != null) {
            try {
                sAXParser.parse(inputStream, (DefaultHandler)new DiscoItemsHandler(linkedList));
            }
            catch (SAXException sAXException) {
                sAXException.printStackTrace();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        servers = linkedList;
    }

    static class DiscoItemsHandler
    extends DefaultHandler {
        private List items;

        public DiscoItemsHandler(List list) {
            this.items = list;
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) {
            if (string3.equals("item")) {
                if (this.items == null) {
                    this.items = new LinkedList();
                }
                try {
                    JID jID = JID.checkedJIDFromString(attributes.getValue("jid"));
                    this.items.add(new DiscoItem(jID, attributes.getValue("name"), attributes.getValue("node"), attributes.getValue("action")));
                }
                catch (InstantiationException instantiationException) {
                    Log.xmlParseException(instantiationException);
                }
            }
        }
    }
}

