/*
 * Decompiled with CFR 0.152.
 */
package nu.fw.jeti.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.UIManager;
import nu.fw.jeti.backend.Start;
import nu.fw.jeti.backend.URLClassloader;
import nu.fw.jeti.util.Preferences;

public class I18N {
    private static ResourceBundle jetiBundle;
    private static Map pluginsBundle;
    private Language[] languages;
    private Map countries = new HashMap();

    public I18N() {
        if (Start.applet || Start.webstart) {
            try {
                String string;
                BufferedReader bufferedReader = null;
                InputStream inputStream = this.getClass().getResourceAsStream("/languages/list.txt");
                if (inputStream == null) {
                    return;
                }
                bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
                LinkedList<Locale> linkedList = new LinkedList<Locale>();
                while ((string = bufferedReader.readLine()) != null) {
                    linkedList.add(new Locale(string));
                }
                bufferedReader.close();
                this.extractLanguages(linkedList);
                this.extractCountries();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        } else {
            this.extractLanguages(this.searchTranslations());
            this.extractCountries();
        }
    }

    private List searchTranslations() {
        String string = Start.path + "languages" + File.separator;
        File file = new File(string);
        File[] fileArray = file.listFiles();
        LinkedList<Locale> linkedList = new LinkedList<Locale>();
        if (fileArray == null) {
            return linkedList;
        }
        for (int i = 0; i < fileArray.length; ++i) {
            Locale locale = this.getLocale(fileArray[i].getName());
            if (locale == null) continue;
            linkedList.add(locale);
        }
        return linkedList;
    }

    private Locale getLocale(String string) {
        if (!string.startsWith("jeti") || !string.endsWith(".properties")) {
            return null;
        }
        int n = "jeti".length();
        String string2 = "";
        switch (string.length() - n - 11) {
            case 6: {
                if (string.charAt(3 + n) != '_') {
                    return null;
                }
                string2 = string.substring(n + 4, n + 6);
            }
            case 3: {
                if (string.charAt(n) != '_') {
                    return null;
                }
                String string3 = string.substring(n + 1, n + 3);
                Locale locale = new Locale(string3, string2);
                return locale;
            }
        }
        return null;
    }

    private void extractLanguages(List list) {
        Object object;
        Object object2;
        HashSet<Language> hashSet = new HashSet<Language>();
        Object object3 = list.iterator();
        while (object3.hasNext()) {
            object2 = (Locale)object3.next();
            object = ((Locale)object2).getLanguage();
            ArrayList<Country> arrayList = (ArrayList<Country>)this.countries.get(object);
            if (arrayList == null) {
                arrayList = new ArrayList<Country>();
                this.countries.put(object, arrayList);
            }
            arrayList.add(new Country((Locale)object2));
            hashSet.add(new Language((Locale)object2));
        }
        object3 = Locale.getDefault();
        object2 = ((Locale)object3).getLanguage();
        object = (List)this.countries.get(object2);
        if (object == null) {
            object = new ArrayList();
            this.countries.put(object2, object);
        }
        hashSet.add(new Language((Locale)object3));
        this.languages = hashSet.toArray(new Language[0]);
    }

    private void extractCountries() {
        Locale[] localeArray = Locale.getAvailableLocales();
        for (int i = 0; i < localeArray.length; ++i) {
            String string = localeArray[i].getLanguage();
            for (int j = 0; j < this.languages.length; ++j) {
                Country country;
                List list;
                if (!string.equals(this.languages[j].getLanguageCode()) || (list = (List)this.countries.get(string)).contains(country = new Country(localeArray[i]))) continue;
                list.add(country);
            }
        }
    }

    public Language[] getLanguages() {
        return this.languages;
    }

    public Map getCountries() {
        return this.countries;
    }

    public static String getText(String string, String string2) {
        ResourceBundle resourceBundle = (ResourceBundle)pluginsBundle.get(string);
        if (resourceBundle == null) {
            resourceBundle = jetiBundle;
        }
        return I18N.getText(resourceBundle, string2);
    }

    public static String gettext(String string) {
        return I18N.getText(jetiBundle, string);
    }

    private static String getText(ResourceBundle resourceBundle, String string) {
        if (string == null) {
            return null;
        }
        String string2 = I18N.getTextWithAmp(resourceBundle, string);
        int n = string2.indexOf("&");
        if (n > -1) {
            string2 = string2.substring(0, n) + string2.substring(n + 1, string2.length());
        }
        return string2;
    }

    public static String getTextWithAmp(String string) {
        return I18N.getTextWithAmp(jetiBundle, string);
    }

    private static String getTextWithAmp(ResourceBundle resourceBundle, String string) {
        int n;
        if (string == null) {
            return null;
        }
        if (resourceBundle != null) {
            try {
                return (String)resourceBundle.getObject(string);
            }
            catch (MissingResourceException missingResourceException) {
                System.out.println(string + " is not translated");
            }
        }
        if ((n = string.lastIndexOf(46)) > 0) {
            string = string.substring(n + 1);
        }
        return string.replace('_', ' ');
    }

    public static void setTextAndMnemonic(String string, JLabel jLabel) {
        I18N.setTextAndMnemonic(string, jLabel, false);
    }

    public static void setTextAndMnemonic(String string, JLabel jLabel, boolean bl) {
        String string2;
        String string3 = string2 = I18N.getTextWithAmp(string);
        int n = string2.indexOf("&");
        if (n > -1) {
            string3 = string2.substring(0, n) + string2.substring(n + 1, string2.length());
        }
        if (bl) {
            string3 = string3 + "...";
        }
        jLabel.setText(string3);
        n = I18N.getMnemonicPosition(string2);
        if (n > -1) {
            jLabel.setDisplayedMnemonic(string2.charAt(n));
        }
        if (n > 0) {
            jLabel.setDisplayedMnemonicIndex(n - 1);
        }
    }

    public static void setMnemonic(String string, JLabel jLabel) {
        String string2 = I18N.getTextWithAmp(string);
        int n = I18N.getMnemonicPosition(string2);
        if (n > -1) {
            jLabel.setDisplayedMnemonic(string2.charAt(n));
        }
        if (n > 1) {
            jLabel.setDisplayedMnemonicIndex(n - 1);
        }
    }

    public static void setMnemonic(String string, AbstractButton abstractButton) {
        String string2 = I18N.getTextWithAmp(string);
        int n = I18N.getMnemonicPosition(string2);
        if (n > -1) {
            abstractButton.setMnemonic(string2.charAt(n));
        }
        if (n > 1) {
            abstractButton.setDisplayedMnemonicIndex(n - 1);
        }
    }

    public static void setTextAndMnemonic(String string, AbstractButton abstractButton) {
        I18N.setTextAndMnemonic(string, abstractButton, false);
    }

    public static void setTextAndMnemonic(String string, AbstractButton abstractButton, boolean bl) {
        String string2;
        String string3 = string2 = I18N.getTextWithAmp(string);
        int n = string2.indexOf("&");
        if (n > -1) {
            string3 = string2.substring(0, n) + string2.substring(n + 1, string2.length());
        }
        if (bl) {
            string3 = string3 + "...";
        }
        abstractButton.setText(string3);
        n = I18N.getMnemonicPosition(string2);
        if (n > -1) {
            abstractButton.setMnemonic(string2.charAt(n));
        }
        if (n > 0) {
            abstractButton.setDisplayedMnemonicIndex(n - 1);
        }
    }

    private static int getMnemonicPosition(String string) {
        int n = string.indexOf("&");
        if (n >= 0) {
            return n + 1;
        }
        return -1;
    }

    public static void init() {
        Object object;
        ClassLoader classLoader = null;
        if (!Start.applet && !Start.webstart) {
            try {
                object = new URL(Start.programURL, "languages/");
                classLoader = new URLClassloader(new URL[]{object}, I18N.class.getClassLoader());
            }
            catch (MalformedURLException malformedURLException) {
                malformedURLException.printStackTrace();
            }
        } else {
            classLoader = I18N.class.getClassLoader();
        }
        object = Preferences.getString("jeti", "language", "");
        String string = Preferences.getString("jeti", "country", "");
        Locale locale = null;
        locale = object != "" ? new Locale((String)object, string) : Locale.getDefault();
        jetiBundle = I18N.loadLanguage("jeti", classLoader, locale);
        if (jetiBundle == null || jetiBundle.getLocale().getLanguage().equals("")) {
            locale = new Locale(Locale.ENGLISH.getLanguage(), string);
            System.out.println("lang not found, default: " + locale);
            jetiBundle = I18N.loadLanguage("jeti", classLoader, locale);
        }
        pluginsBundle = new HashMap();
        pluginsBundle.put("drawing", I18N.loadLanguage("drawing", classLoader, locale));
        JComponent.setDefaultLocale(locale);
        UIManager.put("OptionPane.okButtonText", I18N.gettext("OK"));
        UIManager.put("OptionPane.cancelButtonText", I18N.gettext("Cancel"));
    }

    private static ResourceBundle loadLanguage(String string, ClassLoader classLoader, Locale locale) {
        try {
            return ResourceBundle.getBundle("languages/" + string, locale);
        }
        catch (MissingResourceException missingResourceException) {
            try {
                return ResourceBundle.getBundle(string, locale, classLoader);
            }
            catch (MissingResourceException missingResourceException2) {
                System.out.println(missingResourceException2.getMessage());
                return null;
            }
        }
    }

    public static class Language {
        private String language;
        private String languageCode;

        public Language(Locale locale) {
            this.language = locale.getDisplayLanguage();
            this.languageCode = locale.getLanguage();
        }

        public String getLanguageCode() {
            return this.languageCode;
        }

        public String toString() {
            return this.language;
        }

        public boolean equals(Object object) {
            return this.language.equals(((Language)object).language);
        }

        public int hashCode() {
            return this.language.hashCode();
        }
    }

    public static class Country {
        private String country;
        private String countryCode;

        public Country(Locale locale) {
            this.country = locale.getDisplayCountry();
            if (this.country.equals("")) {
                this.country = I18N.gettext("main.options.standard.Other");
            }
            this.countryCode = locale.getCountry();
        }

        public String getCountryCode() {
            return this.countryCode;
        }

        public String toString() {
            return this.country;
        }
    }
}

