/*
 * Decompiled with CFR 0.152.
 */
package nu.fw.jeti.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JToolTip;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import nu.fw.jeti.backend.roster.JIDStatusGroup;
import nu.fw.jeti.backend.roster.JIDStatusTree;
import nu.fw.jeti.backend.roster.PrimaryJIDStatus;
import nu.fw.jeti.images.StatusIcons;
import nu.fw.jeti.jabber.Backend;
import nu.fw.jeti.jabber.JID;
import nu.fw.jeti.jabber.JIDStatus;
import nu.fw.jeti.jabber.elements.IQLast;
import nu.fw.jeti.jabber.elements.IQTime;
import nu.fw.jeti.jabber.elements.IQVersion;
import nu.fw.jeti.jabber.elements.IQXRoster;
import nu.fw.jeti.jabber.elements.InfoQuery;
import nu.fw.jeti.jabber.elements.JetiPrivateRosterExtension;
import nu.fw.jeti.jabber.elements.Presence;
import nu.fw.jeti.jabber.elements.RosterItem;
import nu.fw.jeti.plugins.Avatars;
import nu.fw.jeti.plugins.PluginsInfo;
import nu.fw.jeti.plugins.RosterMenuListener;
import nu.fw.jeti.ui.GroupDialog;
import nu.fw.jeti.ui.Jeti;
import nu.fw.jeti.ui.SendMessage;
import nu.fw.jeti.util.I18N;
import nu.fw.jeti.util.Preferences;
import nu.fw.jeti.util.TreeExpander;

public class RosterTree
extends JTree {
    private Backend backend;
    private JPopupMenu popupMenu;
    private JPopupMenu groupPopupMenu;
    private JIDStatus currentJIDStatus;
    private JIDStatusGroup currentJIDStatusGroup2;
    private JIDStatusGroup currentJIDStatusGroup;
    private boolean onlineTree;
    private Jeti main;
    private String currentGroup;
    private Map menuItems;
    private TreeExpander treeExpander;
    private Avatars avatars;
    JIDStatus tooltipjids;

    public RosterTree(Backend backend, Jeti jeti, boolean bl, TreeModel treeModel) {
        super(treeModel);
        this.onlineTree = bl;
        this.backend = backend;
        this.main = jeti;
        ToolTipManager.sharedInstance().registerComponent(this);
        this.setRootVisible(false);
        this.setToggleClickCount(0);
        BasicTreeUI basicTreeUI = (BasicTreeUI)this.getUI();
        basicTreeUI.setRightChildIndent(1);
        basicTreeUI.setLeftChildIndent(1);
        basicTreeUI.setExpandedIcon(null);
        basicTreeUI.setCollapsedIcon(null);
        this.putClientProperty("JTree.lineStyle", "None");
        this.createPopupMenu();
        this.createGroupPopupMenu();
        if (UIManager.getLookAndFeel().isNativeLookAndFeel()) {
            this.setCellRenderer(new MacRenderer());
            if (bl) {
                this.treeExpander = new TreeExpander(this, treeModel);
            }
        } else {
            this.setCellRenderer(new MyRenderer());
        }
        this.addMouseListener(new MouseAdapter(){
            TreePath lastTreePath;
            Timer timer = new Timer(300, new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (RosterTree.this.isExpanded(lastTreePath)) {
                        RosterTree.this.collapsePath(lastTreePath);
                    } else {
                        RosterTree.this.expandPath(lastTreePath);
                    }
                    timer.stop();
                }
            });

            public void mousePressed(MouseEvent mouseEvent) {
                TreePath treePath = RosterTree.this.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
                if (treePath != null) {
                    RosterTree.this.setSelectionPath(treePath);
                    Object object = treePath.getLastPathComponent();
                    if (object instanceof JIDStatusGroup) {
                        RosterTree.this.maybeShowGroupPopup(mouseEvent, (JIDStatusGroup)object);
                        if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
                            if (RosterTree.this.isExpanded(treePath)) {
                                RosterTree.this.collapsePath(treePath);
                            } else {
                                RosterTree.this.expandPath(treePath);
                            }
                        }
                    } else {
                        JIDStatusGroup jIDStatusGroup = null;
                        JIDStatus jIDStatus = null;
                        if (object instanceof PrimaryJIDStatus) {
                            jIDStatusGroup = (JIDStatusGroup)treePath.getPathComponent(treePath.getPathCount() - 2);
                            jIDStatus = ((PrimaryJIDStatus)object).getJIDPrimaryStatus();
                        } else if (object instanceof JIDStatus) {
                            jIDStatusGroup = (JIDStatusGroup)treePath.getPathComponent(treePath.getPathCount() - 3);
                            jIDStatus = (JIDStatus)object;
                        } else {
                            return;
                        }
                        RosterTree.this.maybeShowPopup(mouseEvent, jIDStatus, jIDStatusGroup);
                        if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
                            this.lastTreePath = treePath;
                            if (this.timer.isRunning()) {
                                this.timer.stop();
                                RosterTree.this.sendChat(jIDStatus);
                            } else {
                                this.timer.restart();
                            }
                        }
                    }
                }
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                TreePath treePath = RosterTree.this.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
                if (treePath != null) {
                    Object object = treePath.getLastPathComponent();
                    if (object instanceof JIDStatusGroup) {
                        RosterTree.this.maybeShowGroupPopup(mouseEvent, (JIDStatusGroup)object);
                    }
                    if (object instanceof PrimaryJIDStatus) {
                        JIDStatusGroup jIDStatusGroup = (JIDStatusGroup)treePath.getPathComponent(treePath.getPathCount() - 2);
                        RosterTree.this.maybeShowPopup(mouseEvent, ((PrimaryJIDStatus)object).getJIDPrimaryStatus(), jIDStatusGroup);
                    } else if (object instanceof JIDStatus) {
                        JIDStatusGroup jIDStatusGroup = (JIDStatusGroup)treePath.getPathComponent(treePath.getPathCount() - 3);
                        RosterTree.this.maybeShowPopup(mouseEvent, (JIDStatus)object, jIDStatusGroup);
                    }
                }
            }

            public void mouseExited(MouseEvent mouseEvent) {
                RosterTree.this.clearSelection();
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseMoved(MouseEvent mouseEvent) {
                TreePath treePath = RosterTree.this.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
                if (treePath != null) {
                    RosterTree.this.setSelectionPath(treePath);
                }
            }
        });
    }

    public void updateLF() {
        SwingUtilities.updateComponentTreeUI(this.popupMenu);
        SwingUtilities.updateComponentTreeUI(this.groupPopupMenu);
    }

    private void createGroupPopupMenu() {
        this.groupPopupMenu = new JPopupMenu();
        JMenuItem jMenuItem = null;
        jMenuItem = new JMenuItem();
        I18N.setTextAndMnemonic("main.main.rostermenu.Remove", jMenuItem, true);
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (JOptionPane.showConfirmDialog(RosterTree.this.main, MessageFormat.format(I18N.gettext("main.popup.Really_remove_{0}?_All_JIDs_in_this_group_will_be_removed!"), RosterTree.this.currentGroup), I18N.gettext("main.popup.Remove_Group"), 0) == 0) {
                    Iterator iterator = RosterTree.this.currentJIDStatusGroup.iterator();
                    while (iterator.hasNext()) {
                        PrimaryJIDStatus primaryJIDStatus = (PrimaryJIDStatus)iterator.next();
                        if (primaryJIDStatus.hasMultiple()) {
                            Iterator iterator2 = primaryJIDStatus.getOtherJidStatussen();
                            while (iterator2.hasNext()) {
                                this.groupRemove((JIDStatus)iterator2.next());
                            }
                        }
                        this.groupRemove(primaryJIDStatus.getJIDPrimaryStatus());
                    }
                }
            }

            private void groupRemove(JIDStatus jIDStatus) {
                JID jID = jIDStatus.getJID();
                if (jIDStatus.groupCount() == 1) {
                    if (JOptionPane.showConfirmDialog(RosterTree.this.main, MessageFormat.format(I18N.gettext("main.popup.{0}_is_in_the_last_group,_remove_completely?"), jID.toString()), I18N.gettext("main.main.rostermenu.Remove"), 0) == 0) {
                        IQXRoster iQXRoster = new IQXRoster(new RosterItem(jID, null, "remove", null, null));
                        RosterTree.this.backend.send(new InfoQuery("set", iQXRoster));
                    }
                } else {
                    List list = jIDStatus.getGroupsCopy();
                    list.remove(RosterTree.this.currentGroup);
                    IQXRoster iQXRoster = new IQXRoster(new RosterItem(jID, jIDStatus.getNick(), null, null, list));
                    RosterTree.this.backend.send(new InfoQuery("set", iQXRoster));
                }
            }
        });
        this.groupPopupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem();
        I18N.setTextAndMnemonic("main.main.rostermenu.Rename", jMenuItem, true);
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = JOptionPane.showInputDialog(RosterTree.this.main, (Object)MessageFormat.format(I18N.gettext("main.popup.Rename_{0}_to"), RosterTree.this.currentGroup));
                if (string == null) {
                    return;
                }
                Iterator iterator = RosterTree.this.currentJIDStatusGroup.iterator();
                while (iterator.hasNext()) {
                    PrimaryJIDStatus primaryJIDStatus = (PrimaryJIDStatus)iterator.next();
                    if (primaryJIDStatus.hasMultiple()) {
                        Iterator iterator2 = primaryJIDStatus.getOtherJidStatussen();
                        while (iterator2.hasNext()) {
                            this.renameGroup(string, (JIDStatus)iterator2.next());
                        }
                    }
                    this.renameGroup(string, primaryJIDStatus.getJIDPrimaryStatus());
                }
            }

            private void renameGroup(String string, JIDStatus jIDStatus) {
                List list = jIDStatus.getGroupsCopy();
                list.remove(RosterTree.this.currentGroup);
                list.add(string);
                IQXRoster iQXRoster = new IQXRoster(new RosterItem(jIDStatus.getJID(), jIDStatus.getNick(), null, null, list));
                RosterTree.this.backend.send(new InfoQuery("set", iQXRoster));
            }
        });
        this.groupPopupMenu.add(jMenuItem);
    }

    public void createPopupMenu() {
        Object object;
        this.popupMenu = new JPopupMenu();
        JMenuItem jMenuItem = null;
        JMenu jMenu = null;
        jMenuItem = new JMenuItem();
        if (Preferences.getBoolean("jeti", "rostermenuShowMessage", true)) {
            I18N.setTextAndMnemonic("main.main.rostermenu.Message", jMenuItem, true);
            jMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    RosterTree.this.sendMessage(RosterTree.this.currentJIDStatus);
                }
            });
            this.popupMenu.add(jMenuItem);
        }
        if (Preferences.getBoolean("jeti", "rostermenuShowChat", true)) {
            jMenuItem = new JMenuItem();
            I18N.setTextAndMnemonic("main.main.rostermenu.Chat", jMenuItem, true);
            jMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    RosterTree.this.sendChat(RosterTree.this.currentJIDStatus);
                }
            });
            this.popupMenu.add(jMenuItem);
        }
        if (Preferences.getBoolean("jeti", "rostermenuSubscriptions", true)) {
            jMenu = new JMenu(I18N.gettext("main.main.rostermenu.Subscriptions"));
            jMenuItem = new JMenuItem(I18N.gettext("main.main.rostermenu.Subscribe_from"));
            jMenuItem = new JMenuItem();
            I18N.setTextAndMnemonic("main.main.rostermenu.Subscribe_from", jMenuItem);
            jMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    RosterTree.this.backend.send(new Presence(RosterTree.this.currentJIDStatus.getJID(), "subscribe"));
                }
            });
            jMenu.add(jMenuItem);
            jMenuItem = new JMenuItem(I18N.gettext("main.main.rostermenu.Unsubscribe_from"));
            jMenuItem = new JMenuItem();
            I18N.setTextAndMnemonic("main.main.rostermenu.Unsubscribe_from", jMenuItem);
            jMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    RosterTree.this.backend.send(new Presence(RosterTree.this.currentJIDStatus.getJID(), "unsubscribe"));
                }
            });
            jMenu.add(jMenuItem);
            this.popupMenu.add(jMenu);
        }
        if (Preferences.getBoolean("jeti", "rostermenuRemove", true)) {
            jMenuItem = new JMenuItem();
            I18N.setTextAndMnemonic("main.main.rostermenu.Remove", jMenuItem, true);
            jMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    JID jID = RosterTree.this.currentJIDStatus.getJID();
                    if (JOptionPane.showConfirmDialog(RosterTree.this.main, MessageFormat.format(I18N.gettext("main.popup.Really_remove_{0}_from_all_groups_?"), jID.toString()), I18N.gettext("main.main.rostermenu.Remove"), 0) == 0) {
                        IQXRoster iQXRoster = new IQXRoster(new RosterItem(jID, null, "remove", null, null));
                        RosterTree.this.backend.send(new InfoQuery("set", iQXRoster));
                    }
                }
            });
            this.popupMenu.add(jMenuItem);
        }
        if (Preferences.getBoolean("jeti", "rostermenuRename", true)) {
            jMenuItem = new JMenuItem();
            I18N.setTextAndMnemonic("main.main.rostermenu.Rename", jMenuItem, true);
            jMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    String string = JOptionPane.showInputDialog(RosterTree.this.main, (Object)MessageFormat.format(I18N.gettext("main.popup.Rename_{0}_to"), RosterTree.this.currentJIDStatus.getNick()));
                    if (string == null) {
                        return;
                    }
                    IQXRoster iQXRoster = new IQXRoster(new RosterItem(RosterTree.this.currentJIDStatus.getJID(), string, null, null, RosterTree.this.currentJIDStatus.getGroupsCopy()));
                    RosterTree.this.backend.send(new InfoQuery("set", iQXRoster));
                }
            });
            this.popupMenu.add(jMenuItem);
        }
        if (Preferences.getBoolean("jeti", "rostermenuGroup", true)) {
            jMenu = new JMenu();
            I18N.setTextAndMnemonic("main.main.rostermenu.Group", jMenu);
            jMenuItem = new JMenuItem();
            I18N.setTextAndMnemonic("main.main.rostermenu.Change_Group", jMenuItem, true);
            jMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    new GroupDialog(RosterTree.this.currentGroup, RosterTree.this.currentJIDStatus, RosterTree.this.backend).setVisible(true);
                }
            });
            jMenu.add(jMenuItem);
            jMenuItem = new JMenuItem();
            I18N.setTextAndMnemonic("main.main.rostermenu.Add_to_Group", jMenuItem, true);
            jMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    new GroupDialog(RosterTree.this.currentJIDStatus, RosterTree.this.backend).setVisible(true);
                }
            });
            jMenu.add(jMenuItem);
            jMenuItem = new JMenuItem();
            I18N.setTextAndMnemonic("main.main.rostermenu.Remove_from_group", jMenuItem, true);
            jMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    JID jID = RosterTree.this.currentJIDStatus.getJID();
                    if (RosterTree.this.currentJIDStatus.groupCount() == 1) {
                        if (JOptionPane.showConfirmDialog(RosterTree.this.main, MessageFormat.format(I18N.gettext("main.popup.{0}_is_in_the_last_group,_remove_completely?"), jID.toString()), I18N.gettext("main.main.rostermenu.Remove"), 0) == 0) {
                            IQXRoster iQXRoster = new IQXRoster(new RosterItem(jID, null, "remove", null, null));
                            RosterTree.this.backend.send(new InfoQuery("set", iQXRoster));
                        }
                    } else {
                        List list = RosterTree.this.currentJIDStatus.getGroupsCopy();
                        list.remove(RosterTree.this.currentGroup);
                        IQXRoster iQXRoster = new IQXRoster(new RosterItem(jID, RosterTree.this.currentJIDStatus.getNick(), null, null, list));
                        RosterTree.this.backend.send(new InfoQuery("set", iQXRoster));
                    }
                }
            });
            jMenu.add(jMenuItem);
            this.popupMenu.add(jMenu);
        }
        if (this.onlineTree) {
            if (Preferences.getBoolean("jeti", "rostermenuLocalTime", true) && !Preferences.getBoolean("jeti", "privacy", false)) {
                jMenuItem = new JMenuItem();
                I18N.setTextAndMnemonic("main.main.rostermenu.Local_Time", jMenuItem, true);
                jMenuItem.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        RosterTree.this.backend.send(new InfoQuery(RosterTree.this.currentJIDStatus.getCompleteJID(), "get", new IQTime()));
                    }
                });
                this.popupMenu.add(jMenuItem);
            }
            if (Preferences.getBoolean("jeti", "rostermenuLocalVersion", true) && !Preferences.getBoolean("jeti", "privacy", false)) {
                jMenuItem = new JMenuItem();
                I18N.setTextAndMnemonic("main.main.rostermenu.Local_Version", jMenuItem, true);
                jMenuItem.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        RosterTree.this.backend.send(new InfoQuery(RosterTree.this.currentJIDStatus.getCompleteJID(), "get", new IQVersion()));
                    }
                });
                this.popupMenu.add(jMenuItem);
            }
        } else if (Preferences.getBoolean("jeti", "rostermenuLastSeen", true)) {
            jMenuItem = new JMenuItem();
            I18N.setTextAndMnemonic("main.main.rostermenu.Last_Seen", jMenuItem, true);
            jMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    RosterTree.this.backend.send(new InfoQuery(RosterTree.this.currentJIDStatus.getJID(), "get", new IQLast()));
                }
            });
            this.popupMenu.add(jMenuItem);
        }
        if (Preferences.getBoolean("jeti", "rostermenuInvisible", true)) {
            object = new JMenuItem();
            I18N.setTextAndMnemonic("main.main.rostermenu.Set_Invisible", (AbstractButton)object);
            ((AbstractButton)object).addActionListener(new ActionListener((JMenuItem)object){
                private final /* synthetic */ JMenuItem val$menuItem3;
                {
                    this.val$menuItem3 = jMenuItem;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    if (this.val$menuItem3.getText().equals(I18N.gettext("main.main.rostermenu.Set_Invisible"))) {
                        I18N.setTextAndMnemonic("main.main.rostermenu.Set_Visible", this.val$menuItem3);
                        RosterTree.this.backend.send(new Presence(RosterTree.this.currentJIDStatus.getJID(), "invisible"));
                    } else {
                        I18N.setTextAndMnemonic("main.main.rostermenu.Set_Invisible", this.val$menuItem3);
                        RosterTree.this.backend.send(new Presence(RosterTree.this.currentJIDStatus.getJID(), "available"));
                    }
                }
            });
            this.popupMenu.add((JMenuItem)object);
        }
        if (this.menuItems != null) {
            object = this.menuItems.entrySet().iterator();
            while (object.hasNext()) {
                Map.Entry entry = (Map.Entry)object.next();
                JMenuItem jMenuItem2 = new JMenuItem((String)entry.getKey());
                final RosterMenuListener rosterMenuListener = (RosterMenuListener)entry.getValue();
                jMenuItem2.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        rosterMenuListener.actionPerformed(RosterTree.this.currentJIDStatus, RosterTree.this.currentJIDStatusGroup2);
                    }
                });
                this.popupMenu.add(jMenuItem2);
            }
        }
    }

    public void addToMenu(String string, RosterMenuListener rosterMenuListener) {
        if (this.menuItems == null) {
            this.menuItems = new HashMap(10);
        }
        this.menuItems.put(string, rosterMenuListener);
        if (this.popupMenu != null) {
            this.createPopupMenu();
        }
    }

    public void removeFromMenu(String string) {
        if (this.menuItems == null) {
            return;
        }
        this.menuItems.remove(string);
        if (this.menuItems.isEmpty()) {
            this.menuItems = null;
        }
        if (this.popupMenu != null) {
            this.createPopupMenu();
        }
    }

    public List getOpenGroups() {
        LinkedList<String> linkedList = new LinkedList<String>();
        JIDStatusTree jIDStatusTree = (JIDStatusTree)this.getModel().getRoot();
        if (jIDStatusTree == null) {
            return null;
        }
        for (int i = 0; i < jIDStatusTree.getSize(); ++i) {
            TreePath treePath = new TreePath(new Object[]{jIDStatusTree, jIDStatusTree.get(i)});
            if (!this.isExpanded(treePath)) continue;
            linkedList.add(jIDStatusTree.get(i).toString());
        }
        return linkedList;
    }

    public void openGroups(JetiPrivateRosterExtension jetiPrivateRosterExtension) {
        String[] stringArray = jetiPrivateRosterExtension.getOpenGroups();
        JIDStatusTree jIDStatusTree = (JIDStatusTree)this.getModel().getRoot();
        if (stringArray == null) {
            return;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (!jIDStatusTree.existGroup(stringArray[i])) continue;
            TreePath treePath = new TreePath(new Object[]{jIDStatusTree, jIDStatusTree.getGroup(stringArray[i])});
            if (this.treeExpander != null) {
                this.treeExpander.expand(treePath);
                continue;
            }
            this.expandPath(treePath);
        }
    }

    private void sendMessage(JIDStatus jIDStatus) {
        new SendMessage(this.backend, jIDStatus.getJID(), jIDStatus.getNick()).setVisible(true);
    }

    private void sendChat(JIDStatus jIDStatus) {
        this.main.chat(jIDStatus);
    }

    private void maybeShowPopup(MouseEvent mouseEvent, JIDStatus jIDStatus, JIDStatusGroup jIDStatusGroup) {
        if (mouseEvent.isPopupTrigger()) {
            this.currentJIDStatus = jIDStatus;
            this.currentGroup = jIDStatusGroup.getName();
            this.currentJIDStatusGroup2 = jIDStatusGroup;
            this.popupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
        }
    }

    private void maybeShowGroupPopup(MouseEvent mouseEvent, JIDStatusGroup jIDStatusGroup) {
        if (mouseEvent.isPopupTrigger()) {
            this.currentJIDStatusGroup = jIDStatusGroup;
            this.currentGroup = jIDStatusGroup.getName();
            this.groupPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
        }
    }

    public String getToolTipText(MouseEvent mouseEvent) {
        if (mouseEvent == null) {
            return null;
        }
        TreePath treePath = this.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
        if (treePath != null) {
            JIDStatus jIDStatus = null;
            Object object = treePath.getLastPathComponent();
            if (object instanceof PrimaryJIDStatus) {
                jIDStatus = ((PrimaryJIDStatus)object).getJIDPrimaryStatus();
            } else if (object instanceof JIDStatus) {
                jIDStatus = (JIDStatus)object;
            } else {
                return null;
            }
            Avatars avatars = this.getAvatar();
            if (avatars != null) {
                avatars.setToolTipJIDStatus(jIDStatus);
            }
            String string = jIDStatus.getStatus() != null ? I18N.gettext("main.main.statusmenu.Status_message") + " " + jIDStatus.getStatus() + "</p><p>" : "";
            String string2 = jIDStatus.getWaiting();
            string2 = jIDStatus.getWaiting() != null ? "<p>" + I18N.gettext("main.main.roster.Waiting_Status") + " " + jIDStatus.getWaiting() + "</p>" : "";
            return "<HTML><P>" + I18N.gettext("main.main.roster.Status") + " " + Presence.toLongShow(jIDStatus.getShow()) + "</p><p>" + string + "JID: " + jIDStatus.getCompleteJID() + "</p><p>" + I18N.gettext("main.main.roster.Subscription") + " " + jIDStatus.getSubscription() + "</p>" + string2 + "</p></HTML>";
        }
        return null;
    }

    public JToolTip createToolTip() {
        Avatars avatars = this.getAvatar();
        if (avatars != null) {
            return avatars.createToolTip();
        }
        return super.createToolTip();
    }

    private Avatars getAvatar() {
        if (this.avatars != null) {
            return this.avatars;
        }
        if (PluginsInfo.isPluginLoaded("ichatavatars")) {
            this.avatars = (Avatars)PluginsInfo.getPluginInstance("ichatavatars");
            return this.avatars;
        }
        return null;
    }

    class MacRenderer
    implements TreeCellRenderer {
        private JLabel renderer = new JLabel();

        public MacRenderer() {
            this.renderer.setFont(UIManager.getFont("Tree.font"));
        }

        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            this.renderer.setText(object.toString());
            if (bl) {
                this.renderer.setOpaque(true);
                this.renderer.setForeground(UIManager.getColor("Tree.selectionForeground"));
                this.renderer.setBackground(UIManager.getColor("Tree.selectionBackground"));
            } else {
                this.renderer.setForeground(UIManager.getColor("Tree.textForeground"));
                this.renderer.setOpaque(Preferences.getBoolean("jeti", "bmw", true));
                this.renderer.setBackground(UIManager.getColor("Tree.background"));
            }
            if (bl3) {
                return this.makeComponent((JIDStatus)object);
            }
            if (object instanceof PrimaryJIDStatus) {
                PrimaryJIDStatus primaryJIDStatus = (PrimaryJIDStatus)object;
                JIDStatus jIDStatus = primaryJIDStatus.getJIDPrimaryStatus();
                if (primaryJIDStatus.hasMultiple()) {
                    if (RosterTree.this.onlineTree) {
                        if (primaryJIDStatus.multipleJIDstatusOnline()) {
                            this.renderer.setForeground(new Color(0, 0, 190));
                        }
                        return this.makeComponent(jIDStatus);
                    }
                    if (primaryJIDStatus.isAJIDstatusOffline()) {
                        this.renderer.setIcon(StatusIcons.getImageIcon("multiple"));
                    }
                    return this.renderer;
                }
                return this.makeComponent(jIDStatus);
            }
            if (object instanceof JIDStatusGroup) {
                JIDStatusGroup jIDStatusGroup = (JIDStatusGroup)object;
                if (RosterTree.this.onlineTree) {
                    this.renderer.setText(jIDStatusGroup.toString() + " (" + jIDStatusGroup.getOnlines() + ")");
                }
                if (bl2) {
                    this.renderer.setIcon(StatusIcons.getImageIcon("arrowDown"));
                } else {
                    this.renderer.setIcon(StatusIcons.getImageIcon("arrowUp"));
                }
            }
            return this.renderer;
        }

        private Component makeComponent(JIDStatus jIDStatus) {
            int n = jIDStatus.isOnline() ? jIDStatus.getShow() : 7;
            this.renderer.setIcon(StatusIcons.getStatusIcon(n, jIDStatus.getType()));
            return this.renderer;
        }
    }

    class MyRenderer
    extends DefaultTreeCellRenderer {
        private JLabel renderer;
        private Component fill = Box.createRigidArea(new Dimension(0, 0));

        public MyRenderer() {
            this.renderer = new JLabel();
            this.renderer.setFont(UIManager.getFont("Tree.font"));
        }

        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            String string = object.toString();
            this.renderer.setText(string);
            if (bl) {
                this.renderer.setOpaque(true);
                this.renderer.setForeground(UIManager.getColor("Tree.selectionForeground"));
                this.renderer.setBackground(UIManager.getColor("Tree.selectionBackground"));
            } else {
                this.renderer.setForeground(UIManager.getColor("Tree.textForeground"));
                this.renderer.setOpaque(Preferences.getBoolean("jeti", "bmw", true));
                this.renderer.setBackground(UIManager.getColor("Tree.background"));
            }
            if (bl3) {
                return this.makeComponent((JIDStatus)object);
            }
            if (object instanceof PrimaryJIDStatus) {
                PrimaryJIDStatus primaryJIDStatus = (PrimaryJIDStatus)object;
                JIDStatus jIDStatus = primaryJIDStatus.getJIDPrimaryStatus();
                if (primaryJIDStatus.hasMultiple()) {
                    if (RosterTree.this.onlineTree) {
                        if (primaryJIDStatus.multipleJIDstatusOnline()) {
                            this.renderer.setForeground(new Color(0, 0, 190));
                        }
                        return this.makeComponent(jIDStatus);
                    }
                    if (primaryJIDStatus.isAJIDstatusOffline()) {
                        this.renderer.setIcon(StatusIcons.getImageIcon("multiple"));
                        return this.renderer;
                    }
                    return this.fill;
                }
                return this.makeComponent(jIDStatus);
            }
            if (object instanceof JIDStatusGroup) {
                JIDStatusGroup jIDStatusGroup = (JIDStatusGroup)object;
                if (RosterTree.this.onlineTree) {
                    if (jIDStatusGroup.getOnlines() == 0) {
                        return this.fill;
                    }
                    string = jIDStatusGroup.toString() + " (" + jIDStatusGroup.getOnlines() + ")";
                    this.renderer.setText(string);
                }
                if (bl2) {
                    this.renderer.setIcon(StatusIcons.getImageIcon("arrowDown"));
                } else {
                    this.renderer.setIcon(StatusIcons.getImageIcon("arrowUp"));
                }
            }
            return this.renderer;
        }

        private Component makeComponent(JIDStatus jIDStatus) {
            if (jIDStatus.isOnline()) {
                if (!RosterTree.this.onlineTree) {
                    return this.fill;
                }
                this.renderer.setIcon(StatusIcons.getStatusIcon(jIDStatus));
            } else {
                if (RosterTree.this.onlineTree) {
                    return this.fill;
                }
                this.renderer.setIcon(StatusIcons.getStatusIcon(jIDStatus));
            }
            return this.renderer;
        }
    }
}

