/*
 * Decompiled with CFR 0.152.
 */
package nu.fw.jeti.ui;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import nu.fw.jeti.images.StatusIcons;
import nu.fw.jeti.jabber.Backend;
import nu.fw.jeti.jabber.JID;
import nu.fw.jeti.jabber.elements.Message;
import nu.fw.jeti.util.I18N;
import nu.fw.jeti.util.Preferences;
import nu.fw.jeti.util.Utils;

public class CommentWindow
extends JFrame {
    private JPanel jPanel1 = new JPanel();
    private JRadioButton radioComment = new JRadioButton();
    private JRadioButton radioBug = new JRadioButton();
    private JPanel jPanel2 = new JPanel();
    private Backend backend;
    JPanel jPanel3 = new JPanel();
    JButton btnSend = new JButton();
    JButton btnCancel = new JButton();
    JPanel jPanel5 = new JPanel();
    private JCheckBox[] aryCheckBox = new JCheckBox[5];
    JLabel jLabel1 = new JLabel();
    private JScrollPane jScrollPane1 = new JScrollPane();
    private JTextArea jTextArea1 = new JTextArea();

    public CommentWindow(Backend backend) {
        this.backend = backend;
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.setSize(300, 450);
        this.setLocationRelativeTo(null);
    }

    private void jbInit() throws Exception {
        this.setIconImage(StatusIcons.getImageIcon("jeti").getImage());
        this.setDefaultCloseOperation(2);
        this.setTitle(I18N.gettext("main.comment.Comment/Bug"));
        ButtonGroup buttonGroup = new ButtonGroup();
        this.radioComment.setSelected(true);
        I18N.setTextAndMnemonic("main.comment.Comment/Request", this.radioComment);
        this.radioComment.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CommentWindow.this.radioComment_actionPerformed(actionEvent);
            }
        });
        I18N.setTextAndMnemonic("main.comment.Bug", this.radioBug);
        this.radioBug.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CommentWindow.this.radioBug_actionPerformed(actionEvent);
            }
        });
        this.btnSend.setText(I18N.gettext("Send"));
        this.getRootPane().setDefaultButton(this.btnSend);
        this.btnSend.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CommentWindow.this.btnSend_actionPerformed(actionEvent);
            }
        });
        AbstractAction abstractAction = new AbstractAction(I18N.gettext("Cancel")){

            public void actionPerformed(ActionEvent actionEvent) {
                CommentWindow.this.dispose();
            }
        };
        Utils.addCancelButton(this, this.btnCancel, abstractAction);
        this.jLabel1.setText(I18N.gettext("main.comment.Include"));
        this.jPanel5.add((Component)this.jLabel1, null);
        JCheckBox jCheckBox = new JCheckBox();
        jCheckBox.setName("0");
        jCheckBox.setText(I18N.gettext("main.comment.JETI_Version") + " " + "0.7.7");
        I18N.setMnemonic("main.comment.JETI_Version", jCheckBox);
        jCheckBox.setSelected(true);
        this.aryCheckBox[0] = jCheckBox;
        this.jPanel5.add(jCheckBox);
        jCheckBox = new JCheckBox();
        jCheckBox.setName("1");
        jCheckBox.setText(I18N.gettext("main.comment.OS") + " " + System.getProperty("os.name") + " " + System.getProperty("os.version"));
        I18N.setMnemonic("main.comment.OS", jCheckBox);
        this.aryCheckBox[1] = jCheckBox;
        jCheckBox.setSelected(true);
        this.jPanel5.add(jCheckBox);
        jCheckBox = new JCheckBox();
        jCheckBox.setName("2");
        jCheckBox.setText(I18N.gettext("main.comment.Architecture") + " " + System.getProperty("os.arch"));
        I18N.setMnemonic("main.comment.Architecture", jCheckBox);
        this.aryCheckBox[2] = jCheckBox;
        jCheckBox.setSelected(true);
        this.jPanel5.add(jCheckBox);
        jCheckBox = new JCheckBox();
        jCheckBox.setName("3");
        jCheckBox.setText(I18N.gettext("main.comment.Java_Vendor") + " " + System.getProperty("java.vendor"));
        I18N.setMnemonic("main.comment.Java_Vendor", jCheckBox);
        this.aryCheckBox[3] = jCheckBox;
        jCheckBox.setSelected(true);
        this.jPanel5.add(jCheckBox);
        jCheckBox = new JCheckBox();
        jCheckBox.setName("4");
        jCheckBox.setText(I18N.gettext("main.comment.Java_Version") + " " + System.getProperty("java.version"));
        I18N.setMnemonic("main.comment.Java_Version", jCheckBox);
        this.aryCheckBox[4] = jCheckBox;
        jCheckBox.setSelected(true);
        this.jPanel5.add(jCheckBox);
        this.jPanel5.setAlignmentX(0.5f);
        this.jPanel5.setVisible(false);
        this.jPanel2.add((Component)this.jPanel5, null);
        this.jPanel5.setLayout(new BoxLayout(this.jPanel5, 1));
        this.jPanel2.add((Component)this.jPanel3, null);
        this.jPanel3.add((Component)this.btnSend, null);
        this.jPanel3.add((Component)this.btnCancel, null);
        this.getContentPane().add((Component)this.jScrollPane1, "Center");
        this.jScrollPane1.getViewport().add((Component)this.jTextArea1, null);
        this.getContentPane().add((Component)this.jPanel1, "North");
        this.jPanel1.add((Component)this.radioComment, null);
        this.jPanel1.add((Component)this.radioBug, null);
        this.getContentPane().add((Component)this.jPanel2, "South");
        this.jPanel2.setLayout(new BoxLayout(this.jPanel2, 1));
        buttonGroup.add(this.radioComment);
        buttonGroup.add(this.radioBug);
    }

    void btnSend_actionPerformed(ActionEvent actionEvent) {
        String string = this.jTextArea1.getText();
        if (string == null || string.equals("")) {
            return;
        }
        if (this.radioBug.isSelected()) {
            for (int i = 0; i < this.aryCheckBox.length; ++i) {
                if (!this.aryCheckBox[i].isSelected()) continue;
                string = string + "\n" + this.aryCheckBox[i].getText();
            }
        }
        JID jID = null;
        try {
            jID = JID.checkedJIDFromString(Preferences.getString("jeti", "commentJID", "jeti@jabber.org"));
        }
        catch (InstantiationException instantiationException) {
            System.out.println("wrong comment JID");
            jID = new JID("jeti", "jabber.org", null);
        }
        this.backend.send(new Message(string, "Jeti Comment", jID));
        this.dispose();
    }

    void radioComment_actionPerformed(ActionEvent actionEvent) {
        this.jPanel5.setVisible(false);
    }

    void radioBug_actionPerformed(ActionEvent actionEvent) {
        this.jPanel5.setVisible(true);
    }
}

