/*
 * Decompiled with CFR 0.152.
 */
package nu.fw.jeti.jabber.elements;

import java.text.DateFormat;
import java.text.MessageFormat;
import java.util.Calendar;
import nu.fw.jeti.jabber.Backend;
import nu.fw.jeti.jabber.elements.Extension;
import nu.fw.jeti.jabber.elements.IQExtension;
import nu.fw.jeti.jabber.elements.InfoQuery;
import nu.fw.jeti.util.I18N;
import nu.fw.jeti.util.Popups;

public class IQLast
extends Extension
implements IQExtension {
    private String seconds;

    public IQLast() {
    }

    public IQLast(String string) {
        this.seconds = string;
    }

    public String getSeconds() {
        return this.seconds;
    }

    public void execute(InfoQuery infoQuery, Backend backend) {
        if (!infoQuery.getType().equals("get")) {
            if (infoQuery.getType().equals("result")) {
                this.lastSeenPopup(infoQuery.getFrom().toStringNoResource(), this.getSeconds());
            } else if (infoQuery.getType().equals("error")) {
                Popups.errorPopup(infoQuery.getErrorDescription(), I18N.gettext("main.error.Last_Seen_Error"));
            }
        }
    }

    private void lastSeenPopup(String string, String string2) {
        int n = 0;
        try {
            n = Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            Popups.popup(MessageFormat.format(I18N.gettext("main.popup.{0}_was_last_seen_{1}_seconds_ago"), string, string2), "main.popup.Last_Seen", 1);
        }
        Calendar calendar = Calendar.getInstance();
        calendar.add(13, -n);
        DateFormat dateFormat = DateFormat.getDateTimeInstance();
        Popups.popup(MessageFormat.format(I18N.gettext("main.popup.{0}_was_last_seen_on_{1}"), string, dateFormat.format(calendar.getTime())), I18N.gettext("main.popup.Last_Seen"), 1);
    }

    public void appendToXML(StringBuffer stringBuffer) {
        stringBuffer.append("<query xmlns=\"jabber:iq:last\"");
        IQLast.appendAttribute(stringBuffer, "seconds", this.seconds);
        stringBuffer.append("/>");
    }
}

