/*
 * Decompiled with CFR 0.152.
 */
package nu.fw.jeti.plugins.xhtml.fontchooser;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.EventObject;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListModel;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

class TitledPickList
extends JPanel
implements ListSelectionListener,
CaretListener,
FocusListener,
KeyListener {
    private JTextField choice;
    boolean ignoreTextChanges = false;
    private JList optionsList;
    private Vector listeners = new Vector(0);

    public TitledPickList(String[] stringArray, String string) {
        super(new BorderLayout());
        this.choice = new JTextField();
        this.choice.addCaretListener(this);
        this.choice.addFocusListener(this);
        this.choice.addKeyListener(this);
        this.optionsList = new JList<String>(stringArray);
        this.optionsList.setSelectionMode(0);
        this.optionsList.addListSelectionListener(this);
        JScrollPane jScrollPane = new JScrollPane(this.optionsList);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)this.choice, "North");
        jPanel.add((Component)jScrollPane, "Center");
        JLabel jLabel = new JLabel();
        jLabel.setText(string);
        this.add((Component)jLabel, "North");
        this.add((Component)jPanel, "Center");
    }

    public void caretUpdate(CaretEvent caretEvent) {
        if (!this.ignoreTextChanges && this.choice.hasFocus()) {
            ListModel listModel = this.optionsList.getModel();
            String string = this.choice.getText().toLowerCase();
            if (string != null) {
                int n = 0;
                int n2 = listModel.getSize();
                String string2 = (String)listModel.getElementAt(n);
                while (++n < n2 && !string2.toLowerCase().startsWith(string)) {
                    string2 = (String)listModel.getElementAt(n);
                }
                if (n < n2) {
                    this.optionsList.setSelectedValue(string2, true);
                }
            }
        }
    }

    public void focusGained(FocusEvent focusEvent) {
    }

    public void focusLost(FocusEvent focusEvent) {
        this.updateTextFromList();
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 10) {
            this.updateTextFromList();
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    private void updateTextFromList() {
        Object e = this.optionsList.getSelectedValue();
        if (e != null) {
            this.choice.setText(e.toString());
        }
    }

    public Object getSelection() {
        return this.optionsList.getSelectedValue();
    }

    public void setSelection(Object object) {
        this.optionsList.setSelectedValue(object.toString(), true);
        this.updateTextFromList();
    }

    public void setSelection(int n) {
        this.optionsList.setSelectedIndex(n);
        this.updateTextFromList();
    }

    public int getIndex() {
        return this.optionsList.getSelectedIndex();
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (this.optionsList.hasFocus()) {
            this.updateTextFromList();
        }
        this.fireValueChanged();
    }

    public void addTitledPickListListener(TitledPickListListener titledPickListListener) {
        this.listeners.addElement(titledPickListListener);
    }

    public void removeTitledPickListListener(TitledPickListListener titledPickListListener) {
        this.listeners.removeElement(titledPickListListener);
    }

    void fireValueChanged() {
        Enumeration enumeration = this.listeners.elements();
        while (enumeration.hasMoreElements()) {
            ((TitledPickListListener)enumeration.nextElement()).valueChanged(new TitledPickListEvent(this));
        }
    }

    static interface TitledPickListListener
    extends EventListener {
        public void valueChanged(TitledPickListEvent var1);
    }

    class TitledPickListEvent
    extends EventObject {
        public TitledPickListEvent(Object object) {
            super(object);
        }
    }
}

