/*
 * Decompiled with CFR 0.152.
 */
package nu.fw.jeti.plugins.xhtml.fontchooser;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.EventObject;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.text.AttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import nu.fw.jeti.plugins.xhtml.fontchooser.AttributeComponent;
import nu.fw.jeti.util.I18N;

public class ColorPanel
extends JPanel
implements ActionListener,
AttributeComponent {
    JTextField colorDisplay = new JTextField();
    private Color defaultColor;
    private Object attributeKey;
    private Color originalColor;
    private int setValCount = 0;
    private Vector listeners = new Vector(0);

    public ColorPanel(String string, Color color) {
        super(new BorderLayout(5, 5));
        this.defaultColor = color;
        this.attributeKey = string;
        this.colorDisplay.setBackground(color);
        Dimension dimension = new Dimension(20, 15);
        this.colorDisplay.setMinimumSize(dimension);
        this.colorDisplay.setMaximumSize(dimension);
        this.colorDisplay.setPreferredSize(dimension);
        this.colorDisplay.setEditable(false);
        JButton jButton = new JButton();
        jButton.setText("...");
        dimension = new Dimension(20, 15);
        jButton.setMinimumSize(dimension);
        jButton.setMaximumSize(dimension);
        jButton.setPreferredSize(dimension);
        jButton.addActionListener(this);
        JPanel jPanel = new JPanel(new FlowLayout());
        jPanel.add(this.colorDisplay);
        jPanel.add(jButton);
        if (string != null && string.length() > 0) {
            JLabel jLabel = new JLabel(string);
            jLabel.setFont(UIManager.getFont("TextField.font"));
            this.add((Component)jLabel, "West");
            this.add((Component)jPanel, "East");
        } else {
            this.add((Component)jPanel, "West");
        }
    }

    public Color getColor() {
        return this.colorDisplay.getBackground();
    }

    private void setColor(Color color) {
        this.colorDisplay.setBackground(color);
        if (++this.setValCount < 2) {
            this.originalColor = color;
        }
        this.fireColorChanged();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Color color = JColorChooser.showDialog(this, I18N.gettext((String)"xhtml.Select_Color"), this.colorDisplay.getBackground());
        if (color != null) {
            this.setColor(color);
        }
    }

    public boolean setValue(AttributeSet attributeSet) {
        boolean bl = false;
        if (this.defaultColor == Color.black) {
            Color color = StyleConstants.getForeground(attributeSet);
            if (color != null) {
                this.setColor(color);
                bl = true;
            } else {
                this.setColor(this.defaultColor);
            }
        } else {
            Color color = StyleConstants.getBackground(attributeSet);
            if (color != null) {
                this.setColor(color);
                bl = true;
            } else {
                this.setColor(this.defaultColor);
            }
        }
        return bl;
    }

    public String getAttr() {
        String string = "#" + Integer.toHexString(this.getColor().getRGB()).substring(2);
        return string;
    }

    public AttributeSet getValue() {
        SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
        Color color = this.getColor();
        if (color != this.originalColor) {
            if (this.defaultColor == Color.BLACK) {
                StyleConstants.setForeground(simpleAttributeSet, color);
            } else {
                StyleConstants.setBackground(simpleAttributeSet, color);
            }
        }
        return simpleAttributeSet;
    }

    public AttributeSet getValue(boolean bl) {
        if (bl) {
            SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
            Color color = this.getColor();
            if (this.defaultColor == Color.BLACK) {
                StyleConstants.setForeground(simpleAttributeSet, color);
            } else {
                StyleConstants.setBackground(simpleAttributeSet, color);
            }
            return simpleAttributeSet;
        }
        return this.getValue();
    }

    public Object getAttributeKey() {
        return this.attributeKey;
    }

    public void addColorPanelListener(ColorPanelListener colorPanelListener) {
        this.listeners.addElement(colorPanelListener);
    }

    public void removeColorPanelListener(ColorPanelListener colorPanelListener) {
        this.listeners.removeElement(colorPanelListener);
    }

    void fireColorChanged() {
        Enumeration enumeration = this.listeners.elements();
        while (enumeration.hasMoreElements()) {
            ((ColorPanelListener)enumeration.nextElement()).colorChanged(new ColorPanelEvent(this));
        }
    }

    static interface ColorPanelListener
    extends EventListener {
        public void colorChanged(ColorPanelEvent var1);
    }

    class ColorPanelEvent
    extends EventObject {
        public ColorPanelEvent(Object object) {
            super(object);
        }
    }
}

