/*
 * Decompiled with CFR 0.152.
 */
package nu.fw.jeti.plugins.xhtml;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import javax.swing.text.StyledEditorKit;
import nu.fw.jeti.jabber.Backend;
import nu.fw.jeti.jabber.elements.Extension;
import nu.fw.jeti.jabber.elements.XExtension;
import nu.fw.jeti.jabber.handlers.ExtensionHandler;
import nu.fw.jeti.plugins.FormattedMessage;
import nu.fw.jeti.plugins.Plugins;
import nu.fw.jeti.plugins.Word;
import nu.fw.jeti.plugins.xhtml.XHTML;
import nu.fw.jeti.plugins.xhtml.XHTMLHandler;
import nu.fw.jeti.plugins.xhtml.XHTMLIMHandler;
import nu.fw.jeti.plugins.xhtml.fontchooser.FontDialog;
import nu.fw.jeti.ui.ChatSplitPane;
import nu.fw.jeti.util.I18N;
import nu.fw.jeti.util.Preferences;

public class Plugin
implements Plugins,
FormattedMessage {
    private JButton btnFont;
    private JButton btnColor;
    private JButton btnBold;
    private JButton btnItalic;
    private JButton btnUnderline;
    private JTextPane txtInvoer;
    private ChatSplitPane chatPane;
    private boolean showXHTML = true;
    public static final String VERSION = "0.3";
    public static final String DESCRIPTION = "xhtml.Formats_messages";
    public static final String MIN_JETI_VERSION = "0.5";
    public static final String NAME = "xhtml";
    public static final String ABOUT = "by E.S. de boer, uses Fontchooser from SimplyHTML by Ulrich Hilger";

    public static void init(Backend backend) {
        backend.addExtensionHandler("http://jabber.org/protocol/xhtml-im", (ExtensionHandler)new XHTMLIMHandler());
        backend.addExtensionHandler("http://www.w3.org/1999/xhtml", (ExtensionHandler)new XHTMLHandler());
    }

    public void initXHTML(ChatSplitPane chatSplitPane, final JTextPane jTextPane, JPanel jPanel) {
        this.txtInvoer = jTextPane;
        this.chatPane = chatSplitPane;
        SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
        int n = Preferences.getInteger((String)NAME, (String)"foreground", (int)0);
        if (n != 0) {
            StyleConstants.setForeground(simpleAttributeSet, new Color(n));
        }
        if ((n = Preferences.getInteger((String)NAME, (String)"background", (int)0)) != 0) {
            StyleConstants.setBackground(simpleAttributeSet, new Color(n));
        }
        if ((n = Preferences.getInteger((String)NAME, (String)"font-size", (int)0)) != 0) {
            StyleConstants.setFontSize(simpleAttributeSet, n);
        }
        StyleConstants.setFontFamily(simpleAttributeSet, Preferences.getString((String)NAME, (String)"font-family", (String)"Arial"));
        jTextPane.setParagraphAttributes(simpleAttributeSet, false);
        this.btnFont = new JButton(new ImageIcon(this.getClass().getResource("font.gif")));
        this.btnFont.setToolTipText(I18N.gettext((String)"xhtml.Font"));
        this.btnFont.setMargin(new Insets(0, 0, 0, 0));
        this.btnFont.setPreferredSize(new Dimension(23, 23));
        this.btnFont.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AttributeSet attributeSet = jTextPane.getCharacterAttributes();
                FontDialog fontDialog = new FontDialog((Frame)jTextPane.getTopLevelAncestor(), I18N.gettext((String)"xhtml.Choose_Font"), attributeSet);
                fontDialog.setModal(true);
                fontDialog.show();
                if (fontDialog.getResult() == FontDialog.RESULT_OK) {
                    attributeSet = fontDialog.getAttributes();
                    int n = jTextPane.getSelectionStart();
                    int n2 = jTextPane.getSelectionEnd();
                    if (n2 != n) {
                        StyledDocument styledDocument = (StyledDocument)jTextPane.getDocument();
                        styledDocument.setCharacterAttributes(n, n2 - n, attributeSet, false);
                    } else {
                        jTextPane.setParagraphAttributes(attributeSet, false);
                    }
                    jTextPane.requestFocus();
                }
            }
        });
        jPanel.add(this.btnFont);
        this.btnColor = new JButton(new ImageIcon(this.getClass().getResource("color.gif")));
        this.btnColor.setToolTipText(I18N.gettext((String)"xhtml.Color"));
        this.btnColor.setMargin(new Insets(0, 0, 0, 0));
        this.btnColor.setPreferredSize(new Dimension(23, 23));
        this.btnColor.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Color color = JColorChooser.showDialog(jTextPane.getTopLevelAncestor(), I18N.gettext((String)"xhtml.Color"), null);
                if (color != null) {
                    int n = jTextPane.getSelectionStart();
                    int n2 = jTextPane.getSelectionEnd();
                    SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
                    simpleAttributeSet.addAttribute(StyleConstants.Foreground, color);
                    if (n2 != n) {
                        StyledDocument styledDocument = (StyledDocument)jTextPane.getDocument();
                        styledDocument.setCharacterAttributes(n, n2 - n, simpleAttributeSet, false);
                    } else {
                        jTextPane.setParagraphAttributes(simpleAttributeSet, false);
                    }
                    jTextPane.requestFocus();
                }
            }
        });
        jPanel.add(this.btnColor);
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                jTextPane.requestFocus();
            }
        };
        StyledEditorKit.BoldAction boldAction = new StyledEditorKit.BoldAction();
        boldAction.putValue("Name", null);
        boldAction.putValue("ShortDescription", I18N.gettext((String)"xhtml.Bold"));
        boldAction.putValue("SmallIcon", new ImageIcon(this.getClass().getResource("Bold16.gif")));
        this.btnBold = new JButton(boldAction);
        this.btnBold.setMargin(new Insets(0, 0, 0, 0));
        this.btnBold.setPreferredSize(new Dimension(23, 23));
        this.btnBold.addActionListener(actionListener);
        jPanel.add(this.btnBold);
        StyledEditorKit.ItalicAction italicAction = new StyledEditorKit.ItalicAction();
        italicAction.putValue("Name", null);
        italicAction.putValue("ShortDescription", I18N.gettext((String)"xhtml.Italic"));
        italicAction.putValue("SmallIcon", new ImageIcon(this.getClass().getResource("Italic16.gif")));
        this.btnItalic = new JButton(italicAction);
        this.btnItalic.setMargin(new Insets(0, 0, 0, 0));
        this.btnItalic.setPreferredSize(new Dimension(23, 23));
        this.btnItalic.addActionListener(actionListener);
        jPanel.add(this.btnItalic);
        StyledEditorKit.UnderlineAction underlineAction = new StyledEditorKit.UnderlineAction();
        underlineAction.putValue("Name", null);
        underlineAction.putValue("ShortDescription", I18N.gettext((String)"xhtml.Underline"));
        underlineAction.putValue("SmallIcon", new ImageIcon(this.getClass().getResource("Underline16.gif")));
        this.btnUnderline = new JButton(underlineAction);
        this.btnUnderline.setMargin(new Insets(0, 0, 0, 0));
        this.btnUnderline.setPreferredSize(new Dimension(23, 23));
        this.btnUnderline.addActionListener(actionListener);
        jPanel.add(this.btnUnderline);
    }

    public List getWordList(Extension extension) {
        if (extension instanceof XHTML) {
            return ((XHTML)extension).getWordList();
        }
        return null;
    }

    public void useXHTML(boolean bl, String string) {
        if (bl != this.showXHTML && !bl) {
            this.chatPane.appendSystemMessage(MessageFormat.format(I18N.gettext((String)"xhtml.{0}_does_not_support_formatted_messages"), string));
        }
        this.showXHTML = bl;
    }

    public XExtension getXHTMLExtension(List list) {
        return new XHTML(list);
    }

    public boolean sendXML() {
        return this.showXHTML;
    }

    public List makeWordListFromDocument() {
        Element[] elementArray = this.txtInvoer.getDocument().getRootElements();
        ArrayList arrayList = new ArrayList();
        this.parseElement(elementArray[0], arrayList, new SimpleAttributeSet());
        return arrayList;
    }

    private void addToWordList(String string, SimpleAttributeSet simpleAttributeSet, List list) {
        if (string.equals("")) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        block5: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case ' ': {
                    this.addWordFromTemp(stringBuffer, list, simpleAttributeSet);
                    list.add(new Word(" ", (MutableAttributeSet)((SimpleAttributeSet)simpleAttributeSet.clone())));
                    stringBuffer = new StringBuffer();
                    continue block5;
                }
                case '\n': {
                    this.addWordFromTemp(stringBuffer, list, simpleAttributeSet);
                    stringBuffer = new StringBuffer();
                    continue block5;
                }
                case '\t': {
                    this.addWordFromTemp(stringBuffer, list, simpleAttributeSet);
                    list.add(new Word("\t", (MutableAttributeSet)((SimpleAttributeSet)simpleAttributeSet.clone())));
                    stringBuffer = new StringBuffer();
                    continue block5;
                }
                default: {
                    stringBuffer.append(c);
                }
            }
        }
        this.addWordFromTemp(stringBuffer, list, simpleAttributeSet);
    }

    private void addWordFromTemp(StringBuffer stringBuffer, List list, SimpleAttributeSet simpleAttributeSet) {
        if (stringBuffer.length() > 0) {
            list.add(new Word(stringBuffer, (MutableAttributeSet)((SimpleAttributeSet)simpleAttributeSet.clone())));
        }
    }

    private void parseElement(Element element, List list, SimpleAttributeSet simpleAttributeSet) {
        block8: {
            block7: {
                AttributeSet attributeSet = element.getAttributes();
                simpleAttributeSet.addAttributes(attributeSet);
                if (element.getName().equals("paragraph") && element.getStartOffset() != 0) {
                    list.add(new Word("\n", (MutableAttributeSet)((SimpleAttributeSet)simpleAttributeSet.clone())));
                }
                if (!element.getName().equals("content")) break block7;
                if (element.getElementCount() > 0) {
                    for (int i = 0; i < element.getElementCount(); ++i) {
                        this.parseElement(element.getElement(i), list, new SimpleAttributeSet(simpleAttributeSet));
                    }
                } else {
                    try {
                        int n = element.getEndOffset() - element.getStartOffset();
                        String string = element.getDocument().getText(element.getStartOffset(), n);
                        this.addToWordList(string, simpleAttributeSet, list);
                    }
                    catch (BadLocationException badLocationException) {
                        badLocationException.printStackTrace();
                    }
                }
                break block8;
            }
            if (element.getElementCount() <= 0) break block8;
            for (int i = 0; i < element.getElementCount(); ++i) {
                this.parseElement(element.getElement(i), list, new SimpleAttributeSet(simpleAttributeSet));
            }
        }
    }

    public void unload() {
    }
}

