/*
 * Decompiled with CFR 0.152.
 */
package nu.fw.jeti.plugins.groupchat.elements;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import nu.fw.jeti.jabber.Backend;
import nu.fw.jeti.jabber.JID;
import nu.fw.jeti.jabber.elements.Extension;
import nu.fw.jeti.jabber.elements.IQExtension;
import nu.fw.jeti.jabber.elements.InfoQuery;
import nu.fw.jeti.jabber.elements.Packet;
import nu.fw.jeti.plugins.groupchat.elements.IQMUCInterface;
import nu.fw.jeti.plugins.groupchat.elements.XMUCUser;

public class IQMUC
extends Extension
implements IQExtension {
    private static Map requests = new HashMap(5);
    private static int idCount = 0;
    private String instance;
    private Backend backend;
    private JID roomJID;
    private List items;
    private int errorCode;
    private String errorDescription;
    private Map timeoutTimers = new HashMap(20);
    private Timer timer = new Timer(true);

    public IQMUC(Backend backend, JID jID) {
        this.backend = backend;
        this.roomJID = jID;
    }

    public IQMUC(String string, List list, int n, String string2) {
        this.instance = string;
        this.items = list;
        this.errorCode = n;
        this.errorDescription = string2;
    }

    public List getItems() {
        return this.items;
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public String getErrorDescription() {
        return this.errorDescription;
    }

    public synchronized void send(String string, IQMUCInterface iQMUCInterface) {
        String string2 = "Jeti_Groupchat_" + idCount++;
        InfoQuery infoQuery = new InfoQuery(this.roomJID, string, string2, (IQExtension)this);
        this.timeout(infoQuery);
        requests.put(string2, iQMUCInterface);
        this.backend.send((Packet)infoQuery);
    }

    public void execute(InfoQuery infoQuery, Backend backend) {
        IQMUCInterface iQMUCInterface = (IQMUCInterface)requests.remove(infoQuery.getID());
        if (iQMUCInterface != null) {
            iQMUCInterface.execute(infoQuery, backend, this);
        }
    }

    public void appendToXML(StringBuffer stringBuffer) {
        stringBuffer.append("<query xmlns= 'http://jabber.org/protocol/muc#" + this.instance + "'>");
        if (this.items != null) {
            Iterator iterator = this.items.iterator();
            while (iterator.hasNext()) {
                ((XMUCUser)((Object)iterator.next())).appendToXML(stringBuffer);
            }
        }
        stringBuffer.append("</query>");
    }

    public synchronized void error(String string, JID jID) {
        IQMUCInterface iQMUCInterface;
        TimerTask timerTask = (TimerTask)this.timeoutTimers.remove(string);
        if (timerTask != null) {
            timerTask.cancel();
        }
        if ((iQMUCInterface = (IQMUCInterface)requests.remove(string)) != null) {
            iQMUCInterface.timeout();
        }
    }

    private void timeout(final InfoQuery infoQuery) {
        TimerTask timerTask = new TimerTask(){

            public void run() {
                IQMUC.this.error(infoQuery.getID(), infoQuery.getTo());
            }
        };
        this.timer.schedule(timerTask, 10000L);
        this.timeoutTimers.put(infoQuery.getID(), timerTask);
    }
}

