/*
 * Decompiled with CFR 0.152.
 */
package nu.fw.jeti.plugins.groupchat;

import nu.fw.jeti.jabber.Backend;
import nu.fw.jeti.jabber.JID;
import nu.fw.jeti.jabber.elements.Packet;
import nu.fw.jeti.jabber.elements.Presence;
import nu.fw.jeti.jabber.elements.XExtension;
import nu.fw.jeti.jabber.handlers.ExtensionHandler;
import nu.fw.jeti.plugins.Plugins;
import nu.fw.jeti.plugins.groupchat.GroupChatWindows;
import nu.fw.jeti.plugins.groupchat.GroupchatWindow;
import nu.fw.jeti.plugins.groupchat.elements.XMUC;
import nu.fw.jeti.plugins.groupchat.handlers.XConferenceHandler;
import nu.fw.jeti.plugins.groupchat.handlers.XMUCUserHandler;
import nu.fw.jeti.util.I18N;

public class Plugin
implements Plugins {
    public static final String VERSION = "0.2";
    public static final String DESCRIPTION = "groupchat.groupchat";
    public static final String MIN_JETI_VERSION = "0.5.1";
    public static final String NAME = "groupchat";
    public static final String ABOUT = "by M. Forssen and E.S. de Boer";
    private GroupChatWindows groupchatWindows;
    private static Plugin plugin;

    public static void init(Backend backend) {
        plugin = new Plugin(backend);
    }

    public Plugin(Backend backend) {
        backend.addExtensionHandler("http://jabber.org/protocol/muc#user", (ExtensionHandler)new XMUCUserHandler());
        backend.addExtensionHandler("jabber:x:conference", (ExtensionHandler)new XConferenceHandler());
        this.groupchatWindows = new GroupChatWindows(backend);
    }

    public static GroupchatWindow createGroupChatWindow(JID jID) {
        return Plugin.plugin.groupchatWindows.createGroupChatWindow(jID);
    }

    public static JID getGroupchatJID(JID jID) {
        return Plugin.plugin.groupchatWindows.isGroupchatStarted(jID);
    }

    public static GroupchatWindow getGroupchat(JID jID) {
        return Plugin.plugin.groupchatWindows.getGroupchatWindow(jID);
    }

    public static void startGroupchat(JID jID, Backend backend) {
        Plugin.getGroupchat(jID);
        int n = 2;
        Presence presence = new Presence(jID, n, null, (XExtension)new XMUC());
        backend.send((Packet)presence);
    }

    public void unload() {
    }

    public static void unload(Backend backend) {
        Plugin.plugin.groupchatWindows.exit();
        backend.removeExtensionHandler("http://jabber.org/protocol/muc#user");
        backend.removeExtensionHandler("http://jabber.org/protocol/muc#owner");
        backend.removeExtensionHandler("jabber:x:conference");
        backend.getMain().removeFromRosterMenu(I18N.gettext((String)"groupchat.Invite_for_groupchat"));
        plugin = null;
    }
}

