/*
 * Decompiled with CFR 0.152.
 */
package cryptix.pki;

import cryptix.pki.KeyBundle;
import cryptix.pki.KeyBundleException;
import cryptix.pki.KeyBundleFactorySpi;
import cryptix.pki.Support;
import java.io.IOException;
import java.io.InputStream;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.util.Collection;

public class KeyBundleFactory {
    private final KeyBundleFactorySpi spi;
    private final Provider provider;
    private final String format;

    protected KeyBundleFactory(KeyBundleFactorySpi builderSpi, Provider provider, String format) {
        this.spi = builderSpi;
        this.provider = provider;
        this.format = format;
    }

    public final KeyBundle generateEmptyKeyBundle() throws KeyBundleException {
        return this.spi.engineGenerateEmptyKeyBundle();
    }

    public final KeyBundle generateKeyBundle(InputStream in) throws KeyBundleException, IOException {
        return this.spi.engineGenerateKeyBundle(in);
    }

    public final Collection generateKeyBundles(InputStream in) throws KeyBundleException, IOException {
        return this.spi.engineGenerateKeyBundles(in);
    }

    public final String getFormat() {
        return this.format;
    }

    public static KeyBundleFactory getInstance(String format) throws NoSuchAlgorithmException {
        Object[] o = Support.getImplementation("KeyBundleFactory", format);
        return new KeyBundleFactory((KeyBundleFactorySpi)o[0], (Provider)o[1], format);
    }

    public static KeyBundleFactory getInstance(String format, String provider) throws NoSuchAlgorithmException, NoSuchProviderException {
        Object[] o = Support.getImplementation("KeyBundleFactory", format, provider);
        return new KeyBundleFactory((KeyBundleFactorySpi)o[0], (Provider)o[1], format);
    }

    public static KeyBundleFactory getInstance(String format, Provider provider) throws NoSuchAlgorithmException {
        Object[] o = Support.getImplementation("KeyBundleFactory", format, provider);
        return new KeyBundleFactory((KeyBundleFactorySpi)o[0], (Provider)o[1], format);
    }

    public final Provider getProvider() {
        return this.provider;
    }
}

