/*
 * Decompiled with CFR 0.152.
 */
package cryptix.pki;

import cryptix.pki.CertificateBuilderSpi;
import cryptix.pki.KeyBundle;
import cryptix.pki.Support;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.spec.AlgorithmParameterSpec;

public class CertificateBuilder {
    private final CertificateBuilderSpi spi;
    private final Provider provider;
    private final String format;

    protected CertificateBuilder(CertificateBuilderSpi builderSpi, Provider provider, String format) {
        this.spi = builderSpi;
        this.provider = provider;
        this.format = format;
    }

    public final Certificate build(PublicKey subjectKey, Principal subjectName, KeyBundle issuer, char[] passphrase, SecureRandom sr) throws CertificateException, UnrecoverableKeyException {
        return this.spi.engineBuild(subjectKey, subjectName, issuer, passphrase, sr);
    }

    public final Certificate build(PublicKey subjectKey, Principal subjectName, KeyBundle issuer, char[] passphrase, SecureRandom sr, AlgorithmParameterSpec algSpec) throws CertificateException, InvalidAlgorithmParameterException, UnrecoverableKeyException {
        return this.spi.engineBuild(subjectKey, subjectName, issuer, passphrase, sr, algSpec);
    }

    public final Certificate build(PublicKey subjectKey, Principal subjectName, PrivateKey issuer, SecureRandom sr) throws CertificateException {
        return this.spi.engineBuild(subjectKey, subjectName, issuer, sr);
    }

    public final Certificate build(PublicKey subjectKey, Principal subjectName, PrivateKey issuer, SecureRandom sr, AlgorithmParameterSpec algSpec) throws CertificateException, InvalidAlgorithmParameterException {
        return this.spi.engineBuild(subjectKey, subjectName, issuer, sr, algSpec);
    }

    public final String getFormat() {
        return this.format;
    }

    public static CertificateBuilder getInstance(String format) throws NoSuchAlgorithmException {
        Object[] o = Support.getImplementation("CertificateBuilder", format);
        return new CertificateBuilder((CertificateBuilderSpi)o[0], (Provider)o[1], format);
    }

    public static CertificateBuilder getInstance(String format, String provider) throws NoSuchAlgorithmException, NoSuchProviderException {
        Object[] o = Support.getImplementation("CertificateBuilder", format, provider);
        return new CertificateBuilder((CertificateBuilderSpi)o[0], (Provider)o[1], format);
    }

    public static CertificateBuilder getInstance(String format, Provider provider) throws NoSuchAlgorithmException {
        Object[] o = Support.getImplementation("CertificateBuilder", format, provider);
        return new CertificateBuilder((CertificateBuilderSpi)o[0], (Provider)o[1], format);
    }

    public final Provider getProvider() {
        return this.provider;
    }
}

