/*
 * Decompiled with CFR 0.152.
 */
package cryptix.openpgp.util;

public class PGPHex {
    private static final char[] digits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    private PGPHex() {
    }

    public static String toString(byte x) {
        char[] chars = new char[]{digits[x >> 4 & 0xF], digits[x & 0xF]};
        return new String(chars);
    }

    public static String toString(int x) {
        char[] chars = new char[]{digits[x >> 28 & 0xF], digits[x >> 24 & 0xF], digits[x >> 20 & 0xF], digits[x >> 16 & 0xF], digits[x >> 12 & 0xF], digits[x >> 8 & 0xF], digits[x >> 4 & 0xF], digits[x & 0xF]};
        return new String(chars);
    }

    public static String toString(byte[] x) {
        return PGPHex.toString(x, 0, x.length);
    }

    public static String toString(byte[] x, int off, int len) {
        StringBuffer buf = new StringBuffer(x.length * 3 + (x.length >> 4));
        int i = 0;
        while (i < len) {
            buf.append(digits[x[off + i] >> 4 & 0xF]);
            buf.append(digits[x[off + i] & 0xF]);
            buf.append(' ');
            if (i % 16 == 15) {
                buf.append('\n');
            }
            ++i;
        }
        return buf.toString();
    }
}

