/*
 * Decompiled with CFR 0.152.
 */
package cryptix.openpgp.util;

import java.util.zip.Checksum;

public final class PGPCRC
implements Checksum {
    private static final int[] crctable;
    private static final int ACCUM_INIT = 11994318;
    private int accum;

    static {
        int[] nArray = new int[256];
        nArray[1] = 8801531;
        nArray[2] = 25875725;
        nArray[3] = 17603062;
        nArray[4] = 60024545;
        nArray[5] = 51751450;
        nArray[6] = 35206124;
        nArray[7] = 44007191;
        nArray[8] = 128024889;
        nArray[9] = 120049090;
        nArray[10] = 103502900;
        nArray[11] = 112007375;
        nArray[12] = 70412248;
        nArray[13] = 78916387;
        nArray[14] = 95990485;
        nArray[15] = 88014382;
        nArray[16] = 264588937;
        nArray[17] = 256049778;
        nArray[18] = 240098180;
        nArray[19] = 248108927;
        nArray[20] = 207005800;
        nArray[21] = 215016595;
        nArray[22] = 232553829;
        nArray[23] = 224014750;
        nArray[24] = 140824496;
        nArray[25] = 149062475;
        nArray[26] = 166599357;
        nArray[27] = 157832774;
        nArray[28] = 200747345;
        nArray[29] = 191980970;
        nArray[30] = 176028764;
        nArray[31] = 184266919;
        nArray[32] = 520933865;
        nArray[33] = 529177874;
        nArray[34] = 512099556;
        nArray[35] = 503334943;
        nArray[36] = 480196360;
        nArray[37] = 471432179;
        nArray[38] = 487973381;
        nArray[39] = 496217854;
        nArray[40] = 414011600;
        nArray[41] = 405478443;
        nArray[42] = 422020573;
        nArray[43] = 430033190;
        nArray[44] = 457094705;
        nArray[45] = 465107658;
        nArray[46] = 448029500;
        nArray[47] = 439496647;
        nArray[48] = 281648992;
        nArray[49] = 273666971;
        nArray[50] = 289622637;
        nArray[51] = 298124950;
        nArray[52] = 324696449;
        nArray[53] = 333198714;
        nArray[54] = 315665548;
        nArray[55] = 307683447;
        nArray[56] = 392699481;
        nArray[57] = 401494690;
        nArray[58] = 383961940;
        nArray[59] = 375687087;
        nArray[60] = 352057528;
        nArray[61] = 343782467;
        nArray[62] = 359738805;
        nArray[63] = 368533838;
        nArray[64] = 1041867730;
        nArray[65] = 1050668841;
        nArray[66] = 1066628831;
        nArray[67] = 1058355748;
        nArray[68] = 1032471859;
        nArray[69] = 1024199112;
        nArray[70] = 1006669886;
        nArray[71] = 1015471301;
        nArray[72] = 968368875;
        nArray[73] = 960392720;
        nArray[74] = 942864358;
        nArray[75] = 951368477;
        nArray[76] = 975946762;
        nArray[77] = 984451313;
        nArray[78] = 1000411399;
        nArray[79] = 992435708;
        nArray[80] = 836562267;
        nArray[81] = 828023200;
        nArray[82] = 810956886;
        nArray[83] = 818967725;
        nArray[84] = 844041146;
        nArray[85] = 852051777;
        nArray[86] = 868605623;
        nArray[87] = 860066380;
        nArray[88] = 914189410;
        nArray[89] = 922427545;
        nArray[90] = 938981743;
        nArray[91] = 930215316;
        nArray[92] = 904825475;
        nArray[93] = 896059000;
        nArray[94] = 878993294;
        nArray[95] = 887231349;
        nArray[96] = 555053627;
        nArray[97] = 563297984;
        nArray[98] = 547333942;
        nArray[99] = 538569677;
        nArray[100] = 579245274;
        nArray[101] = 570480673;
        nArray[102] = 588005847;
        nArray[103] = 596249900;
        nArray[104] = 649392898;
        nArray[105] = 640860153;
        nArray[106] = 658384399;
        nArray[107] = 666397428;
        nArray[108] = 623318499;
        nArray[109] = 631331096;
        nArray[110] = 615366894;
        nArray[111] = 606833685;
        nArray[112] = 785398962;
        nArray[113] = 777416777;
        nArray[114] = 794487231;
        nArray[115] = 802989380;
        nArray[116] = 759421523;
        nArray[117] = 767923880;
        nArray[118] = 751374174;
        nArray[119] = 743392165;
        nArray[120] = 695319947;
        nArray[121] = 704115056;
        nArray[122] = 687564934;
        nArray[123] = 679289981;
        nArray[124] = 719477610;
        nArray[125] = 711202705;
        nArray[126] = 728272487;
        nArray[127] = 737067676;
        nArray[128] = 2083735460;
        nArray[129] = 2092239711;
        nArray[130] = 2109313705;
        nArray[131] = 2101337682;
        nArray[132] = 2141233477;
        nArray[133] = 2133257662;
        nArray[134] = 2116711496;
        nArray[135] = 2125215923;
        nArray[136] = 2073216669;
        nArray[137] = 2064943718;
        nArray[138] = 2048398224;
        nArray[139] = 2057199467;
        nArray[140] = 2013339772;
        nArray[141] = 2022141063;
        nArray[142] = 2039215473;
        nArray[143] = 2030942602;
        nArray[144] = 1945504045;
        nArray[145] = 1936737750;
        nArray[146] = 1920785440;
        nArray[147] = 1929023707;
        nArray[148] = 1885728716;
        nArray[149] = 1893966647;
        nArray[150] = 1911503553;
        nArray[151] = 1902736954;
        nArray[152] = 1951893524;
        nArray[153] = 1959904495;
        nArray[154] = 1977441561;
        nArray[155] = 1968902626;
        nArray[156] = 2009362165;
        nArray[157] = 2000822798;
        nArray[158] = 1984871416;
        nArray[159] = 1992881923;
        nArray[160] = 1665111629;
        nArray[161] = 1673124534;
        nArray[162] = 1656046400;
        nArray[163] = 1647513531;
        nArray[164] = 1621913772;
        nArray[165] = 1613380695;
        nArray[166] = 1629922721;
        nArray[167] = 1637935450;
        nArray[168] = 1688082292;
        nArray[169] = 1679317903;
        nArray[170] = 1695859321;
        nArray[171] = 1704103554;
        nArray[172] = 1728967061;
        nArray[173] = 1737211246;
        nArray[174] = 1720132760;
        nArray[175] = 1711368291;
        nArray[176] = 1828378820;
        nArray[177] = 1820103743;
        nArray[178] = 1836060105;
        nArray[179] = 1844855090;
        nArray[180] = 1869168165;
        nArray[181] = 1877963486;
        nArray[182] = 1860430632;
        nArray[183] = 1852155859;
        nArray[184] = 1801148925;
        nArray[185] = 1809650950;
        nArray[186] = 1792118000;
        nArray[187] = 1784135691;
        nArray[188] = 1757986588;
        nArray[189] = 1750004711;
        nArray[190] = 1765960209;
        nArray[191] = 1774462698;
        nArray[192] = 1110107254;
        nArray[193] = 1118611597;
        nArray[194] = 1134571899;
        nArray[195] = 1126595968;
        nArray[196] = 1102643863;
        nArray[197] = 1094667884;
        nArray[198] = 1077139354;
        nArray[199] = 1085643617;
        nArray[200] = 1166763343;
        nArray[201] = 1158490548;
        nArray[202] = 1140961346;
        nArray[203] = 1149762745;
        nArray[204] = 1176011694;
        nArray[205] = 1184812885;
        nArray[206] = 1200772771;
        nArray[207] = 1192499800;
        nArray[208] = 1307552511;
        nArray[209] = 1298785796;
        nArray[210] = 1281720306;
        nArray[211] = 1289958153;
        nArray[212] = 1316768798;
        nArray[213] = 1325007077;
        nArray[214] = 1341561107;
        nArray[215] = 1332794856;
        nArray[216] = 1246636998;
        nArray[217] = 1254647613;
        nArray[218] = 1271201483;
        nArray[219] = 1262662192;
        nArray[220] = 1239272743;
        nArray[221] = 1230733788;
        nArray[222] = 1213667370;
        nArray[223] = 1221678289;
        nArray[224] = 1562785183;
        nArray[225] = 1570797924;
        nArray[226] = 1554833554;
        nArray[227] = 1546300521;
        nArray[228] = 1588974462;
        nArray[229] = 1580441477;
        nArray[230] = 1597965939;
        nArray[231] = 1605978760;
        nArray[232] = 1518843046;
        nArray[233] = 1510078557;
        nArray[234] = 1527603627;
        nArray[235] = 1535847760;
        nArray[236] = 1494504007;
        nArray[237] = 1502748348;
        nArray[238] = 1486784330;
        nArray[239] = 1478020017;
        nArray[240] = 1390639894;
        nArray[241] = 1382365165;
        nArray[242] = 1399434779;
        nArray[243] = 1408230112;
        nArray[244] = 1366334967;
        nArray[245] = 1375129868;
        nArray[246] = 1358579962;
        nArray[247] = 1350304769;
        nArray[248] = 1430452783;
        nArray[249] = 1438955220;
        nArray[250] = 1422405410;
        nArray[251] = 1414423513;
        nArray[252] = 1456544974;
        nArray[253] = 1448562741;
        nArray[254] = 1465633219;
        nArray[255] = 1474135352;
        crctable = nArray;
    }

    public PGPCRC() {
        this.reset();
    }

    private static int checksum(int accum, byte[] buf) {
        int pos = 0;
        int len = buf.length;
        while (len-- > 0) {
            accum = accum << 8 ^ crctable[(accum >>> 16 ^ buf[pos++]) & 0xFF];
        }
        return accum & 0xFFFFFF;
    }

    public static int checksum(byte[] buf) {
        return PGPCRC.checksum(11994318, buf);
    }

    public final long getValue() {
        return this.accum & 0xFFFFFFFF;
    }

    public void reset() {
        this.accum = 11994318;
    }

    public final void update(int b) {
        if (b > 255 || b < 0) {
            throw new IllegalArgumentException("Not a byte.");
        }
        byte[] tmp = new byte[]{(byte)b};
        this.update(tmp);
    }

    public final void update(byte[] buf) {
        this.accum = PGPCRC.checksum(this.accum, buf);
    }

    public final void update(byte[] buf, int off, int len) {
        byte[] b = new byte[len];
        System.arraycopy(buf, off, b, 0, len);
        this.update(b);
    }
}

