/*
 * Decompiled with CFR 0.152.
 */
package cryptix.openpgp.signature;

import cryptix.openpgp.PGPDataFormatException;
import cryptix.openpgp.PGPFatalDataFormatException;
import cryptix.openpgp.io.PGPSignatureDataInputStream;
import cryptix.openpgp.io.PGPSignatureDataOutputStream;
import cryptix.openpgp.signature.PGPSignatureSubPacket;
import cryptix.openpgp.util.PGPCompare;
import java.io.IOException;
import java.io.UnsupportedEncodingException;

public class PGPRevocationReasonSP
extends PGPSignatureSubPacket {
    public static final byte NO_REASON = 0;
    public static final byte SUPERCEDED = 1;
    public static final byte COMPROMISED = 2;
    public static final byte RETIRED = 3;
    public static final byte NO_LONGER_VALID = 32;
    private byte code = 0;
    private String value;

    protected void decodeBody(PGPSignatureDataInputStream in) throws IOException, PGPDataFormatException, PGPFatalDataFormatException {
        this.setCode(in.readByte());
        byte[] bytes = in.readByteArray();
        if (bytes.length == 0) {
            throw new PGPDataFormatException("String length == 0.");
        }
        try {
            String value = new String(bytes, "UTF-8");
            this.setValue(value);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new InternalError("Unsupported encoding: UTF-8");
        }
    }

    protected void encodeBody(PGPSignatureDataOutputStream out) throws IOException {
        if (this.getValue() == null) {
            throw new IllegalStateException("Packet data not initialized");
        }
        out.writeByte(this.getCode());
        try {
            byte[] bytes = this.getValue().getBytes("UTF-8");
            out.writeFully(bytes);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new InternalError("Unsupported encoding: UTF-8");
        }
    }

    public boolean equals(Object ssp) {
        if (!(ssp instanceof PGPRevocationReasonSP)) {
            return false;
        }
        PGPRevocationReasonSP that = (PGPRevocationReasonSP)ssp;
        return PGPCompare.equals(this.getPacketID(), that.getPacketID()) && PGPCompare.equals(this.getValue(), that.getValue()) && PGPCompare.equals(this.getCode(), that.getCode());
    }

    public byte getCode() {
        return this.code;
    }

    public String getValue() {
        return this.value;
    }

    public void setCode(byte code) {
        this.code = code;
    }

    public void setValue(String value) {
        if (value.length() == 0) {
            throw new IllegalArgumentException("String length == 0");
        }
        this.value = value;
    }
}

