/*
 * Decompiled with CFR 0.152.
 */
package cryptix.openpgp.provider;

import cryptix.message.Message;
import cryptix.message.MessageException;
import cryptix.message.SignedMessageBuilderSpi;
import cryptix.openpgp.PGPPrivateKey;
import cryptix.openpgp.PGPPublicKey;
import cryptix.openpgp.algorithm.PGPAlgorithmFactory;
import cryptix.openpgp.algorithm.PGPSigner;
import cryptix.openpgp.packet.PGPSignaturePacket;
import cryptix.openpgp.provider.PGPKeyIDFactory;
import cryptix.openpgp.provider.PGPLiteralMessageImpl;
import cryptix.openpgp.provider.PGPSignedMessageImpl;
import cryptix.openpgp.signature.PGPDateSP;
import cryptix.openpgp.signature.PGPKeyIDSP;
import cryptix.openpgp.signature.PGPSignatureSubPacket;
import cryptix.pki.KeyBundle;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.util.Date;
import java.util.Vector;

public abstract class PGPSignedMessageBuilder
extends SignedMessageBuilderSpi {
    private PGPLiteralMessageImpl contents;
    private SecureRandom sr;
    private PGPPrivateKey signingkey;
    private boolean v4sig;
    private boolean legacy;

    protected PGPSignedMessageBuilder(boolean v4sig, boolean legacy) {
        this.v4sig = v4sig;
        this.legacy = legacy;
    }

    public void engineAddSigner(KeyBundle bundle, char[] passphrase) throws IllegalStateException, MessageException, UnrecoverableKeyException {
        if (this.sr == null) {
            throw new IllegalStateException("Not yet initialized.");
        }
        if (this.signingkey != null) {
            throw new RuntimeException("Nesting signatures not supported yet.");
        }
        PGPPublicKey pubkey = (PGPPublicKey)bundle.getPublicKeys().next();
        this.signingkey = (PGPPrivateKey)bundle.getPrivateKey((PublicKey)pubkey, passphrase);
    }

    public void engineAddSigner(PrivateKey signingkey) throws IllegalStateException, MessageException {
        if (this.sr == null) {
            throw new IllegalStateException("Not yet initialized.");
        }
        if (signingkey != null) {
            throw new RuntimeException("Nesting signatures not supported yet.");
        }
        this.signingkey = (PGPPrivateKey)signingkey;
    }

    public Message engineBuild() throws IllegalStateException, MessageException {
        MessageDigest md;
        Object keyid;
        PGPSigner signer = (PGPSigner)this.signingkey.getPacket().getAlgorithm();
        byte algoid = this.signingkey.getPacket().getAlgorithmID();
        byte hashid = this.legacy ? (byte)1 : 2;
        PGPSignaturePacket pkt = new PGPSignaturePacket();
        pkt.setPacketID((byte)2);
        if (this.v4sig) {
            PGPDateSP creation = new PGPDateSP();
            creation.setValue(new Date());
            creation.setPacketID((byte)2);
            Vector<PGPDateSP> hashed = new Vector<PGPDateSP>();
            hashed.addElement(creation);
            keyid = new PGPKeyIDSP();
            try {
                ((PGPKeyIDSP)keyid).setValue(PGPKeyIDFactory.convert(this.signingkey).getBytes(8));
            }
            catch (InvalidKeyException ike) {
                throw new MessageException(String.valueOf(String.valueOf(ike)));
            }
            ((PGPSignatureSubPacket)keyid).setPacketID((byte)16);
            Vector<PGPKeyIDSP> unhashed = new Vector<PGPKeyIDSP>();
            unhashed.addElement((PGPKeyIDSP)keyid);
            if (this.contents.getDataType() == 2) {
                pkt.setData((byte)1, algoid, hashid, hashed, unhashed);
            } else {
                pkt.setData((byte)0, algoid, hashid, hashed, unhashed);
            }
        } else {
            byte[] time = new byte[4];
            int unixTime = (int)(System.currentTimeMillis() / 1000L);
            time[0] = (byte)(unixTime >>> 24 & 0xFF);
            time[1] = (byte)(unixTime >>> 16 & 0xFF);
            time[2] = (byte)(unixTime >>> 8 & 0xFF);
            time[3] = (byte)(unixTime & 0xFF);
            try {
                keyid = PGPKeyIDFactory.convert(this.signingkey).getBytes(8);
            }
            catch (InvalidKeyException ike) {
                throw new MessageException(String.valueOf(String.valueOf(ike)));
            }
            if (this.contents.getDataType() == 2) {
                pkt.setData((byte)1, time, (byte[])keyid, algoid, hashid);
            } else {
                pkt.setData((byte)0, time, (byte[])keyid, algoid, hashid);
            }
        }
        PGPAlgorithmFactory factory = PGPAlgorithmFactory.getDefaultInstance();
        try {
            md = factory.getHashAlgorithm(hashid);
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new MessageException(String.valueOf(String.valueOf(nsae)));
        }
        signer.initSign(hashid, factory);
        md.update(this.contents.getBinaryData());
        signer.update(this.contents.getBinaryData());
        int bytesWritten = pkt.hashData(md, signer);
        if (pkt.getVersion() == 4) {
            byte[] trailer = new byte[]{pkt.getVersion(), -1, (byte)(bytesWritten >> 24 & 0xFF), (byte)(bytesWritten >> 16 & 0xFF), (byte)(bytesWritten >> 8 & 0xFF), (byte)(bytesWritten & 0xFF)};
            md.update(trailer);
            signer.update(trailer);
        }
        byte[] digestcalc = md.digest();
        pkt.setHash(digestcalc);
        signer.computeSignature();
        pkt.setSignature(signer);
        return new PGPSignedMessageImpl(this.legacy, pkt, this.contents);
    }

    public void engineInit(Message contents, SecureRandom sr) throws IllegalStateException, MessageException {
        if (this.contents != null) {
            throw new IllegalStateException("Already initialized");
        }
        if (!(contents instanceof PGPLiteralMessageImpl)) {
            throw new IllegalArgumentException("We can only sign LiteralMessage objects.");
        }
        this.contents = (PGPLiteralMessageImpl)contents;
        this.sr = sr != null ? sr : new SecureRandom();
    }

    public void engineSetAttribute(String name, Object attr) throws IllegalStateException, IllegalArgumentException, MessageException {
        throw new IllegalArgumentException("No attributes supported.");
    }

    public static class V4
    extends PGPSignedMessageBuilder {
        public V4() {
            super(true, false);
        }
    }

    public static class V3
    extends PGPSignedMessageBuilder {
        public V3() {
            super(false, false);
        }
    }

    public static class Legacy
    extends PGPSignedMessageBuilder {
        public Legacy() {
            super(false, true);
        }
    }
}

