/*
 * Decompiled with CFR 0.152.
 */
package cryptix.openpgp.provider;

import cryptix.message.stream.EncryptedMessageOutputStreamSpi;
import cryptix.message.stream.MessageStreamException;
import cryptix.openpgp.PGPKey;
import cryptix.openpgp.PGPKeyBundle;
import cryptix.openpgp.PGPPublicKey;
import cryptix.openpgp.algorithm.PGPAlgorithmFactory;
import cryptix.openpgp.algorithm.PGPEncryptor;
import cryptix.openpgp.packet.PGPKeyPacket;
import cryptix.openpgp.packet.PGPPublicKeyEncryptedSessionKeyPacket;
import cryptix.openpgp.packet.PGPPublicKeyPacket;
import cryptix.openpgp.packet.PGPPublicSubKeyPacket;
import cryptix.openpgp.packet.PGPSymmetricKeyEncryptedSessionKeyPacket;
import cryptix.openpgp.provider.PGPKeyIDFactory;
import cryptix.pki.KeyBundle;
import cryptix.pki.KeyID;
import java.io.IOException;
import java.io.OutputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.util.Iterator;
import java.util.StringTokenizer;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class PGPEncryptedMessageOutputStream
implements EncryptedMessageOutputStreamSpi {
    private OutputStream out;
    private SecureRandom sr;
    private boolean nodatawritten = true;
    private byte[] buf = new byte[8192];
    private int partialLengthByte = 237;
    private int bufoffset = 0;
    private Cipher cipher;
    private byte datacipher;
    private byte[] sessionkey;

    public void engineAddRecipient(KeyBundle rcpt) throws IllegalStateException, UnsupportedOperationException, IOException, MessageStreamException {
        KeyID keyid;
        PGPEncryptor cryptor;
        byte id;
        PGPKeyPacket keypkt;
        Iterator it2 = ((PGPKeyBundle)rcpt).getPublicSubKeys();
        PGPKey publickey = null;
        while (it2.hasNext()) {
            PGPPublicKey temp = (PGPPublicKey)it2.next();
            publickey = temp;
        }
        if (publickey == null) {
            it2 = ((PGPKeyBundle)rcpt).getPublicKeys();
            publickey = (PGPPublicKey)it2.next();
            keypkt = (PGPPublicKeyPacket)publickey.getPacket();
            id = keypkt.getAlgorithmID();
            try {
                cryptor = (PGPEncryptor)keypkt.getAlgorithm();
            }
            catch (ClassCastException classCastException) {
                throw new MessageStreamException("No encryption key found.");
            }
        } else {
            keypkt = (PGPPublicSubKeyPacket)publickey.getPacket();
            id = keypkt.getAlgorithmID();
            cryptor = (PGPEncryptor)keypkt.getAlgorithm();
        }
        if (publickey == null) {
            throw new MessageStreamException("No encryption key found.");
        }
        PGPPublicKeyEncryptedSessionKeyPacket pkt = new PGPPublicKeyEncryptedSessionKeyPacket();
        pkt.setSessionKey(this.sessionkey, this.datacipher);
        pkt.encrypt(cryptor, this.sr);
        pkt.setPacketID((byte)1);
        pkt.setPublicKeyAlgorithmID(id);
        try {
            keyid = PGPKeyIDFactory.convert(publickey);
        }
        catch (InvalidKeyException ike) {
            ike.printStackTrace();
            throw new MessageStreamException(String.valueOf(String.valueOf(ike)));
        }
        pkt.setKeyID(keyid.getBytes(8));
        pkt.encode(this.out);
    }

    public void engineAddRecipient(String rcpt) throws IllegalStateException, UnsupportedOperationException, IOException, MessageStreamException {
        byte s2kid = 3;
        byte hashid = 2;
        PGPAlgorithmFactory factory = PGPAlgorithmFactory.getDefaultInstance();
        PGPSymmetricKeyEncryptedSessionKeyPacket pkt = new PGPSymmetricKeyEncryptedSessionKeyPacket();
        pkt.setDirect(rcpt, factory, this.sr, this.datacipher, s2kid, hashid);
        pkt.setPacketID((byte)3);
        pkt.encode(this.out);
    }

    public void engineAddRecipient(PublicKey rcpt) throws IllegalStateException, UnsupportedOperationException, IOException, MessageStreamException {
        KeyID keyid;
        PGPKeyPacket keypkt = ((PGPPublicKey)rcpt).getPacket();
        PGPEncryptor cryptor = (PGPEncryptor)keypkt.getAlgorithm();
        PGPPublicKeyEncryptedSessionKeyPacket pkt = new PGPPublicKeyEncryptedSessionKeyPacket();
        pkt.setSessionKey(this.sessionkey, this.datacipher);
        pkt.encrypt(cryptor, this.sr);
        pkt.setPacketID((byte)1);
        pkt.setPublicKeyAlgorithmID(keypkt.getAlgorithmID());
        try {
            keyid = PGPKeyIDFactory.convert(rcpt);
        }
        catch (InvalidKeyException ike) {
            ike.printStackTrace();
            throw new MessageStreamException(String.valueOf(String.valueOf(ike)));
        }
        pkt.setKeyID(keyid.getBytes(8));
        pkt.encode(this.out);
    }

    public void engineAddRecipient(SecretKey rcpt) throws IllegalStateException, UnsupportedOperationException, IOException, MessageStreamException {
        throw new UnsupportedOperationException("Symmetric key encryption not supported.");
    }

    public void engineClose() throws IOException, MessageStreamException {
        if (this.nodatawritten) {
            this.out.write(201);
            this.nodatawritten = false;
        }
        if (this.bufoffset < 192) {
            this.out.write((byte)this.bufoffset);
        } else if (this.bufoffset < 8384) {
            this.out.write(192 + (byte)(this.bufoffset - 192 >> 8));
            this.out.write((byte)(this.bufoffset - 192));
        } else {
            this.out.write(255);
            this.out.write((byte)(this.bufoffset >> 24));
            this.out.write((byte)(this.bufoffset >> 16));
            this.out.write((byte)(this.bufoffset >> 8));
            this.out.write((byte)this.bufoffset);
        }
        this.out.write(this.buf, 0, this.bufoffset);
        this.out.close();
    }

    public void engineFlush() throws IOException, MessageStreamException {
        this.out.flush();
    }

    public void engineInit(OutputStream out, SecureRandom sr) throws IllegalStateException, IOException, MessageStreamException {
        int blocksize;
        int keysize;
        if (this.out != null) {
            throw new IllegalStateException("Already called init before");
        }
        if (out == null) {
            throw new IllegalArgumentException("Outputstream cannot be null");
        }
        this.out = out;
        this.sr = sr;
        this.datacipher = (byte)2;
        PGPAlgorithmFactory factory = PGPAlgorithmFactory.getDefaultInstance();
        try {
            this.cipher = factory.getCipherAlgorithm(this.datacipher, "OpenpgpCFB");
            keysize = factory.getCipherKeySize(this.datacipher);
            blocksize = factory.getCipherBlockSize(this.datacipher);
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new MessageStreamException(String.valueOf(String.valueOf(nsae)));
        }
        this.sessionkey = new byte[keysize];
        sr.nextBytes(this.sessionkey);
        StringTokenizer st = new StringTokenizer(this.cipher.getAlgorithm(), "/");
        SecretKeySpec keyspec = new SecretKeySpec(this.sessionkey, st.nextToken());
        byte[] iv = new byte[blocksize];
        int j = 0;
        while (j < iv.length) {
            iv[j] = 0;
            ++j;
        }
        IvParameterSpec ivspec = new IvParameterSpec(iv);
        try {
            this.cipher.init(1, (Key)keyspec, ivspec);
        }
        catch (InvalidKeyException ike) {
            ike.printStackTrace();
            throw new InternalError("InvalidKeyException on encrypting a key - " + ike);
        }
        catch (InvalidAlgorithmParameterException iape) {
            iape.printStackTrace();
            throw new InternalError("InvalidAlgorithmParameterException on encrypting a key - " + iape);
        }
        byte[] prefix = new byte[blocksize + 2];
        sr.nextBytes(prefix);
        prefix[blocksize] = prefix[blocksize - 2];
        prefix[blocksize + 1] = prefix[blocksize - 1];
        byte[] ciphdata = this.cipher.update(prefix);
        System.arraycopy(ciphdata, 0, this.buf, 0, ciphdata.length);
        this.bufoffset = ciphdata.length;
    }

    public void engineSetAttribute(String name, Object attr) throws IllegalStateException, IllegalArgumentException, MessageStreamException {
        throw new IllegalArgumentException("No attributes supported");
    }

    public void engineWrite(int b) throws IOException, MessageStreamException {
        byte[] b1 = new byte[]{(byte)b};
        this.engineWrite(b1, 0, 1);
    }

    public void engineWrite(byte[] b) throws IOException, MessageStreamException {
        this.engineWrite(b, 0, b.length);
    }

    public void engineWrite(byte[] b, int off, int len) throws IOException, MessageStreamException {
        byte[] c;
        if (this.out == null) {
            throw new IllegalStateException("Not yet initialized");
        }
        if (this.nodatawritten) {
            this.out.write(201);
            this.nodatawritten = false;
        }
        if ((c = this.cipher.update(b, off, len)) == null) {
            c = new byte[]{};
        }
        len = c.length;
        off = 0;
        while (this.bufoffset + len > this.buf.length) {
            System.arraycopy(c, off, this.buf, this.bufoffset, this.buf.length - this.bufoffset);
            this.out.write(this.partialLengthByte);
            this.out.write(this.buf, 0, this.buf.length);
            off += this.buf.length - this.bufoffset;
            len -= this.buf.length - this.bufoffset;
            this.bufoffset = 0;
        }
        System.arraycopy(c, off, this.buf, this.bufoffset, len);
        this.bufoffset += len;
    }
}

