/*
 * Decompiled with CFR 0.152.
 */
package cryptix.openpgp.provider;

import cryptix.openpgp.PGPCertificate;
import cryptix.openpgp.PGPDataFormatException;
import cryptix.openpgp.PGPFatalDataFormatException;
import cryptix.openpgp.PGPPrincipal;
import cryptix.openpgp.PGPPublicKey;
import cryptix.openpgp.algorithm.PGPAlgorithmFactory;
import cryptix.openpgp.algorithm.PGPSigner;
import cryptix.openpgp.io.PGPHashDataOutputStream;
import cryptix.openpgp.packet.PGPPublicKeyPacket;
import cryptix.openpgp.packet.PGPSignaturePacket;
import cryptix.openpgp.packet.PGPUserIDPacket;
import cryptix.openpgp.provider.PGPKeyIDImpl;
import cryptix.openpgp.provider.PGPUserIDPrincipal;
import cryptix.openpgp.signature.PGPBooleanSP;
import cryptix.openpgp.signature.PGPDateSP;
import cryptix.openpgp.signature.PGPKeyFlagsSP;
import cryptix.openpgp.signature.PGPKeyIDSP;
import cryptix.openpgp.signature.PGPNotationDataSP;
import cryptix.openpgp.signature.PGPSignatureSubPacket;
import cryptix.openpgp.signature.PGPStringSP;
import cryptix.openpgp.signature.PGPTrustSP;
import cryptix.pki.KeyBundle;
import cryptix.pki.KeyID;
import cryptix.pki.KeyIDFactory;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Principal;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.CertificateParsingException;
import java.util.Date;
import java.util.Properties;
import java.util.Vector;

public class PGPCertificateImpl
extends PGPCertificate {
    private PGPSignaturePacket pkt;
    private PGPPrincipal subject;
    private PGPPublicKey key;
    private boolean hasCachedCreationDate;
    private Date cachedCreationDate;
    private boolean hasCachedExpirationDate;
    private Date cachedExpirationDate;
    private boolean hasCachedIsExportable;
    private boolean cachedIsExportable;
    private boolean hasCachedTrust;
    private int cachedTrustLevel;
    private int cachedTrustAmount;
    private boolean hasCachedTrustRegularExpression;
    private String cachedTrustRegularExpression;
    private boolean hasCachedIsRevocable;
    private boolean cachedIsRevocable;
    private boolean hasCachedIssuerKeyID;
    private KeyID cachedIssuerKeyID;
    private boolean hasCachedNotationData;
    private Properties cachedMachineReadableNotationData;
    private Properties cachedHumanReadableNotationData;
    private boolean hasCachedPolicyURL;
    private String cachedPolicyURL;
    private boolean hasCachedKeyFlags;
    private boolean cachedKeyFlagsSpecified;
    private boolean cachedKeyFlagCertification;
    private boolean cachedKeyFlagSignData;
    private boolean cachedKeyFlagEncryptCommunication;
    private boolean cachedKeyFlagEncryptStorage;
    private boolean hasCachedIssuerUserID;
    private PGPPrincipal cachedIssuerUserID;
    private boolean hasCachedPublicKeyID;
    private KeyID cachedPublicKeyID;
    private boolean parsed = false;

    PGPCertificateImpl(PGPSignaturePacket pkt, PGPPrincipal subject, PGPPublicKey key) {
        super("OpenPGP");
        this.pkt = pkt;
        this.subject = subject;
        this.key = key;
    }

    private void cacheKeyFlags() throws CertificateParsingException {
        this.hasCachedKeyFlags = true;
        PGPSignatureSubPacket sp = this.getHashedPacket((byte)27);
        if (sp == null) {
            this.cachedKeyFlagsSpecified = false;
        } else {
            this.cachedKeyFlagsSpecified = true;
            this.cachedKeyFlagCertification = ((PGPKeyFlagsSP)sp).getCertify();
            this.cachedKeyFlagSignData = ((PGPKeyFlagsSP)sp).getSign();
            this.cachedKeyFlagEncryptCommunication = ((PGPKeyFlagsSP)sp).getEncryptCommunication();
            this.cachedKeyFlagEncryptStorage = ((PGPKeyFlagsSP)sp).getEncryptStorage();
        }
    }

    private void cacheNotationData() {
        this.cachedMachineReadableNotationData = new Properties();
        this.cachedHumanReadableNotationData = new Properties();
        if (this.pkt.getVersion() == 3) {
            return;
        }
        Vector hashed = this.pkt.getHashedSubPackets();
        int i = 0;
        while (i < hashed.size()) {
            PGPSignatureSubPacket sp = (PGPSignatureSubPacket)hashed.elementAt(i);
            if (sp instanceof PGPNotationDataSP) {
                PGPNotationDataSP nsp = (PGPNotationDataSP)sp;
                String name = nsp.getNameData();
                String value = nsp.getValueData();
                if (nsp.getHumanReadable()) {
                    this.cachedHumanReadableNotationData.setProperty(name, value);
                } else {
                    this.cachedMachineReadableNotationData.setProperty(name, value);
                }
            }
            ++i;
        }
    }

    public void checkValidity() throws CertificateExpiredException, CertificateNotYetValidException, CertificateParsingException {
        Date now = new Date();
        this.checkValidity(now);
    }

    public void checkValidity(Date date) throws CertificateExpiredException, CertificateNotYetValidException, CertificateParsingException {
        if (date.compareTo(this.getCreationDate()) < 0) {
            throw new CertificateNotYetValidException("date is before creation");
        }
        if (this.getExpirationDate() != null && date.compareTo(this.getExpirationDate()) > 0) {
            throw new CertificateExpiredException("date is after expiration");
        }
    }

    public Date getCreationDate() throws CertificateParsingException {
        if (this.hasCachedCreationDate) {
            return this.cachedCreationDate;
        }
        if (this.pkt.getVersion() == 3) {
            byte[] timebytes = this.pkt.getTime();
            long time = ((timebytes[0] & 0xFF) << 24) + ((timebytes[1] & 0xFF) << 16) + ((timebytes[2] & 0xFF) << 8) + (timebytes[3] & 0xFF);
            this.cachedCreationDate = new Date(time *= 1000L);
            this.hasCachedCreationDate = true;
            return this.cachedCreationDate;
        }
        if (this.pkt.getVersion() == 4) {
            PGPSignatureSubPacket sp = this.getHashedPacket((byte)2);
            if (sp == null) {
                throw new CertificateParsingException("No creation time in hashed area.");
            }
            this.cachedCreationDate = ((PGPDateSP)sp).getValue();
            this.hasCachedCreationDate = true;
            return this.cachedCreationDate;
        }
        throw new CertificateParsingException("Invalid sig version " + this.pkt.getVersion());
    }

    public byte[] getEncoded() throws CertificateEncodingException {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            this.key.getPacket().encode(baos);
            this.subject.getPacket().encode(baos);
            this.pkt.encode(baos);
            baos.close();
            return baos.toByteArray();
        }
        catch (IOException e) {
            throw new InternalError("IOException in ByteArrayOutputStream " + e);
        }
    }

    public Date getExpirationDate() throws CertificateParsingException {
        if (this.hasCachedExpirationDate) {
            return this.cachedExpirationDate;
        }
        PGPSignatureSubPacket sp = this.getHashedPacket((byte)3);
        this.cachedExpirationDate = sp == null ? null : ((PGPDateSP)sp).getValue();
        this.hasCachedExpirationDate = true;
        return this.cachedExpirationDate;
    }

    PGPSignatureSubPacket getHashedPacket(byte ID) throws CertificateParsingException {
        PGPSignatureSubPacket ssp;
        this.parse();
        if (this.pkt.getVersion() == 3) {
            return null;
        }
        if (this.pkt.getVersion() != 4) {
            throw new CertificateParsingException("Invalid sig version " + this.pkt.getVersion());
        }
        Vector hashed = this.pkt.getHashedSubPackets();
        Vector unhashed = this.pkt.getUnhashedSubPackets();
        PGPSignatureSubPacket thessp = null;
        int i = 0;
        while (i < unhashed.size()) {
            ssp = (PGPSignatureSubPacket)unhashed.elementAt(i);
            if (ssp.getPacketID() == ID) {
                throw new CertificateParsingException("Packet found in unhashed area.");
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < hashed.size()) {
            ssp = (PGPSignatureSubPacket)hashed.elementAt(i2);
            if (ssp.getPacketID() == ID) {
                if (thessp != null) {
                    throw new CertificateParsingException("Packet found more than once.");
                }
                thessp = ssp;
            }
            ++i2;
        }
        return thessp;
    }

    public Properties getHumanReadableNotationData() throws CertificateParsingException {
        if (this.hasCachedNotationData) {
            return this.cachedHumanReadableNotationData;
        }
        this.cacheNotationData();
        return this.cachedHumanReadableNotationData;
    }

    public KeyID getIssuerKeyID() throws CertificateParsingException {
        if (this.hasCachedIssuerKeyID) {
            return this.cachedIssuerKeyID;
        }
        if (this.pkt.getVersion() == 3) {
            byte[] keyid = this.pkt.getKeyID();
            this.cachedIssuerKeyID = new PGPKeyIDImpl(null, keyid, 3);
        } else if (this.pkt.getVersion() == 4) {
            PGPSignatureSubPacket sp = this.getUnhashedPacket((byte)16);
            if (sp == null) {
                this.cachedIssuerKeyID = null;
            } else {
                byte[] keyid = ((PGPKeyIDSP)sp).getValue();
                this.cachedIssuerKeyID = new PGPKeyIDImpl(null, keyid, 4);
            }
        } else {
            throw new CertificateParsingException("Invalid sig version " + this.pkt.getVersion());
        }
        this.hasCachedIssuerKeyID = true;
        return this.cachedIssuerKeyID;
    }

    public PGPPrincipal getIssuerUserID() throws CertificateParsingException {
        if (this.hasCachedIssuerUserID) {
            return this.cachedIssuerUserID;
        }
        PGPSignatureSubPacket sp = this.getHashedPacket((byte)28);
        if (sp == null) {
            this.cachedIssuerUserID = null;
        } else {
            String value = ((PGPStringSP)sp).getValue();
            PGPUserIDPacket uidpkt = new PGPUserIDPacket();
            uidpkt.setValue(value);
            this.cachedIssuerUserID = new PGPUserIDPrincipal(uidpkt);
        }
        this.hasCachedIssuerUserID = true;
        return this.cachedIssuerUserID;
    }

    public boolean getKeyFlagCertification() throws CertificateParsingException {
        if (!this.hasCachedKeyFlags) {
            this.cacheKeyFlags();
        }
        if (!this.cachedKeyFlagsSpecified) {
            throw new UnsupportedOperationException("Key flags not specified");
        }
        return this.cachedKeyFlagCertification;
    }

    public boolean getKeyFlagEncryptCommunication() throws CertificateParsingException {
        if (!this.hasCachedKeyFlags) {
            this.cacheKeyFlags();
        }
        if (!this.cachedKeyFlagsSpecified) {
            throw new UnsupportedOperationException("Key flags not specified");
        }
        return this.cachedKeyFlagEncryptCommunication;
    }

    public boolean getKeyFlagEncryptStorage() throws CertificateParsingException {
        if (!this.hasCachedKeyFlags) {
            this.cacheKeyFlags();
        }
        if (!this.cachedKeyFlagsSpecified) {
            throw new UnsupportedOperationException("Key flags not specified");
        }
        return this.cachedKeyFlagEncryptStorage;
    }

    public boolean getKeyFlagSignData() throws CertificateParsingException {
        if (!this.hasCachedKeyFlags) {
            this.cacheKeyFlags();
        }
        if (!this.cachedKeyFlagsSpecified) {
            throw new UnsupportedOperationException("Key flags not specified");
        }
        return this.cachedKeyFlagSignData;
    }

    public boolean getKeyFlagsSpecified() throws CertificateParsingException {
        if (!this.hasCachedKeyFlags) {
            this.cacheKeyFlags();
        }
        return this.cachedKeyFlagsSpecified;
    }

    public Properties getMachineReadableNotationData() throws CertificateParsingException {
        if (this.hasCachedNotationData) {
            return this.cachedMachineReadableNotationData;
        }
        this.cacheNotationData();
        return this.cachedMachineReadableNotationData;
    }

    public PGPSignaturePacket getPacket() {
        return this.pkt;
    }

    public String getPolicyURL() throws CertificateParsingException {
        if (this.hasCachedPolicyURL) {
            return this.cachedPolicyURL;
        }
        PGPSignatureSubPacket sp = this.getHashedPacket((byte)26);
        this.cachedPolicyURL = sp == null ? null : ((PGPStringSP)sp).getValue();
        this.hasCachedPolicyURL = true;
        return this.cachedPolicyURL;
    }

    public PublicKey getPublicKey() {
        return this.key;
    }

    public KeyID getPublicKeyID() throws CertificateParsingException {
        try {
            if (this.hasCachedPublicKeyID) {
                return this.cachedPublicKeyID;
            }
            KeyIDFactory kf = KeyIDFactory.getInstance((String)"OpenPGP");
            this.cachedPublicKeyID = kf.generateKeyID((Key)this.key);
            this.hasCachedPublicKeyID = true;
            return this.cachedPublicKeyID;
        }
        catch (InvalidKeyException ike) {
            throw new CertificateParsingException(String.valueOf(String.valueOf(ike)));
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new CertificateParsingException(String.valueOf(String.valueOf(nsae)));
        }
    }

    public Principal getSubject() {
        return this.subject;
    }

    public int getTrustAmount() throws CertificateParsingException {
        if (this.hasCachedTrust) {
            return this.cachedTrustAmount;
        }
        PGPSignatureSubPacket sp = this.getHashedPacket((byte)5);
        if (sp == null) {
            this.cachedTrustLevel = 0;
            this.cachedTrustAmount = 0;
        } else {
            this.cachedTrustLevel = ((PGPTrustSP)sp).getDepth();
            this.cachedTrustAmount = ((PGPTrustSP)sp).getAmount();
        }
        this.hasCachedTrust = true;
        return this.cachedTrustAmount;
    }

    public int getTrustLevel() throws CertificateParsingException {
        if (this.hasCachedTrust) {
            return this.cachedTrustLevel;
        }
        PGPSignatureSubPacket sp = this.getHashedPacket((byte)5);
        if (sp == null) {
            this.cachedTrustLevel = 0;
            this.cachedTrustAmount = 0;
        } else {
            this.cachedTrustLevel = ((PGPTrustSP)sp).getDepth();
            this.cachedTrustAmount = ((PGPTrustSP)sp).getAmount();
        }
        this.hasCachedTrust = true;
        return this.cachedTrustLevel;
    }

    public String getTrustRegularExpression() throws CertificateParsingException {
        if (this.hasCachedTrustRegularExpression) {
            return this.cachedTrustRegularExpression;
        }
        PGPSignatureSubPacket sp = this.getHashedPacket((byte)6);
        this.cachedTrustRegularExpression = sp == null ? null : ((PGPStringSP)sp).getValue();
        this.hasCachedTrustRegularExpression = true;
        return this.cachedTrustRegularExpression;
    }

    PGPSignatureSubPacket getUnhashedPacket(byte ID) throws CertificateParsingException {
        this.parse();
        if (this.pkt.getVersion() == 3) {
            return null;
        }
        if (this.pkt.getVersion() != 4) {
            throw new CertificateParsingException("Invalid sig version " + this.pkt.getVersion());
        }
        Vector ssps = this.pkt.getAllSubPackets();
        PGPSignatureSubPacket thessp = null;
        int i = 0;
        while (i < ssps.size()) {
            PGPSignatureSubPacket ssp = (PGPSignatureSubPacket)ssps.elementAt(i);
            if (ssp.getPacketID() == ID) {
                if (thessp != null) {
                    throw new CertificateParsingException("Packet found more than once.");
                }
                thessp = ssp;
            }
            ++i;
        }
        return thessp;
    }

    public boolean isExportable() throws CertificateParsingException {
        if (this.hasCachedIsExportable) {
            return this.cachedIsExportable;
        }
        PGPSignatureSubPacket sp = this.getHashedPacket((byte)4);
        this.cachedIsExportable = sp == null ? true : ((PGPBooleanSP)sp).getValue();
        this.hasCachedIsExportable = true;
        return this.cachedIsExportable;
    }

    public boolean isRevocable() throws CertificateParsingException {
        if (this.hasCachedIsRevocable) {
            return this.cachedIsRevocable;
        }
        PGPSignatureSubPacket sp = this.getHashedPacket((byte)7);
        this.cachedIsRevocable = sp == null ? true : ((PGPBooleanSP)sp).getValue();
        this.hasCachedIsRevocable = true;
        return this.cachedIsRevocable;
    }

    public boolean isSelfSigned() throws CertificateException {
        return this.getIssuerKeyID().match(this.getPublicKeyID());
    }

    private void parse() throws CertificateParsingException {
        try {
            if (this.parsed) {
                return;
            }
            if (this.pkt.getVersion() > 3) {
                this.pkt.parseSignatureSubPackets();
            }
            this.parsed = true;
        }
        catch (PGPDataFormatException pdfe) {
            throw new CertificateParsingException(String.valueOf(String.valueOf(pdfe)));
        }
        catch (PGPFatalDataFormatException pfdfe) {
            throw new CertificateParsingException(String.valueOf(String.valueOf(pfdfe)));
        }
    }

    public String toString() {
        throw new RuntimeException("NYI");
    }

    public void verify(KeyBundle bundle) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        this.verify((PublicKey)bundle.getPublicKeys().next());
    }

    public void verify(PublicKey key) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        byte[] digestinsig;
        byte[] digestcalc;
        boolean ok;
        byte[] useridbytes;
        if (!(key instanceof PGPPublicKey)) {
            throw new InvalidKeyException("Not instance of PGPPublicKey");
        }
        PGPPublicKey signkey = (PGPPublicKey)key;
        if (!(signkey.getPacket() instanceof PGPPublicKeyPacket)) {
            throw new InvalidKeyException("Not a public signing key");
        }
        PGPPublicKeyPacket keypkt = (PGPPublicKeyPacket)this.key.getPacket();
        PGPUserIDPacket idpkt = (PGPUserIDPacket)this.subject.getPacket();
        PGPSigner signer = (PGPSigner)signkey.getPacket().getAlgorithm();
        PGPAlgorithmFactory factory = PGPAlgorithmFactory.getDefaultInstance();
        MessageDigest md = factory.getHashAlgorithm(this.pkt.getHashID());
        signer.initVerify(this.pkt.getHashID(), factory);
        PGPHashDataOutputStream hdos = new PGPHashDataOutputStream(md, signer);
        try {
            keypkt.encodeBody(hdos);
            hdos.close();
        }
        catch (IOException ioe) {
            throw new InternalError("IOException on hashing key - " + ioe);
        }
        try {
            useridbytes = idpkt.getValue().getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new InternalError("UTF-8 encoding not supported.");
        }
        if (this.pkt.getVersion() == 4) {
            byte[] pre = new byte[]{-76, (byte)(useridbytes.length >> 24 & 0xFF), (byte)(useridbytes.length >> 16 & 0xFF), (byte)(useridbytes.length >> 8 & 0xFF), (byte)(useridbytes.length & 0xFF)};
            md.update(pre);
            signer.update(pre);
        }
        md.update(useridbytes);
        signer.update(useridbytes);
        int bytesWritten = this.pkt.hashData(md, signer);
        if (this.pkt.getVersion() == 4) {
            byte[] trailer = new byte[]{this.pkt.getVersion(), -1, (byte)(bytesWritten >> 24 & 0xFF), (byte)(bytesWritten >> 16 & 0xFF), (byte)(bytesWritten >> 8 & 0xFF), (byte)(bytesWritten & 0xFF)};
            md.update(trailer);
            signer.update(trailer);
        }
        boolean bl = ok = (digestcalc = md.digest())[0] == (digestinsig = this.pkt.getHash())[0] && digestcalc[1] == digestinsig[1];
        if (!ok) {
            throw new SignatureException("Invalid signature");
        }
        try {
            this.pkt.interpretSignature(signer);
        }
        catch (IOException ioe) {
            throw new InternalError("IOException while parsing signature " + ioe);
        }
        catch (PGPDataFormatException pGPDataFormatException) {
            throw new CertificateParsingException("Invalid signature");
        }
        if (!signer.verifySignature()) {
            throw new SignatureException("Invalid signature");
        }
    }

    public void verify(PublicKey key, String sigProvider) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        if (!sigProvider.equals("CryptixOpenPGP")) {
            throw new NoSuchProviderException("Only CryptixOpenPGP is supported as a provider.");
        }
        this.verify(key);
    }
}

