/*
 * Decompiled with CFR 0.152.
 */
package cryptix.openpgp.io;

import cryptix.openpgp.PGPDataFormatException;
import cryptix.openpgp.PGPFatalDataFormatException;
import cryptix.openpgp.util.PGPMPI;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;

public abstract class PGPDataInputStream {
    public abstract void close() throws IOException, PGPDataFormatException, PGPFatalDataFormatException;

    public boolean readBoolean() throws IOException, PGPDataFormatException, PGPFatalDataFormatException {
        return this.readInternal() != 0;
    }

    public byte readByte() throws IOException, PGPDataFormatException, PGPFatalDataFormatException {
        return (byte)this.readInternal();
    }

    public void readFully(byte[] b) throws IOException, PGPDataFormatException, PGPFatalDataFormatException {
        this.readFully(b, 0, b.length);
    }

    public void readFully(byte[] b, int offset, int len) throws IOException, PGPDataFormatException, PGPFatalDataFormatException {
        int i = offset;
        while (i < len + offset) {
            b[i] = (byte)this.readInternal();
            ++i;
        }
    }

    public int readInt() throws IOException, PGPDataFormatException, PGPFatalDataFormatException {
        return this.readInternal() << 24 | (this.readInternal() & 0xFF) << 16 | (this.readInternal() & 0xFF) << 8 | this.readInternal() & 0xFF;
    }

    protected abstract int readInternal() throws IOException, PGPDataFormatException, PGPFatalDataFormatException;

    public String readLengthPrependedString() throws IOException, PGPDataFormatException, PGPFatalDataFormatException {
        short len = this.readUnsignedByte();
        byte[] b = new byte[len];
        this.readFully(b);
        try {
            return new String(b, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new InternalError("UTF-8 encoding not supported");
        }
    }

    public long readLong() throws IOException, PGPDataFormatException, PGPFatalDataFormatException {
        return (long)this.readInternal() << 56 | ((long)this.readInternal() & 0xFFL) << 48 | ((long)this.readInternal() & 0xFFL) << 40 | ((long)this.readInternal() & 0xFFL) << 32 | ((long)this.readInternal() & 0xFFL) << 24 | ((long)this.readInternal() & 0xFFL) << 16 | ((long)this.readInternal() & 0xFFL) << 8 | (long)this.readInternal() & 0xFFL;
    }

    public BigInteger readMPI() throws IOException, PGPDataFormatException, PGPFatalDataFormatException {
        int len = this.readUnsignedShort();
        byte[] data = new byte[(len + 7) / 8 + 2];
        data[0] = (byte)(len >> 8);
        data[1] = (byte)len;
        this.readFully(data, 2, (len + 7) / 8);
        ByteArrayInputStream bais = new ByteArrayInputStream(data);
        DataInputStream dis = new DataInputStream(bais);
        return PGPMPI.decode(dis);
    }

    public String readNullTerminatedString() throws IOException, PGPDataFormatException, PGPFatalDataFormatException {
        int b;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        while ((b = this.readInternal()) != 0) {
            baos.write(b);
        }
        byte[] bytes = baos.toByteArray();
        if (bytes.length == 0) {
            this.close();
            throw new PGPDataFormatException("String length == 0.");
        }
        try {
            return new String(bytes, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new InternalError("UTF-8 encoding not supported");
        }
    }

    public short readShort() throws IOException, PGPDataFormatException, PGPFatalDataFormatException {
        return (short)(this.readInternal() << 8 | this.readInternal() & 0xFF);
    }

    public String readString(int len) throws IOException, PGPDataFormatException, PGPFatalDataFormatException {
        byte[] b = new byte[len];
        this.readFully(b);
        try {
            return new String(b, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new InternalError("UTF-8 encoding not supported");
        }
    }

    public short readUnsignedByte() throws IOException, PGPDataFormatException, PGPFatalDataFormatException {
        return (short)(this.readInternal() & 0xFF);
    }

    public long readUnsignedInt() throws IOException, PGPDataFormatException, PGPFatalDataFormatException {
        return ((long)this.readInternal() & 0xFFL) << 24 | ((long)this.readInternal() & 0xFFL) << 16 | ((long)this.readInternal() & 0xFFL) << 8 | (long)this.readInternal() & 0xFFL;
    }

    public int readUnsignedShort() throws IOException, PGPDataFormatException, PGPFatalDataFormatException {
        return (this.readInternal() & 0xFF) << 8 | this.readInternal() & 0xFF;
    }
}

