/*
 * Decompiled with CFR 0.152.
 */
package cryptix.openpgp.io;

import cryptix.openpgp.PGPDataFormatException;
import cryptix.openpgp.PGPFatalDataFormatException;
import cryptix.openpgp.io.PGPLengthDataInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.crypto.Cipher;
import javax.crypto.ShortBufferException;

public class PGPCipherDataInputStream
extends PGPLengthDataInputStream {
    private PGPLengthDataInputStream in;
    private byte[] buffer = new byte[4096];
    private Cipher c;
    private long chunkLength = 0L;
    private long chunkBytesRead = -1L;

    public PGPCipherDataInputStream(PGPLengthDataInputStream in, Cipher c) {
        this.in = in;
        this.c = c;
    }

    protected long getNewChunkLength(InputStream in) throws IOException, PGPDataFormatException, PGPFatalDataFormatException {
        byte[] grmbl = new byte[this.buffer.length];
        this.chunkBytesRead = 0L;
        this.chunkLength = this.in.readBuffer(grmbl);
        try {
            if (this.c.update(grmbl, 0, this.buffer.length, this.buffer, 0) != this.buffer.length) {
                throw new RuntimeException("Length of encrypted data > length of decrypted data");
            }
        }
        catch (ShortBufferException sbe) {
            throw new RuntimeException("Length of encrypted data < length of decrypted data - " + sbe);
        }
        return this.chunkLength;
    }

    protected int readDirect() throws IOException, PGPDataFormatException, PGPFatalDataFormatException {
        ++this.chunkBytesRead;
        return this.buffer[(int)this.chunkBytesRead - 1];
    }
}

