/*
 * Decompiled with CFR 0.152.
 */
package cryptix.openpgp.algorithm;

import cryptix.openpgp.PGPDataFormatException;
import cryptix.openpgp.PGPFatalDataFormatException;
import cryptix.openpgp.algorithm.PGPAlgorithmFactory;
import cryptix.openpgp.algorithm.PGPPublicKeyAlgorithm;
import cryptix.openpgp.algorithm.PGPSigner;
import cryptix.openpgp.io.PGPDataInputStream;
import cryptix.openpgp.io.PGPDataOutputStream;
import cryptix.openpgp.util.PGPDSAElGamalSignatureParser;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyPairGeneratorSpi;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.SignatureException;
import java.security.interfaces.DSAKey;
import java.security.interfaces.DSAParams;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.DSAPublicKey;

public class PGPDSA
implements PGPSigner {
    private BigInteger p = null;
    private BigInteger q = null;
    private BigInteger g = null;
    private BigInteger x = null;
    private BigInteger y = null;
    private BigInteger r = null;
    private BigInteger s = null;
    private Signature sig;
    private MessageDigest md;
    private boolean raw = false;

    public PGPDSA() {
        this.initSigObject();
    }

    PGPDSA(BigInteger p, BigInteger q, BigInteger g, BigInteger y) {
        this.initSigObject();
        this.p = p;
        this.q = q;
        this.g = g;
        this.y = y;
    }

    PGPDSA(BigInteger p, BigInteger q, BigInteger g, BigInteger x, BigInteger y) {
        this.initSigObject();
        this.p = p;
        this.q = q;
        this.g = g;
        this.x = x;
        this.y = y;
    }

    public PGPPublicKeyAlgorithm clonePrivate() {
        return new PGPDSA(this.p, this.q, this.g, this.x, this.y);
    }

    public PGPPublicKeyAlgorithm clonePublic() {
        return new PGPDSA(this.p, this.q, this.g, this.y);
    }

    private boolean compare(BigInteger a, BigInteger b) {
        if (a == null) {
            return b == null;
        }
        if (b == null) {
            return false;
        }
        return a.equals(b);
    }

    public void computeSignature() {
        PGPDSAElGamalSignatureParser parser;
        byte[] sigdata;
        try {
            if (this.raw) {
                this.sig.update(this.md.digest());
            }
            sigdata = this.sig.sign();
        }
        catch (SignatureException signatureException) {
            throw new IllegalStateException("Signature not initialized");
        }
        catch (NullPointerException nullPointerException) {
            throw new IllegalStateException("Signature not initialized");
        }
        try {
            parser = new PGPDSAElGamalSignatureParser(sigdata);
        }
        catch (PGPDataFormatException dfe) {
            dfe.printStackTrace();
            throw new RuntimeException("PGPDataFormatException on encoding signature. This usually means that the JCE DSA output is wrong. - " + dfe);
        }
        this.r = parser.getR();
        this.s = parser.getS();
    }

    public void decodePublicData(PGPDataInputStream in) throws IOException, PGPDataFormatException, PGPFatalDataFormatException {
        this.p = in.readMPI();
        this.q = in.readMPI();
        this.g = in.readMPI();
        this.y = in.readMPI();
    }

    public void decodeSecretData(PGPDataInputStream in) throws IOException, PGPDataFormatException, PGPFatalDataFormatException {
        this.x = in.readMPI();
    }

    public void decodeSignatureData(PGPDataInputStream in) throws IOException, PGPDataFormatException, PGPFatalDataFormatException {
        this.r = in.readMPI();
        this.s = in.readMPI();
        if (this.r == null || this.s == null) {
            throw new PGPDataFormatException("Invalid sig, r == null || s == null");
        }
        if (this.r.signum() != 1 || this.s.signum() != 1) {
            throw new PGPDataFormatException("Invalid sig, r <= 0 || s <= 0");
        }
    }

    public void encodePublicData(PGPDataOutputStream out) throws IOException {
        out.writeMPI(this.p);
        out.writeMPI(this.q);
        out.writeMPI(this.g);
        out.writeMPI(this.y);
    }

    public void encodeSecretData(PGPDataOutputStream out) throws IOException {
        out.writeMPI(this.x);
    }

    public void encodeSignatureData(PGPDataOutputStream out) throws IOException {
        out.writeMPI(this.r);
        out.writeMPI(this.s);
    }

    public boolean equals(Object obj) {
        if (obj instanceof PGPDSA) {
            PGPDSA objx = (PGPDSA)obj;
            return objx.equals(this.p, this.q, this.g, this.x, this.y);
        }
        return false;
    }

    boolean equals(BigInteger p, BigInteger q, BigInteger g, BigInteger x, BigInteger y) {
        return this.compare(this.p, p) && this.compare(this.q, q) && this.compare(this.g, g) && this.compare(this.x, x) && this.compare(this.y, y);
    }

    public void forgetSecretData() {
        this.x = null;
    }

    public void generateKeyPair(int keysize, SecureRandom sr) {
        KeyPairGenerator kpg;
        try {
            kpg = KeyPairGenerator.getInstance("DSA");
        }
        catch (NoSuchAlgorithmException nsae) {
            nsae.printStackTrace();
            throw new RuntimeException("Cannot find DSA implementation");
        }
        kpg.initialize(keysize, sr);
        KeyPair kp = ((KeyPairGeneratorSpi)kpg).generateKeyPair();
        this.p = ((DSAPublicKey)kp.getPublic()).getParams().getP();
        this.q = ((DSAPublicKey)kp.getPublic()).getParams().getQ();
        this.g = ((DSAPublicKey)kp.getPublic()).getParams().getG();
        this.y = ((DSAPublicKey)kp.getPublic()).getY();
        this.x = ((DSAPrivateKey)kp.getPrivate()).getX();
    }

    public int getBitLength() {
        return this.p.bitLength();
    }

    public DSAPrivateKey getDSAPrivateKey() {
        return new PGPDSAPrivateKey();
    }

    public DSAPublicKey getDSAPublicKey() {
        return new PGPDSAPublicKey();
    }

    public int hashCode() {
        int hash = 0;
        if (this.p != null) {
            hash ^= this.p.hashCode();
        }
        if (this.q != null) {
            hash ^= this.q.hashCode();
        }
        if (this.g != null) {
            hash ^= this.g.hashCode();
        }
        if (this.x != null) {
            hash ^= this.x.hashCode();
        }
        if (this.y != null) {
            hash ^= this.y.hashCode();
        }
        return hash;
    }

    private void initSigObject() {
        try {
            this.sig = Signature.getInstance("DSA");
        }
        catch (NoSuchAlgorithmException nsae) {
            nsae.printStackTrace();
            throw new RuntimeException("DSA algorithm not found");
        }
    }

    public void initSign(int hashID, PGPAlgorithmFactory factory) {
        try {
            if (this.raw) {
                try {
                    this.md = factory.getHashAlgorithm(hashID);
                }
                catch (NoSuchAlgorithmException nsae) {
                    nsae.printStackTrace();
                    throw new RuntimeException("Hash #" + hashID + " not found.");
                }
            } else if (!factory.getHashAlgorithmString(hashID).equals("SHA-1") && !factory.getHashAlgorithmString(hashID).equals("SHA1")) {
                throw new IllegalArgumentException("Your provider only supports DSA signatures with a SHA-1 hash. DSA + " + factory.getHashAlgorithmString(hashID) + " will only work if you use a provider that supports " + "the RawDSA signature algorithm, like for example " + "Cryptix JCE");
            }
            if (this.x == null) {
                throw new IllegalStateException("This is not a secret key");
            }
            this.sig.initSign(new PGPDSAPrivateKey());
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new IllegalStateException("InvalidKeyException");
        }
    }

    public void initVerify(int hashID, PGPAlgorithmFactory factory) {
        try {
            if (this.raw) {
                try {
                    this.md = factory.getHashAlgorithm(hashID);
                }
                catch (NoSuchAlgorithmException nsae) {
                    nsae.printStackTrace();
                    throw new RuntimeException("Hash #" + hashID + " not found.");
                }
            } else if (!factory.getHashAlgorithmString(hashID).equals("SHA-1") && !factory.getHashAlgorithmString(hashID).equals("SHA1")) {
                throw new IllegalArgumentException("Your provider only supports DSA signatures with a SHA-1 hash. DSA + " + factory.getHashAlgorithmString(hashID) + " will only work if you use a provider that supports " + "the RawDSA signature algorithm, like for example " + "Cryptix JCE");
            }
            this.sig.initVerify(new PGPDSAPublicKey());
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new IllegalStateException("InvalidKeyException");
        }
    }

    public boolean signatureEquals(PGPSigner obj) {
        if (obj instanceof PGPDSA) {
            PGPDSA objx = (PGPDSA)obj;
            return objx.signatureEquals(this.r, this.s);
        }
        return false;
    }

    boolean signatureEquals(BigInteger r, BigInteger s) {
        return this.compare(this.r, r) && this.compare(this.s, s);
    }

    public String toString() {
        return "DSA";
    }

    public void update(byte data) {
        byte[] temp = new byte[]{data};
        this.update(temp);
    }

    public void update(byte[] data) {
        try {
            if (this.raw) {
                this.md.update(data);
            } else {
                this.sig.update(data);
            }
        }
        catch (SignatureException signatureException) {
            throw new IllegalStateException("SignatureException");
        }
        catch (NullPointerException nullPointerException) {
            throw new IllegalStateException("Signature not initialized");
        }
    }

    public void update(byte[] data, int offset, int len) {
        try {
            if (this.raw) {
                this.md.update(data, offset, len);
            } else {
                this.sig.update(data, offset, len);
            }
        }
        catch (SignatureException signatureException) {
            throw new IllegalStateException("SignatureException");
        }
        catch (NullPointerException nullPointerException) {
            throw new IllegalStateException("Signature not initialized");
        }
    }

    public boolean verifySignature() {
        PGPDSAElGamalSignatureParser parser = new PGPDSAElGamalSignatureParser(this.r, this.s);
        byte[] sigdata = parser.getData();
        try {
            if (this.raw) {
                this.sig.update(this.md.digest());
            }
            return this.sig.verify(sigdata);
        }
        catch (SignatureException signatureException) {
            throw new IllegalStateException("SignatureException");
        }
        catch (NullPointerException nullPointerException) {
            throw new IllegalStateException("Signature not initialized");
        }
    }

    private class PGPDSAParams
    implements DSAParams {
        PGPDSAParams() {
        }

        public BigInteger getG() {
            return PGPDSA.this.g;
        }

        public BigInteger getP() {
            return PGPDSA.this.p;
        }

        public BigInteger getQ() {
            return PGPDSA.this.q;
        }
    }

    private class PGPDSAKey
    implements DSAKey,
    Key {
        PGPDSAKey() {
        }

        public String getAlgorithm() {
            return "DSA";
        }

        public byte[] getEncoded() {
            return null;
        }

        public String getFormat() {
            return null;
        }

        public DSAParams getParams() {
            return new PGPDSAParams();
        }
    }

    private class PGPDSAPrivateKey
    extends PGPDSAKey
    implements DSAPrivateKey {
        PGPDSAPrivateKey() {
        }

        public BigInteger getX() {
            return PGPDSA.this.x;
        }
    }

    private class PGPDSAPublicKey
    extends PGPDSAKey
    implements DSAPublicKey {
        PGPDSAPublicKey() {
        }

        public BigInteger getY() {
            return PGPDSA.this.y;
        }
    }
}

