/*
 * Decompiled with CFR 0.152.
 */
package cryptix.openpgp;

import cryptix.openpgp.PGPV3SignatureParameterSpec;
import cryptix.pki.KeyID;
import cryptix.pki.KeyIDFactory;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Date;

public abstract class PGPAbstractV3SignatureParameterBuilder {
    private byte[] issuer;
    private byte[] time;
    private byte sigtype;

    protected PGPAbstractV3SignatureParameterBuilder(KeyID issuerkeyid, byte sigtype) {
        this.init(issuerkeyid, sigtype);
    }

    protected PGPAbstractV3SignatureParameterBuilder(Key issuerkey, byte sigtype) throws InvalidKeyException {
        KeyID issuerkeyid;
        try {
            issuerkeyid = KeyIDFactory.getInstance((String)"OpenPGP").generateKeyID(issuerkey);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new InvalidKeyException("Could not get KeyIDFactory for OpenPGP");
        }
        this.init(issuerkeyid, sigtype);
    }

    public AlgorithmParameterSpec build() {
        return new PGPV3SignatureParameterSpec(this.issuer, this.time, this.sigtype);
    }

    private void init(KeyID issuerkeyid, byte sigtype) {
        this.sigtype = sigtype;
        this.issuer = issuerkeyid.getBytes(8);
        this.time = new byte[4];
        this.updateCreationDate();
    }

    public void setCreationDate(Date creation) {
        long m = creation.getTime();
        if ((m /= 1000L) < 0L || m > 4294967295000L) {
            throw new IllegalArgumentException("Date not within acceptable range");
        }
        this.time[0] = (byte)(m >> 24 & 0xFFL);
        this.time[1] = (byte)(m >> 16 & 0xFFL);
        this.time[2] = (byte)(m >> 8 & 0xFFL);
        this.time[3] = (byte)(m & 0xFFL);
    }

    public void setIssuerKeyID(KeyID issuerkeyid) {
        this.issuer = issuerkeyid.getBytes(8);
    }

    public void setSignatureType(byte sigtype) {
        this.sigtype = sigtype;
    }

    public void updateCreationDate() {
        this.setCreationDate(new Date());
    }
}

