/*
 * Decompiled with CFR 0.152.
 */
package cryptix.message.stream;

import cryptix.pki.KeyBundle;
import java.security.PublicKey;

public class VerificationKeyReturnValue {
    public static final int NOERROR = 0;
    public static final int FAIL = 1;
    public static final int IGNORE = 2;
    private int error;
    private PublicKey pubkey;
    private KeyBundle bundle;

    public VerificationKeyReturnValue(int error) {
        if (error <= 0 || error > 2) {
            throw new IllegalArgumentException("Invalid error");
        }
        this.error = error;
    }

    public VerificationKeyReturnValue(KeyBundle bundle) {
        if (bundle == null) {
            throw new IllegalArgumentException("Null bundle");
        }
        this.error = 0;
        this.bundle = bundle;
    }

    public VerificationKeyReturnValue(PublicKey pubkey) {
        if (pubkey == null) {
            throw new IllegalArgumentException("Null key");
        }
        this.error = 0;
        this.pubkey = pubkey;
    }

    public KeyBundle getBundle() {
        return this.bundle;
    }

    public int getError() {
        return this.error;
    }

    public PublicKey getPublicKey() {
        return this.pubkey;
    }
}

