/*
 * Decompiled with CFR 0.152.
 */
package cryptix.message.stream;

import cryptix.message.stream.MessageOutputStream;
import cryptix.message.stream.MessageOutputStreamSpi;
import cryptix.message.stream.MessageStreamException;
import cryptix.message.stream.SignedMessageOutputStreamSpi;
import cryptix.message.stream.Support;
import cryptix.pki.KeyBundle;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.UnrecoverableKeyException;

public final class SignedMessageOutputStream
extends MessageOutputStream {
    protected SignedMessageOutputStream(MessageOutputStreamSpi spi, Provider provider, String format) {
        super(spi, provider, format);
    }

    public final void addSigner(KeyBundle signingkey, char[] passphrase) throws IllegalStateException, IOException, MessageStreamException, UnrecoverableKeyException {
        ((SignedMessageOutputStreamSpi)this.spi).engineAddSigner(signingkey, passphrase);
    }

    public final void addSigner(PrivateKey signingkey) throws IllegalStateException, IOException, MessageStreamException {
        ((SignedMessageOutputStreamSpi)this.spi).engineAddSigner(signingkey);
    }

    public static SignedMessageOutputStream getInstance(String format) throws NoSuchAlgorithmException {
        Object[] o = Support.getImplementation("SignedMessageOutputStream", format);
        return new SignedMessageOutputStream((SignedMessageOutputStreamSpi)o[0], (Provider)o[1], format);
    }

    public static SignedMessageOutputStream getInstance(String format, String provider) throws NoSuchAlgorithmException, NoSuchProviderException {
        Object[] o = Support.getImplementation("SignedMessageOutputStream", format, provider);
        return new SignedMessageOutputStream((SignedMessageOutputStreamSpi)o[0], (Provider)o[1], format);
    }

    public static SignedMessageOutputStream getInstance(String format, Provider provider) throws NoSuchAlgorithmException {
        Object[] o = Support.getImplementation("SignedMessageOutputStream", format, provider);
        return new SignedMessageOutputStream((SignedMessageOutputStreamSpi)o[0], (Provider)o[1], format);
    }
}

