/*
 * Decompiled with CFR 0.152.
 */
package cryptix.message;

import cryptix.message.LiteralMessageBuilderSpi;
import cryptix.message.Message;
import cryptix.message.MessageException;
import cryptix.message.Support;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.SecureRandom;

public class LiteralMessageBuilder {
    private final LiteralMessageBuilderSpi spi;
    private final Provider provider;
    private final String format;

    protected LiteralMessageBuilder(LiteralMessageBuilderSpi builderSpi, Provider provider, String format) {
        this.spi = builderSpi;
        this.provider = provider;
        this.format = format;
    }

    public final Message build() throws IllegalStateException, MessageException {
        return this.spi.engineBuild();
    }

    public final String getFormat() {
        return this.format;
    }

    public static LiteralMessageBuilder getInstance(String format) throws NoSuchAlgorithmException {
        Object[] o = Support.getImplementation("LiteralMessageBuilder", format);
        return new LiteralMessageBuilder((LiteralMessageBuilderSpi)o[0], (Provider)o[1], format);
    }

    public static LiteralMessageBuilder getInstance(String format, String provider) throws NoSuchAlgorithmException, NoSuchProviderException {
        Object[] o = Support.getImplementation("LiteralMessageBuilder", format, provider);
        return new LiteralMessageBuilder((LiteralMessageBuilderSpi)o[0], (Provider)o[1], format);
    }

    public static LiteralMessageBuilder getInstance(String format, Provider provider) throws NoSuchAlgorithmException {
        Object[] o = Support.getImplementation("LiteralMessageBuilder", format, provider);
        return new LiteralMessageBuilder((LiteralMessageBuilderSpi)o[0], (Provider)o[1], format);
    }

    public final Provider getProvider() {
        return this.provider;
    }

    public final void init(String contents) throws IllegalStateException, MessageException {
        this.spi.engineInit(contents, new SecureRandom());
    }

    public final void init(String contents, SecureRandom sr) throws IllegalStateException, MessageException {
        this.spi.engineInit(contents, sr);
    }

    public final void init(byte[] contents) throws IllegalStateException, MessageException {
        this.spi.engineInit(contents, new SecureRandom());
    }

    public final void init(byte[] contents, SecureRandom sr) throws IllegalStateException, MessageException {
        this.spi.engineInit(contents, sr);
    }

    public final void setAttribute(String name, Object attr) throws IllegalStateException, IllegalArgumentException, MessageException {
        this.spi.engineSetAttribute(name, attr);
    }
}

