/*
 * Decompiled with CFR 0.152.
 */
package cryptix.jce.provider.md;

import java.security.DigestException;
import java.security.MessageDigestSpi;

abstract class PaddingMD
extends MessageDigestSpi {
    private static final int DEFAULT_BLOCKSIZE = 64;
    private final int blockSize;
    private final int hashSize;
    private final byte[] buf;
    private int bufOff;
    private long byteCount;
    private final int mode;
    static final int MODE_MD = 0;
    static final int MODE_SHA = 1;
    static final int MODE_TIGER = 2;

    protected PaddingMD(int hashSize, int mode) {
        this(64, hashSize, mode);
    }

    protected PaddingMD(int blockSize, int hashSize, int mode) {
        if (blockSize != 64 && blockSize != 128) {
            throw new RuntimeException("blockSize must be 64 or 128!");
        }
        this.blockSize = blockSize;
        this.hashSize = hashSize;
        this.buf = new byte[blockSize];
        this.bufOff = 0;
        this.byteCount = 0L;
        this.mode = mode;
    }

    protected PaddingMD(PaddingMD src) {
        this.blockSize = src.blockSize;
        this.hashSize = src.hashSize;
        this.buf = (byte[])src.buf.clone();
        this.bufOff = src.bufOff;
        this.byteCount = src.byteCount;
        this.mode = src.mode;
    }

    public Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException("You have just found a bug!");
    }

    protected abstract void coreDigest(byte[] var1, int var2);

    protected abstract void coreReset();

    protected abstract void coreUpdate(byte[] var1, int var2);

    protected byte[] engineDigest() {
        byte[] tmp = new byte[this.hashSize];
        this.privateDigest(tmp, 0, this.hashSize);
        return tmp;
    }

    protected int engineDigest(byte[] buf, int offset, int len) throws DigestException {
        if (len < this.hashSize) {
            throw new DigestException();
        }
        return this.privateDigest(buf, offset, len);
    }

    protected int engineGetDigestLength() {
        return this.hashSize;
    }

    protected void engineReset() {
        this.bufOff = 0;
        this.byteCount = 0L;
        this.coreReset();
    }

    protected void engineUpdate(byte input) {
        ++this.byteCount;
        this.buf[this.bufOff++] = input;
        if (this.bufOff == this.blockSize) {
            this.coreUpdate(this.buf, 0);
            this.bufOff = 0;
        }
    }

    protected void engineUpdate(byte[] input, int offset, int length) {
        int todo;
        this.byteCount += (long)length;
        while (length >= (todo = this.blockSize - this.bufOff)) {
            System.arraycopy(input, offset, this.buf, this.bufOff, todo);
            this.coreUpdate(this.buf, 0);
            length -= todo;
            offset += todo;
            this.bufOff = 0;
        }
        System.arraycopy(input, offset, this.buf, this.bufOff, length);
        this.bufOff += length;
    }

    private int privateDigest(byte[] buf, int offset, int len) {
        int i;
        this.buf[this.bufOff++] = this.mode == 2 ? 1 : -128;
        int lenOfBitLen = this.blockSize == 128 ? 16 : 8;
        int C = this.blockSize - lenOfBitLen;
        if (this.bufOff > C) {
            while (this.bufOff < this.blockSize) {
                this.buf[this.bufOff++] = 0;
            }
            this.coreUpdate(this.buf, 0);
            this.bufOff = 0;
        }
        while (this.bufOff < C) {
            this.buf[this.bufOff++] = 0;
        }
        long bitCount = this.byteCount * 8L;
        if (this.blockSize == 128) {
            i = 0;
            while (i < 8) {
                this.buf[this.bufOff++] = 0;
                ++i;
            }
        }
        if (this.mode == 1) {
            i = 56;
            while (i >= 0) {
                this.buf[this.bufOff++] = (byte)(bitCount >>> i);
                i -= 8;
            }
        } else {
            i = 0;
            while (i < 64) {
                this.buf[this.bufOff++] = (byte)(bitCount >>> i);
                i += 8;
            }
        }
        this.coreUpdate(this.buf, 0);
        this.coreDigest(buf, offset);
        this.engineReset();
        return this.hashSize;
    }
}

