/*
 * Decompiled with CFR 0.152.
 */
package nu.fw.jeti.plugins.jingle.provider;

import nu.fw.jeti.jabber.JID;
import nu.fw.jeti.jabber.elements.Extension;
import nu.fw.jeti.jabber.handlers.ExtensionHandler;
import nu.fw.jeti.plugins.jingle.jingle.JingleManager;
import nu.fw.jeti.plugins.jingle.packet.Jingle;
import nu.fw.jeti.plugins.jingle.packet.JingleContentDescription;
import nu.fw.jeti.plugins.jingle.packet.JingleContentInfo;
import nu.fw.jeti.plugins.jingle.packet.JingleTransport;
import nu.fw.jeti.util.Log;
import org.xml.sax.Attributes;

public class JingleProvider
extends ExtensionHandler {
    private JingleManager manager;
    private Jingle jingle;

    public JingleProvider(JingleManager jingleManager) {
        this.manager = jingleManager;
    }

    public void startHandling(Attributes attributes) {
        this.jingle = new Jingle(this.manager);
        this.jingle.setSid(attributes.getValue("sid"));
        this.jingle.setAction(Jingle.Action.getAction(attributes.getValue("action")));
        try {
            this.jingle.setInitiator(JID.checkedJIDFromString((String)attributes.getValue("initiator")));
            this.jingle.setResponder(JID.checkedJIDFromString((String)attributes.getValue("responder")));
        }
        catch (InstantiationException instantiationException) {
            Log.notParsedXML((String)instantiationException.getMessage());
        }
    }

    public void addExtension(Extension extension) {
        if (extension instanceof JingleContentDescription) {
            this.jingle.addDescription((JingleContentDescription)extension);
        } else if (extension instanceof JingleTransport) {
            this.jingle.addTransport((JingleTransport)extension);
        } else if (extension instanceof JingleContentInfo) {
            this.jingle.setContentInfo((JingleContentInfo)extension);
        } else {
            Log.notParsedXML((String)"Extension not supported by Jingle");
        }
    }

    public Extension build() {
        return this.jingle;
    }
}

