/*
 * Decompiled with CFR 0.152.
 */
package nu.fw.jeti.plugins.jingle.packet;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import nu.fw.jeti.jabber.elements.Extension;
import nu.fw.jeti.plugins.jingle.jingle.nat.ICECandidate;
import nu.fw.jeti.plugins.jingle.jingle.nat.TransportCandidate;

public class JingleTransport
extends Extension {
    public static final String NODENAME = "transport";
    protected String namespace;
    protected final List candidates = new ArrayList();

    public JingleTransport() {
    }

    public JingleTransport(JingleTransportCandidate jingleTransportCandidate) {
        this.addCandidate(jingleTransportCandidate);
    }

    public JingleTransport(JingleTransport jingleTransport) {
        if (jingleTransport != null) {
            this.namespace = jingleTransport.namespace;
            if (jingleTransport.candidates.size() > 0) {
                this.candidates.addAll(jingleTransport.candidates);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCandidate(JingleTransportCandidate jingleTransportCandidate) {
        if (jingleTransportCandidate != null) {
            List list = this.candidates;
            synchronized (list) {
                this.candidates.add(jingleTransportCandidate);
            }
        }
    }

    public Iterator getCandidates() {
        return Collections.unmodifiableList(this.getCandidatesList()).iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList getCandidatesList() {
        ArrayList arrayList = null;
        List list = this.candidates;
        synchronized (list) {
            arrayList = new ArrayList(this.candidates);
        }
        return arrayList;
    }

    public int getCandidatesCount() {
        return this.getCandidatesList().size();
    }

    public String getElementName() {
        return NODENAME;
    }

    protected void setNamespace(String string) {
        this.namespace = string;
    }

    public String getNamespace() {
        return this.namespace;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void appendToXML(StringBuffer stringBuffer) {
        stringBuffer.append("<").append(this.getElementName()).append(" xmlns=\"");
        stringBuffer.append(this.getNamespace()).append("\" ");
        List list = this.candidates;
        synchronized (list) {
            if (this.getCandidatesCount() > 0) {
                stringBuffer.append(">");
                Iterator iterator = this.getCandidates();
                while (iterator.hasNext()) {
                    JingleTransportCandidate jingleTransportCandidate = (JingleTransportCandidate)iterator.next();
                    stringBuffer.append(jingleTransportCandidate.toXML());
                }
                stringBuffer.append("</").append(this.getElementName()).append(">");
            } else {
                stringBuffer.append("/>");
            }
        }
    }

    public static class RawUdp
    extends JingleTransport {
        public static final String NAMESPACE = "http://jabber.org/protocol/jingle/transport/raw-udp";

        public RawUdp() {
            this.setNamespace(NAMESPACE);
        }

        public void addCandidate(JingleTransportCandidate jingleTransportCandidate) {
            this.candidates.clear();
            super.addCandidate(jingleTransportCandidate);
        }

        public ArrayList getCandidatesList() {
            ArrayList arrayList = new ArrayList();
            ArrayList arrayList2 = super.getCandidatesList();
            if (arrayList2.size() > 0) {
                arrayList.add(arrayList2.get(0));
            }
            return arrayList;
        }

        public static class Candidate
        extends JingleTransportCandidate {
            public Candidate() {
            }

            public Candidate(TransportCandidate transportCandidate) {
                super(transportCandidate);
            }

            protected String getChildElements() {
                StringBuffer stringBuffer = new StringBuffer();
                if (this.transportCandidate != null && this.transportCandidate instanceof TransportCandidate.Fixed) {
                    TransportCandidate.Fixed fixed = (TransportCandidate.Fixed)this.transportCandidate;
                    stringBuffer.append(" generation=\"").append(fixed.getGeneration()).append("\"");
                    stringBuffer.append(" ip=\"").append(fixed.getIp()).append("\"");
                    stringBuffer.append(" port=\"").append(fixed.getPort()).append("\"");
                    String string = fixed.getName();
                    if (string != null) {
                        stringBuffer.append(" name=\"").append(string).append("\"");
                    }
                }
                return stringBuffer.toString();
            }
        }
    }

    public static class Ice
    extends JingleTransport {
        public static final String NAMESPACE = "http://jabber.org/protocol/jingle/transport/ice";

        public Ice() {
            this.setNamespace(NAMESPACE);
        }

        public void addCandidate(JingleTransportCandidate jingleTransportCandidate) {
            super.addCandidate(jingleTransportCandidate);
        }

        public ArrayList getCandidatesList() {
            ArrayList arrayList = new ArrayList();
            ArrayList arrayList2 = super.getCandidatesList();
            for (int i = 0; i < arrayList2.size(); ++i) {
                arrayList.add(arrayList2.get(i));
            }
            return arrayList;
        }

        public static class Candidate
        extends JingleTransportCandidate {
            public Candidate() {
            }

            public Candidate(TransportCandidate transportCandidate) {
                super(transportCandidate);
            }

            protected String getChildElements() {
                StringBuffer stringBuffer = new StringBuffer();
                if (this.transportCandidate != null) {
                    ICECandidate iCECandidate = (ICECandidate)this.transportCandidate;
                    stringBuffer.append(" generation=\"").append(iCECandidate.getGeneration()).append("\"");
                    stringBuffer.append(" ip=\"").append(iCECandidate.getIp()).append("\"");
                    stringBuffer.append(" port=\"").append(iCECandidate.getPort()).append("\"");
                    stringBuffer.append(" network=\"").append(iCECandidate.getNetwork()).append("\"");
                    stringBuffer.append(" username=\"").append(iCECandidate.getUsername()).append("\"");
                    stringBuffer.append(" password=\"").append(iCECandidate.getPassword()).append("\"");
                    stringBuffer.append(" preference=\"").append(iCECandidate.getPreference()).append("\"");
                    stringBuffer.append(" type=\"").append((Object)iCECandidate.getType()).append("\"");
                    if (this.transportCandidate.getName() != null) {
                        stringBuffer.append(" name=\"").append(iCECandidate.getName()).append("\"");
                    }
                }
                return stringBuffer.toString();
            }
        }
    }

    public static abstract class JingleTransportCandidate {
        public static final String NODENAME = "candidate";
        protected TransportCandidate transportCandidate;

        public JingleTransportCandidate() {
        }

        public JingleTransportCandidate(TransportCandidate transportCandidate) {
            this.setMediaTransport(transportCandidate);
        }

        public static String getElementName() {
            return NODENAME;
        }

        public TransportCandidate getMediaTransport() {
            return this.transportCandidate;
        }

        public void setMediaTransport(TransportCandidate transportCandidate) {
            if (transportCandidate != null) {
                this.transportCandidate = transportCandidate;
            }
        }

        protected String getChildElements() {
            return null;
        }

        public String toXML() {
            StringBuffer stringBuffer = new StringBuffer();
            String string = this.getChildElements();
            if (this.transportCandidate != null && string != null) {
                stringBuffer.append("<").append(JingleTransportCandidate.getElementName()).append(" ");
                stringBuffer.append(string);
                stringBuffer.append("/>");
            }
            return stringBuffer.toString();
        }
    }
}

