/*
 * Decompiled with CFR 0.152.
 */
package nu.fw.jeti.plugins.jingle.packet;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.sourceforge.retroweaver.runtime.java.lang.Enum;
import nu.fw.jeti.jabber.Backend;
import nu.fw.jeti.jabber.JID;
import nu.fw.jeti.jabber.elements.Extension;
import nu.fw.jeti.jabber.elements.IQExtension;
import nu.fw.jeti.jabber.elements.InfoQuery;
import nu.fw.jeti.jabber.elements.XMPPError;
import nu.fw.jeti.plugins.jingle.XMPPException;
import nu.fw.jeti.plugins.jingle.jingle.JingleManager;
import nu.fw.jeti.plugins.jingle.jingle.JingleSession;
import nu.fw.jeti.plugins.jingle.packet.JingleContentDescription;
import nu.fw.jeti.plugins.jingle.packet.JingleContentInfo;
import nu.fw.jeti.plugins.jingle.packet.JingleTransport;

public class Jingle
extends Extension
implements IQExtension {
    public static final String NAMESPACE = "http://jabber.org/protocol/jingle";
    public static final String NODENAME = "jingle";
    private String sid;
    private Action action;
    private JID initiator;
    private JID responder;
    private final List descriptions = new ArrayList();
    private final List transports = new ArrayList();
    private JingleContentInfo contentInfo;
    private JingleManager manager;
    private JID from;
    private JID to;
    private String packetID;
    private String type;
    private XMPPError error;
    private static long id = 4L;

    public XMPPError getError() {
        return this.error;
    }

    public String getType() {
        if (this.type == null) {
            this.type = "set";
            System.err.println("type is null");
        }
        return this.type;
    }

    public Jingle(String string, JID jID, XMPPError xMPPError) {
        this.error = xMPPError;
        this.to = jID;
        this.packetID = string;
    }

    public void setType(String string) {
        this.type = string;
    }

    public String getPacketID() {
        return this.packetID;
    }

    public JID getFrom() {
        return this.from;
    }

    public JID getTo() {
        return this.to;
    }

    public Jingle(InfoQuery infoQuery) {
        this.from = infoQuery.getFrom();
        this.to = infoQuery.getTo();
        this.type = infoQuery.getType();
        this.packetID = infoQuery.getID();
        this.error = infoQuery.getXMPPError();
    }

    public Jingle(List list, List list2, JingleContentInfo jingleContentInfo, String string) {
        if (list != null) {
            this.descriptions.addAll(list);
        }
        if (list2 != null) {
            this.transports.addAll(list2);
        }
        this.setContentInfo(jingleContentInfo);
        this.setSid(string);
        this.initiator = null;
        this.responder = null;
        this.action = null;
        this.packetID = "jj" + Math.random() + "-" + id++;
    }

    public Jingle(JingleContentDescription jingleContentDescription) {
        this.addDescription(jingleContentDescription);
        this.initiator = null;
        this.responder = null;
        this.action = Action.DESCRIPTIONINFO;
        this.packetID = "jj" + Math.random() + "-" + id++;
    }

    public Jingle(JingleTransport jingleTransport) {
        this.addTransport(jingleTransport);
        this.initiator = null;
        this.responder = null;
        this.action = Action.TRANSPORTINFO;
        this.packetID = "jj" + Math.random() + "-" + id++;
    }

    public Jingle(JingleContentInfo jingleContentInfo) {
        this.setContentInfo(jingleContentInfo);
        this.initiator = null;
        this.responder = null;
        this.action = Action.DESCRIPTIONINFO;
        this.packetID = "jj" + Math.random() + "-" + id++;
    }

    public Jingle(Action action) {
        this(null, null, null, null);
        this.action = action;
        this.packetID = "jj" + Math.random() + "-" + id++;
    }

    public Jingle(String string) {
        this(null, null, null, string);
    }

    public Jingle(JingleManager jingleManager) {
        this.manager = jingleManager;
        this.packetID = "jj" + Math.random() + "-" + id++;
    }

    public final void setSid(String string) {
        this.sid = string;
    }

    public String getSid() {
        return this.sid;
    }

    public static String getElementName() {
        return NODENAME;
    }

    public static String getNamespace() {
        return NAMESPACE;
    }

    public JingleContentInfo getContentInfo() {
        return this.contentInfo;
    }

    public void setContentInfo(JingleContentInfo jingleContentInfo) {
        this.contentInfo = jingleContentInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator getDescriptions() {
        List list = this.descriptions;
        synchronized (list) {
            return Collections.unmodifiableList(new ArrayList(this.descriptions)).iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList getDescriptionsList() {
        List list = this.descriptions;
        synchronized (list) {
            return new ArrayList(this.descriptions);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDescription(JingleContentDescription jingleContentDescription) {
        if (jingleContentDescription != null) {
            List list = this.descriptions;
            synchronized (list) {
                this.descriptions.add(jingleContentDescription);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDescriptions(List list) {
        if (list != null) {
            List list2 = this.descriptions;
            synchronized (list2) {
                this.descriptions.addAll(list);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator getTransports() {
        List list = this.transports;
        synchronized (list) {
            return Collections.unmodifiableList(new ArrayList(this.transports)).iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList getTransportsList() {
        List list = this.transports;
        synchronized (list) {
            return new ArrayList(this.transports);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTransport(JingleTransport jingleTransport) {
        if (jingleTransport != null) {
            List list = this.transports;
            synchronized (list) {
                this.transports.add(jingleTransport);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTransports(List list) {
        if (list != null) {
            List list2 = this.transports;
            synchronized (list2) {
                this.transports.addAll(list);
            }
        }
    }

    public Action getAction() {
        return this.action;
    }

    public void setAction(Action action) {
        this.action = action;
    }

    public JID getInitiator() {
        return this.initiator;
    }

    public void setInitiator(JID jID) {
        this.initiator = jID;
    }

    public JID getResponder() {
        return this.responder;
    }

    public void setResponder(JID jID) {
        this.responder = jID;
    }

    public static int getSessionHash(String string, JID jID) {
        int n = 1;
        n = 31 * n + (jID == null ? 0 : jID.hashCode());
        n = 31 * n + (string == null ? 0 : string.hashCode());
        return n;
    }

    public void execute(InfoQuery infoQuery, Backend backend) {
        this.from = infoQuery.getFrom();
        this.to = infoQuery.getTo();
        this.type = infoQuery.getType();
        this.packetID = infoQuery.getID();
        this.error = infoQuery.getXMPPError();
        System.out.println((Object)this);
        if (this.getAction().equals((Object)Action.SESSIONINITIATE)) {
            this.manager.triggerSessionRequested(this);
        } else {
            JingleSession jingleSession = this.manager.getSession(this.sid);
            try {
                if (jingleSession != null) {
                    jingleSession.respond(this);
                }
            }
            catch (XMPPException xMPPException) {
                xMPPException.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void appendToXML(StringBuffer stringBuffer) {
        Extension extension;
        int n;
        stringBuffer.append("<").append(Jingle.getElementName());
        stringBuffer.append(" xmlns=\"").append(Jingle.getNamespace()).append("\"");
        if (this.getInitiator() != null) {
            stringBuffer.append(" initiator=\"").append(this.getInitiator()).append("\"");
        }
        if (this.getResponder() != null) {
            stringBuffer.append(" responder=\"").append(this.getResponder()).append("\"");
        }
        if (this.getAction() != null) {
            stringBuffer.append(" action=\"").append((Object)this.getAction()).append("\"");
        }
        if (this.getSid() != null) {
            stringBuffer.append(" sid=\"").append(this.getSid()).append("\"");
        }
        stringBuffer.append(">");
        stringBuffer.append("<content name='Audio-Content'>");
        List list = this.descriptions;
        synchronized (list) {
            for (n = 0; n < this.descriptions.size(); ++n) {
                extension = (JingleContentDescription)((Object)this.descriptions.get(n));
                extension.appendToXML(stringBuffer);
            }
        }
        list = this.transports;
        synchronized (list) {
            for (n = 0; n < this.transports.size(); ++n) {
                extension = (JingleTransport)((Object)this.transports.get(n));
                extension.appendToXML(stringBuffer);
            }
        }
        stringBuffer.append("</content>");
        if (this.contentInfo != null) {
            this.contentInfo.appendToXML(stringBuffer);
        }
        stringBuffer.append("</").append(Jingle.getElementName()).append(">");
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Action
    extends Enum<Action> {
        public static final /* enum */ Action CONTENTACCEPT = new Action("CONTENTACCEPT", 0);
        public static final /* enum */ Action CONTENTADD = new Action("CONTENTADD", 1);
        public static final /* enum */ Action CONTENTDECLINE = new Action("CONTENTDECLINE", 2);
        public static final /* enum */ Action CONTENTMODIFY = new Action("CONTENTMODIFY", 3);
        public static final /* enum */ Action CONTENTREMOVE = new Action("CONTENTREMOVE", 4);
        public static final /* enum */ Action DESCRIPTIONADD = new Action("DESCRIPTIONADD", 5);
        public static final /* enum */ Action DESCRIPTIONDECLINE = new Action("DESCRIPTIONDECLINE", 6);
        public static final /* enum */ Action DESCRIPTIONINFO = new Action("DESCRIPTIONINFO", 7);
        public static final /* enum */ Action DESCRIPTIONMODIFY = new Action("DESCRIPTIONMODIFY", 8);
        public static final /* enum */ Action SESSIONACCEPT = new Action("SESSIONACCEPT", 9);
        public static final /* enum */ Action SESSIONINFO = new Action("SESSIONINFO", 10);
        public static final /* enum */ Action SESSIONINITIATE = new Action("SESSIONINITIATE", 11);
        public static final /* enum */ Action SESSIONREDIRECT = new Action("SESSIONREDIRECT", 12);
        public static final /* enum */ Action SESSIONTERMINATE = new Action("SESSIONTERMINATE", 13);
        public static final /* enum */ Action TRANSPORTACCEPT = new Action("TRANSPORTACCEPT", 14);
        public static final /* enum */ Action TRANSPORTDECLINE = new Action("TRANSPORTDECLINE", 15);
        public static final /* enum */ Action TRANSPORTINFO = new Action("TRANSPORTINFO", 16);
        public static final /* enum */ Action TRANSPORTMODIFY = new Action("TRANSPORTMODIFY", 17);
        private static String[] names;
        private static final /* synthetic */ Action[] $VALUES;
        private static final /* synthetic */ long serialVersionUID = 0L;
        private static final /* synthetic */ Class class$nu$fw$jeti$plugins$jingle$packet$Jingle$Action;

        public static Action[] values() {
            return (Action[])$VALUES.clone();
        }

        public static Action valueOf(String string) {
            Class<?> clazz = class$nu$fw$jeti$plugins$jingle$packet$Jingle$Action;
            if (clazz == null) {
                clazz = class$nu$fw$jeti$plugins$jingle$packet$Jingle$Action = new Action[0].getClass().getComponentType();
            }
            return (Action)Enum.valueOf((Class)clazz, (String)string);
        }

        private Action(String string, int n) {
            super(string, n);
        }

        public String toString() {
            return names[this.ordinal()];
        }

        public static Action getAction(String string) {
            for (int i = 0; i < names.length; ++i) {
                if (!names[i].equals(string)) continue;
                return Action.values()[i];
            }
            return null;
        }

        static {
            $VALUES = new Action[]{CONTENTACCEPT, CONTENTADD, CONTENTDECLINE, CONTENTMODIFY, CONTENTREMOVE, DESCRIPTIONADD, DESCRIPTIONDECLINE, DESCRIPTIONINFO, DESCRIPTIONMODIFY, SESSIONACCEPT, SESSIONINFO, SESSIONINITIATE, SESSIONREDIRECT, SESSIONTERMINATE, TRANSPORTACCEPT, TRANSPORTDECLINE, TRANSPORTINFO, TRANSPORTMODIFY};
            names = new String[]{"content-accept", "content-add", "content-decline", "content-modify", "content-remove", "description-accept", "description-decline", "description-info", "description-modify", "session-accept", "session-info", "session-initiate", "session-redirect", "session-terminate", "transport-accept", "transport-decline", "transport-info", "transport-modify"};
            Action[] actionArray = Action.values();
            Class<?> clazz = class$nu$fw$jeti$plugins$jingle$packet$Jingle$Action;
            if (clazz == null) {
                clazz = class$nu$fw$jeti$plugins$jingle$packet$Jingle$Action = new Action[0].getClass().getComponentType();
            }
            Enum.setEnumValues((Object[])actionArray, (Class)clazz);
        }
    }
}

