/*
 * Decompiled with CFR 0.152.
 */
package nu.fw.jeti.plugins.jingle.jingle.nat;

import java.util.Iterator;
import java.util.Observer;
import net.sourceforge.retroweaver.runtime.java.lang.Enum;
import nu.fw.jeti.events.DiscoveryListener;
import nu.fw.jeti.jabber.Backend;
import nu.fw.jeti.jabber.JID;
import nu.fw.jeti.jabber.elements.DiscoveryInfo;
import nu.fw.jeti.jabber.elements.DiscoveryItem;
import nu.fw.jeti.jabber.elements.Extension;
import nu.fw.jeti.jabber.elements.IQExtension;
import nu.fw.jeti.jabber.elements.InfoQuery;
import nu.fw.jeti.jabber.elements.Packet;
import nu.fw.jeti.jabber.handlers.ExtensionHandler;
import nu.fw.jeti.plugins.jingle.jingle.nat.TransportCandidate;
import org.xml.sax.Attributes;

public class RTPBridge
extends Extension
implements IQExtension {
    private String sid;
    private String pass;
    private String ip;
    private String name;
    private int portA = -1;
    private int portB = -1;
    private String hostA;
    private String hostB;
    private BridgeAction bridgeAction = BridgeAction.create;
    public static final String NAME = "rtpbridge";
    public static final String ELEMENT_NAME = "rtpbridge";
    public static final String NAMESPACE = "http://www.jivesoftware.com/protocol/rtpbridge";

    public RTPBridge(String string) {
        this.sid = string;
    }

    public RTPBridge(BridgeAction bridgeAction) {
        this.bridgeAction = bridgeAction;
    }

    public RTPBridge(String string, BridgeAction bridgeAction) {
        this.sid = string;
        this.bridgeAction = bridgeAction;
    }

    public RTPBridge() {
    }

    public String getAttributes() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.getSid() != null) {
            stringBuffer.append(" sid='").append(this.getSid()).append("'");
        }
        if (this.getPass() != null) {
            stringBuffer.append(" pass='").append(this.getPass()).append("'");
        }
        if (this.getPortA() != -1) {
            stringBuffer.append(" porta='").append(this.getPortA()).append("'");
        }
        if (this.getPortB() != -1) {
            stringBuffer.append(" portb='").append(this.getPortB()).append("'");
        }
        if (this.getHostA() != null) {
            stringBuffer.append(" hosta='").append(this.getHostA()).append("'");
        }
        if (this.getHostB() != null) {
            stringBuffer.append(" hostb='").append(this.getHostB()).append("'");
        }
        return stringBuffer.toString();
    }

    public String getSid() {
        return this.sid;
    }

    public void setSid(String string) {
        this.sid = string;
    }

    public String getHostA() {
        return this.hostA;
    }

    public void setHostA(String string) {
        this.hostA = string;
    }

    public String getHostB() {
        return this.hostB;
    }

    public void setHostB(String string) {
        this.hostB = string;
    }

    public int getPortA() {
        return this.portA;
    }

    public void setPortA(int n) {
        this.portA = n;
    }

    public int getPortB() {
        return this.portB;
    }

    public void setPortB(int n) {
        this.portB = n;
    }

    public String getIp() {
        return this.ip;
    }

    public void setIp(String string) {
        this.ip = string;
    }

    public String getPass() {
        return this.pass;
    }

    public void setPass(String string) {
        this.pass = string;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void execute(InfoQuery infoQuery, Backend backend) {
    }

    public void appendToXML(StringBuffer stringBuffer) {
        stringBuffer.append("<rtpbridge xmlns='http://www.jivesoftware.com/protocol/rtpbridge' sid='").append(this.sid).append("'>");
        if (this.bridgeAction.equals((Object)BridgeAction.create)) {
            stringBuffer.append("<candidate/>");
        } else if (this.bridgeAction.equals((Object)BridgeAction.change)) {
            stringBuffer.append("<relay ").append(this.getAttributes()).append(" />");
        } else {
            stringBuffer.append("<publicip ").append(this.getAttributes()).append(" />");
        }
        stringBuffer.append("</rtpbridge>");
    }

    public static InfoQuery getRTPBridge(Backend backend, String string) {
        if (!backend.isLoggedIn()) {
            return null;
        }
        RTPBridge rTPBridge = new RTPBridge(string);
        JID jID = new JID("rtpbridge." + backend.getMyJID().getDomain());
        return new InfoQuery(jID, "set", (IQExtension)rTPBridge);
    }

    public static void serviceAvailable(Backend backend, final Observer observer) {
        if (!backend.isLoggedIn()) {
            return;
        }
        System.out.println("Service listing");
        backend.getItems(new JID(backend.getMyJID().getDomain()), new DiscoveryListener(){

            public void discoveryInfoResult(JID jID, DiscoveryInfo discoveryInfo) {
            }

            public void discoveryItemResult(JID jID, DiscoveryItem discoveryItem) {
                boolean bl = false;
                if (discoveryItem.hasItems()) {
                    Iterator iterator = discoveryItem.getItems();
                    while (iterator.hasNext()) {
                        DiscoveryItem discoveryItem2 = (DiscoveryItem)iterator.next();
                        if (!discoveryItem2.getJID().getDomain().startsWith("rtpbridge.")) continue;
                        bl = true;
                        break;
                    }
                }
                if (!bl) {
                    System.err.println("No RTP Bridge service available");
                } else if (observer != null) {
                    observer.update(null, null);
                }
            }
        });
    }

    public static void relaySession(Backend backend, String string, String string2, TransportCandidate transportCandidate, TransportCandidate transportCandidate2) {
        if (!backend.isLoggedIn()) {
            return;
        }
        RTPBridge rTPBridge = new RTPBridge(string, BridgeAction.change);
        JID jID = new JID("rtpbridge." + backend.getMyJID().getDomain());
        rTPBridge.setPass(string2);
        rTPBridge.setPortA(transportCandidate2.getPort());
        rTPBridge.setPortB(transportCandidate.getPort());
        rTPBridge.setHostA(transportCandidate2.getIp());
        rTPBridge.setHostB(transportCandidate.getIp());
        backend.send((Packet)new InfoQuery(jID, "set", (IQExtension)rTPBridge));
    }

    public static InfoQuery getPublicIP(Backend backend) {
        if (!backend.isLoggedIn()) {
            return null;
        }
        RTPBridge rTPBridge = new RTPBridge(BridgeAction.publicip);
        JID jID = new JID("rtpbridge." + backend.getMyJID().getDomain());
        return new InfoQuery(jID, "set", (IQExtension)rTPBridge);
    }

    public static class Provider
    extends ExtensionHandler {
        RTPBridge iq;

        public void startHandling(Attributes attributes) {
            this.iq = new RTPBridge();
            this.iq.setSid(attributes.getValue("sid"));
        }

        public void startElement(String string, Attributes attributes) {
            if (string.equals("candidate")) {
                this.iq.setIp(attributes.getValue("ip"));
                this.iq.setPass(attributes.getValue("pass"));
                this.iq.setName(attributes.getValue("name"));
                this.iq.setPortA(Integer.parseInt(attributes.getValue("porta")));
                this.iq.setPortB(Integer.parseInt(attributes.getValue("portb")));
            } else if (string.equals("publicip")) {
                this.iq.setIp(attributes.getValue("ip"));
            }
        }

        public Extension build() {
            return this.iq;
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class BridgeAction
    extends Enum<BridgeAction> {
        public static final /* enum */ BridgeAction create = new BridgeAction("create", 0);
        public static final /* enum */ BridgeAction change = new BridgeAction("change", 1);
        public static final /* enum */ BridgeAction publicip = new BridgeAction("publicip", 2);
        private static final /* synthetic */ BridgeAction[] $VALUES;
        private static final /* synthetic */ long serialVersionUID = 0L;
        private static final /* synthetic */ Class class$nu$fw$jeti$plugins$jingle$jingle$nat$RTPBridge$BridgeAction;

        public static BridgeAction[] values() {
            return (BridgeAction[])$VALUES.clone();
        }

        public static BridgeAction valueOf(String string) {
            Class<?> clazz = class$nu$fw$jeti$plugins$jingle$jingle$nat$RTPBridge$BridgeAction;
            if (clazz == null) {
                clazz = class$nu$fw$jeti$plugins$jingle$jingle$nat$RTPBridge$BridgeAction = new BridgeAction[0].getClass().getComponentType();
            }
            return (BridgeAction)Enum.valueOf((Class)clazz, (String)string);
        }

        private BridgeAction(String string, int n) {
            super(string, n);
        }

        static {
            $VALUES = new BridgeAction[]{create, change, publicip};
            BridgeAction[] bridgeActionArray = BridgeAction.values();
            Class<?> clazz = class$nu$fw$jeti$plugins$jingle$jingle$nat$RTPBridge$BridgeAction;
            if (clazz == null) {
                clazz = class$nu$fw$jeti$plugins$jingle$jingle$nat$RTPBridge$BridgeAction = new BridgeAction[0].getClass().getComponentType();
            }
            Enum.setEnumValues((Object[])bridgeActionArray, (Class)clazz);
        }
    }
}

