/*
 * Decompiled with CFR 0.152.
 */
package nu.fw.jeti.plugins.jingle.jingle.mediaimpl.jmf;

import javax.media.ControllerErrorEvent;
import javax.media.ControllerEvent;
import javax.media.ControllerListener;
import javax.media.Manager;
import javax.media.Player;
import javax.media.RealizeCompleteEvent;
import javax.media.protocol.DataSource;
import javax.media.rtp.Participant;
import javax.media.rtp.RTPControl;
import javax.media.rtp.ReceiveStream;
import javax.media.rtp.ReceiveStreamListener;
import javax.media.rtp.SessionListener;
import javax.media.rtp.event.ByeEvent;
import javax.media.rtp.event.NewParticipantEvent;
import javax.media.rtp.event.NewReceiveStreamEvent;
import javax.media.rtp.event.ReceiveStreamEvent;
import javax.media.rtp.event.RemotePayloadChangeEvent;
import javax.media.rtp.event.SessionEvent;
import javax.media.rtp.event.StreamMappedEvent;
import nu.fw.jeti.plugins.jingle.jingle.media.JingleMediaSession;

public class AudioReceiver
implements ReceiveStreamListener,
SessionListener,
ControllerListener {
    boolean dataReceived = false;
    Object dataSync;
    JingleMediaSession jingleMediaSession;

    public AudioReceiver(Object object, JingleMediaSession jingleMediaSession) {
        this.dataSync = object;
        this.jingleMediaSession = jingleMediaSession;
    }

    public synchronized void update(SessionEvent sessionEvent) {
        if (sessionEvent instanceof NewParticipantEvent) {
            Participant participant = ((NewParticipantEvent)sessionEvent).getParticipant();
            System.err.println("  - A new participant had just joined: " + participant.getCNAME());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void update(ReceiveStreamEvent receiveStreamEvent) {
        block18: {
            Participant participant = receiveStreamEvent.getParticipant();
            ReceiveStream receiveStream = receiveStreamEvent.getReceiveStream();
            if (receiveStreamEvent instanceof RemotePayloadChangeEvent) {
                System.err.println("  - Received an RTP PayloadChangeEvent.");
                System.err.println("Sorry, cannot handle payload change.");
            } else {
                if (receiveStreamEvent instanceof NewReceiveStreamEvent) {
                    try {
                        receiveStream = receiveStreamEvent.getReceiveStream();
                        DataSource dataSource = receiveStream.getDataSource();
                        RTPControl rTPControl = (RTPControl)dataSource.getControl("javax.jmf.rtp.RTPControl");
                        if (rTPControl != null) {
                            System.err.println("  - Recevied new RTP stream: " + rTPControl.getFormat());
                        } else {
                            System.err.println("  - Recevied new RTP stream");
                        }
                        if (participant == null) {
                            System.err.println("      The sender of this stream had yet to be identified.");
                        } else {
                            System.err.println("      The stream comes from: " + participant.getCNAME());
                        }
                        Player player = Manager.createPlayer((DataSource)dataSource);
                        if (player == null) {
                            return;
                        }
                        player.addControllerListener((ControllerListener)this);
                        player.realize();
                        this.jingleMediaSession.mediaReceived(participant != null ? participant.getCNAME() : "");
                        Object object = this.dataSync;
                        synchronized (object) {
                            this.dataReceived = true;
                            this.dataSync.notifyAll();
                            break block18;
                        }
                    }
                    catch (Exception exception) {
                        System.err.println("NewReceiveStreamEvent exception " + exception.getMessage());
                        return;
                    }
                }
                if (receiveStreamEvent instanceof StreamMappedEvent) {
                    if (receiveStream != null && receiveStream.getDataSource() != null) {
                        DataSource dataSource = receiveStream.getDataSource();
                        RTPControl rTPControl = (RTPControl)dataSource.getControl("javax.jmf.rtp.RTPControl");
                        System.err.println("  - The previously unidentified stream ");
                        if (rTPControl != null) {
                            System.err.println("      " + rTPControl.getFormat());
                        }
                        System.err.println("      had now been identified as sent by: " + participant.getCNAME());
                    }
                } else if (receiveStreamEvent instanceof ByeEvent) {
                    System.err.println("  - Got \"bye\" from: " + participant.getCNAME());
                }
            }
        }
    }

    public synchronized void controllerUpdate(ControllerEvent controllerEvent) {
        Player player = (Player)controllerEvent.getSourceController();
        if (player == null) {
            return;
        }
        if (controllerEvent instanceof RealizeCompleteEvent) {
            player.start();
        }
        if (controllerEvent instanceof ControllerErrorEvent) {
            player.removeControllerListener((ControllerListener)this);
            System.err.println("Receiver internal error: " + controllerEvent);
        }
    }
}

