/*
 * Decompiled with CFR 0.152.
 */
package nu.fw.jeti.plugins.jingle.jingle.mediaimpl;

import com.sun.media.ExclusiveUse;
import com.sun.media.util.Registry;
import java.awt.Frame;
import java.awt.TextArea;
import java.awt.Toolkit;
import java.util.Vector;
import javax.media.Format;
import javax.media.PlugInManager;
import javax.media.Renderer;
import javax.media.format.AudioFormat;
import net.sourceforge.retroweaver.runtime.java.lang.Boolean_;

public class JMFInit
extends Frame
implements Runnable {
    private String tempDir = "/tmp";
    private boolean done = false;
    private String userHome;
    private boolean visible = false;

    public JMFInit(String[] stringArray, boolean bl) {
        super("Initializing JMF...");
        this.visible = bl;
        Registry.set((String)"secure.allowCaptureFromApplets", (Object)Boolean_.valueOf((boolean)true));
        Registry.set((String)"secure.allowSaveFileFromApplets", (Object)Boolean_.valueOf((boolean)true));
        this.updateTemp(stringArray);
        try {
            Registry.commit();
        }
        catch (Exception exception) {
            this.message("Failed to commit to JMFRegistry!");
        }
        Thread thread = new Thread(this);
        thread.run();
    }

    public void run() {
        this.detectDirectAudio();
        this.detectS8DirectAudio();
        this.detectCaptureDevices();
        this.done = true;
    }

    private void updateTemp(String[] stringArray) {
        if (stringArray != null && stringArray.length > 0) {
            this.tempDir = stringArray[0];
            this.message("Setting cache directory to " + this.tempDir);
            Registry registry = new Registry();
            try {
                Registry.set((String)"secure.cacheDir", (Object)this.tempDir);
                registry.commit();
                this.message("Updated registry");
            }
            catch (Exception exception) {
                this.message("Couldn't update registry!");
            }
        }
    }

    private void detectCaptureDevices() {
        this.message("Looking for Audio capturer");
        try {
            Class<?> clazz = Class.forName("DirectSoundAuto");
            clazz.newInstance();
            this.message("Finished detecting DirectSound capturer");
        }
        catch (ThreadDeath threadDeath) {
            throw threadDeath;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            Class<?> clazz = Class.forName("JavaSoundAuto");
            clazz.newInstance();
            this.message("Finished detecting javasound capturer");
        }
        catch (ThreadDeath threadDeath) {
            throw threadDeath;
        }
        catch (Throwable throwable) {
            this.message("JavaSound capturer detection failed!");
        }
    }

    private void detectDirectAudio() {
        int n = 4;
        String string = "com.sun.media.renderer.audio.DirectAudioRenderer";
        try {
            Class<?> clazz = Class.forName("VFWAuto");
            clazz = Class.forName("com.sun.media.protocol.dsound.DSound");
            clazz = Class.forName(string);
            Renderer renderer = (Renderer)clazz.newInstance();
            try {
                AudioFormat audioFormat = new AudioFormat("LINEAR", 44100.0, 16, 2);
                renderer.setInputFormat((Format)audioFormat);
                renderer.open();
                Format[] formatArray = renderer.getSupportedInputFormats();
                PlugInManager.addPlugIn((String)string, (Format[])formatArray, (Format[])new Format[0], (int)n);
                Vector vector = PlugInManager.getPlugInList(null, null, (int)n);
                int n2 = vector.size();
                if (vector.elementAt(n2 - 1).equals(string)) {
                    vector.removeElementAt(n2 - 1);
                    vector.insertElementAt(string, 0);
                    PlugInManager.setPlugInList((Vector)vector, (int)n);
                    PlugInManager.commit();
                }
                renderer.close();
            }
            catch (Throwable throwable) {}
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void detectS8DirectAudio() {
        int n = 4;
        String string = "com.sun.media.renderer.audio.DirectAudioRenderer";
        try {
            Class<?> clazz = Class.forName("SunVideoAuto");
            clazz = Class.forName(string);
            Renderer renderer = (Renderer)clazz.newInstance();
            if (renderer instanceof ExclusiveUse && !((ExclusiveUse)renderer).isExclusive()) {
                Vector vector = PlugInManager.getPlugInList(null, null, (int)n);
                int n2 = vector.size();
                boolean bl = false;
                String string2 = null;
                for (int i = 0; i < n2; ++i) {
                    string2 = (String)vector.elementAt(i);
                    if (!string2.equals(string)) continue;
                    bl = true;
                    vector.removeElementAt(i);
                    break;
                }
                if (bl) {
                    vector.insertElementAt(string, 0);
                    PlugInManager.setPlugInList((Vector)vector, (int)n);
                    PlugInManager.commit();
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void message(String string) {
        System.out.println(string);
    }

    private void createGUI() {
        TextArea textArea = new TextArea(5, 50);
        this.add("Center", textArea);
        textArea.setEditable(false);
        this.addNotify();
        this.pack();
        int n = (int)Toolkit.getDefaultToolkit().getScreenSize().getWidth();
        int n2 = (int)Toolkit.getDefaultToolkit().getScreenSize().getHeight();
        this.setLocation((n - this.getWidth()) / 2, (n2 - this.getHeight()) / 2);
        this.setVisible(this.visible);
    }

    public static void start(boolean bl) {
        new JMFInit(null, bl);
    }
}

