/*
 * Decompiled with CFR 0.152.
 */
package nu.fw.jeti.plugins.jingle.jingle.media;

public class PayloadType {
    public static int MAX_FIXED_PT = 95;
    public static int INVALID_PT = 65535;
    private int id;
    private String name;
    private int channels;

    public PayloadType(int n, String string, int n2) {
        this.id = n;
        this.name = string;
        this.channels = n2;
    }

    public PayloadType() {
        this(INVALID_PT, null, 1);
    }

    public PayloadType(int n, String string) {
        this(n, string, 1);
    }

    public PayloadType(PayloadType payloadType) {
        this(payloadType.getId(), payloadType.getName(), payloadType.getChannels());
    }

    public int getId() {
        return this.id;
    }

    public void setId(int n) {
        this.id = n;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public int getChannels() {
        return this.channels;
    }

    public void setChannels(int n) {
        this.channels = n;
    }

    public boolean isNull() {
        if (this.getId() == INVALID_PT) {
            return true;
        }
        return this.getName() == null;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + this.getChannels();
        n = 31 * n + this.getId();
        n = 31 * n + (this.getName() == null ? 0 : this.getName().hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        PayloadType payloadType = (PayloadType)object;
        if (this.getChannels() != payloadType.getChannels()) {
            return false;
        }
        if (this.getId() != payloadType.getId()) {
            return false;
        }
        return this.getId() <= MAX_FIXED_PT || !(this.getName() == null ? payloadType.getName() != null : !this.getName().equals(payloadType.getName()));
    }

    public static class Audio
    extends PayloadType {
        private int clockRate;

        public Audio(int n, String string, int n2, int n3) {
            super(n, string, n2);
            this.clockRate = n3;
        }

        public Audio(int n, String string, int n2) {
            super(n, string);
            this.clockRate = n2;
        }

        public Audio() {
            this.clockRate = 0;
        }

        public Audio(int n, String string) {
            super(n, string);
            this.clockRate = 0;
        }

        public Audio(PayloadType payloadType) {
            super(payloadType);
            this.clockRate = 0;
        }

        public Audio(Audio audio) {
            super(audio);
            this.clockRate = audio.getClockRate();
        }

        public int getClockRate() {
            return this.clockRate;
        }

        public void setClockRate(int n) {
            this.clockRate = n;
        }

        public int hashCode() {
            int n = super.hashCode();
            n = 31 * n + this.getClockRate();
            return n;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!super.equals(object)) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            Audio audio = (Audio)object;
            return this.getClockRate() == audio.getClockRate();
        }
    }
}

