/*
 * Decompiled with CFR 0.152.
 */
package nu.fw.jeti.plugins.jingle.jingle;

import com.sun.media.rtp.util.PacketFilter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import nu.fw.jeti.events.JETIListener;
import nu.fw.jeti.events.StatusChangeListener;
import nu.fw.jeti.jabber.Backend;
import nu.fw.jeti.jabber.JID;
import nu.fw.jeti.jabber.elements.IQExtension;
import nu.fw.jeti.jabber.elements.InfoQuery;
import nu.fw.jeti.jabber.elements.Packet;
import nu.fw.jeti.jabber.elements.XMPPError;
import nu.fw.jeti.plugins.jingle.XMPPException;
import nu.fw.jeti.plugins.jingle.jingle.JingleNegotiator;
import nu.fw.jeti.plugins.jingle.jingle.JingleSessionRequest;
import nu.fw.jeti.plugins.jingle.jingle.listeners.JingleListener;
import nu.fw.jeti.plugins.jingle.jingle.listeners.JingleMediaListener;
import nu.fw.jeti.plugins.jingle.jingle.listeners.JingleSessionListener;
import nu.fw.jeti.plugins.jingle.jingle.listeners.JingleSessionStateListener;
import nu.fw.jeti.plugins.jingle.jingle.listeners.JingleTransportListener;
import nu.fw.jeti.plugins.jingle.jingle.media.ContentInfo;
import nu.fw.jeti.plugins.jingle.jingle.media.JingleMediaManager;
import nu.fw.jeti.plugins.jingle.jingle.media.JingleMediaSession;
import nu.fw.jeti.plugins.jingle.jingle.media.MediaNegotiator;
import nu.fw.jeti.plugins.jingle.jingle.media.MediaReceivedListener;
import nu.fw.jeti.plugins.jingle.jingle.media.PayloadType;
import nu.fw.jeti.plugins.jingle.jingle.nat.TransportCandidate;
import nu.fw.jeti.plugins.jingle.jingle.nat.TransportNegotiator;
import nu.fw.jeti.plugins.jingle.packet.Jingle;
import nu.fw.jeti.plugins.jingle.packet.JingleContentDescription;
import nu.fw.jeti.plugins.jingle.packet.JingleContentInfo;
import nu.fw.jeti.plugins.jingle.packet.JingleTransport;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public abstract class JingleSession
extends JingleNegotiator
implements MediaReceivedListener {
    private static final HashMap sessions = new HashMap();
    private static final Random randomGenerator = new Random();
    private JID initiator;
    private JID responder;
    private String sid;
    private MediaNegotiator mediaNeg = null;
    private TransportNegotiator transNeg = null;
    PacketFilter packetFilter;
    protected JingleMediaManager jingleMediaManager = null;
    protected JingleMediaSession jingleMediaSession = null;
    private boolean closed = false;
    private List<JingleSessionStateListener> stateListeners = new ArrayList<JingleSessionStateListener>();
    private static final /* synthetic */ Class class$nu$fw$jeti$events$StatusChangeListener;

    protected JingleSession(Backend backend, JID jID, JID jID2, String string, JingleMediaManager jingleMediaManager) {
        super(backend);
        this.initiator = jID;
        this.responder = jID2;
        this.sid = string;
        this.jingleMediaManager = jingleMediaManager;
        this.registerInstance();
        this.installConnectionListeners(backend);
    }

    protected JingleSession(Backend backend, JID jID, JID jID2) {
        this(backend, jID, jID2, null, null);
    }

    protected JingleSession(Backend backend, JID jID, JID jID2, JingleMediaManager jingleMediaManager) {
        this(backend, jID, jID2, null, jingleMediaManager);
    }

    public JID getInitiator() {
        return this.initiator;
    }

    public void setInitiator(JID jID) {
        this.initiator = jID;
    }

    public JingleMediaManager getMediaManager() {
        return this.jingleMediaManager;
    }

    public void setMediaManager(JingleMediaManager jingleMediaManager) {
        this.jingleMediaManager = jingleMediaManager;
    }

    public JingleMediaSession getJingleMediaSession() {
        return this.jingleMediaSession;
    }

    public JID getResponder() {
        return this.responder;
    }

    public void setResponder(JID jID) {
        this.responder = jID;
    }

    public String getSid() {
        return this.sid;
    }

    protected void setSid(String string) {
        this.sid = string;
    }

    protected static String generateSessionId() {
        return String.valueOf(Math.abs(randomGenerator.nextLong()));
    }

    protected MediaNegotiator getMediaNeg() {
        return this.mediaNeg;
    }

    protected void setMediaNeg(MediaNegotiator mediaNegotiator) {
        this.destroyMediaNeg();
        this.mediaNeg = mediaNegotiator;
    }

    protected void destroyMediaNeg() {
        if (this.mediaNeg != null) {
            this.mediaNeg.close();
            this.mediaNeg = null;
        }
    }

    public void addStateListener(JingleSessionStateListener jingleSessionStateListener) {
        this.stateListeners.add(jingleSessionStateListener);
    }

    public void removedStateListener(JingleSessionStateListener jingleSessionStateListener) {
        this.stateListeners.remove(jingleSessionStateListener);
    }

    public void removeAllStateListeners() {
        this.stateListeners.clear();
    }

    protected void setState(JingleNegotiator.State state) {
        JingleSessionStateListener jingleSessionStateListener;
        boolean bl = true;
        JingleNegotiator.State state2 = this.getState();
        Iterator<JingleSessionStateListener> iterator = this.stateListeners.iterator();
        while (iterator.hasNext()) {
            jingleSessionStateListener = iterator.next();
            try {
                jingleSessionStateListener.beforeChange(state2, state);
            }
            catch (JingleNegotiator.JingleException jingleException) {
                jingleException.printStackTrace();
                bl = false;
            }
        }
        if (bl) {
            super.setState(state);
        }
        iterator = this.stateListeners.iterator();
        while (iterator.hasNext()) {
            jingleSessionStateListener = iterator.next();
            jingleSessionStateListener.afterChanged(state2, this.getState());
        }
    }

    protected TransportNegotiator getTransportNeg() {
        return this.transNeg;
    }

    protected void setTransportNeg(TransportNegotiator transportNegotiator) {
        this.destroyTransportNeg();
        this.transNeg = transportNegotiator;
    }

    protected void destroyTransportNeg() {
        if (this.transNeg != null) {
            this.transNeg.close();
            this.transNeg = null;
        }
    }

    public boolean isFullyEstablished() {
        if (!this.isValid()) {
            return false;
        }
        return this.getTransportNeg().isFullyEstablished() && this.getMediaNeg().isFullyEstablished();
    }

    public boolean isValid() {
        return this.mediaNeg != null && this.transNeg != null && this.sid != null && this.initiator != null;
    }

    public Jingle dispatchIncomingPacket(Jingle jingle, String string) throws XMPPException {
        Jingle jingle2 = null;
        if (this.invalidState()) {
            throw new IllegalStateException("Illegal state in dispatch packet in Session manager.");
        }
        if (jingle == null) {
            jingle2 = this.getState().eventInvite();
        } else if (jingle.getType().equals("error")) {
            this.getState().eventError(jingle);
        } else if (jingle.getType().equals("result")) {
            if (this.isExpectedId(jingle.getPacketID())) {
                jingle2 = this.getState().eventAck(jingle);
                this.removeExpectedId(jingle.getPacketID());
            }
        } else if (jingle instanceof Jingle) {
            Jingle jingle3 = jingle;
            Jingle.Action action = jingle3.getAction();
            System.out.println("action " + (Object)((Object)action));
            if (action != null) {
                if (action.equals((Object)Jingle.Action.SESSIONACCEPT)) {
                    jingle2 = this.getState().eventAccept(jingle3);
                } else if (action.equals((Object)Jingle.Action.SESSIONINFO)) {
                    jingle2 = this.getState().eventInfo(jingle3);
                } else if (action.equals((Object)Jingle.Action.SESSIONINITIATE)) {
                    jingle2 = this.getState().eventInitiate(jingle3);
                } else if (action.equals((Object)Jingle.Action.SESSIONREDIRECT)) {
                    jingle2 = this.getState().eventRedirect(jingle3);
                } else if (action.equals((Object)Jingle.Action.SESSIONTERMINATE)) {
                    jingle2 = this.getState().eventTerminate(jingle3);
                }
            } else {
                jingle2 = this.errorMalformedStanza(jingle);
            }
        }
        if (jingle2 != null) {
            this.addExpectedId(jingle2.getPacketID());
        }
        return jingle2;
    }

    public synchronized void respond(Jingle jingle) throws XMPPException {
        System.out.println("processing: " + (Object)((Object)jingle));
        if (this.isValid()) {
            String string = null;
            Jingle jingle2 = null;
            Jingle jingle3 = null;
            Jingle jingle4 = null;
            try {
                jingle2 = this.dispatchIncomingPacket(jingle, null);
                if (jingle2 != null) {
                    string = jingle2.getPacketID();
                }
                if (this.mediaNeg != null) {
                    jingle3 = this.mediaNeg.dispatchIncomingPacket(jingle, string);
                }
                if (this.transNeg != null) {
                    jingle4 = this.transNeg.dispatchIncomingPacket(jingle, string);
                }
                this.sendAck(jingle);
                System.out.println("............A" + (Object)((Object)jingle2));
                System.out.println("............B" + (Object)((Object)jingle3));
                System.out.println("............C" + (Object)((Object)jingle4));
                this.sendJingleParts(jingle, jingle2, jingle3, jingle4);
            }
            catch (JingleNegotiator.JingleException jingleException) {
                XMPPError xMPPError = jingleException.getError();
                if (xMPPError != null) {
                    this.sendFormattedError(jingle, xMPPError);
                }
                this.triggerSessionClosedOnError(jingleException);
            }
        }
    }

    private void sendJingleParts(Jingle jingle, Jingle jingle2, Jingle jingle3, Jingle jingle4) {
        if (jingle2 != null) {
            jingle2.addDescriptions(jingle3.getDescriptionsList());
            jingle2.addTransports(jingle4.getTransportsList());
            this.sendFormattedJingle(jingle, jingle2);
        } else {
            if (jingle3 != null) {
                this.sendFormattedJingle(jingle, jingle3);
            }
            if (jingle4 != null) {
                this.sendFormattedJingle(jingle, jingle4);
            }
        }
    }

    public void sendFormattedError(Jingle jingle, XMPPError xMPPError) {
        Object var3_3 = null;
        if (xMPPError != null) {
            this.getConnection().send((Packet)new InfoQuery(jingle.getTo(), jingle.getPacketID(), xMPPError));
            System.err.println(xMPPError);
        }
    }

    public void sendFormattedJingle(Jingle jingle, Jingle jingle2) {
        if (jingle2 != null) {
            if (jingle2.getInitiator() == null) {
                jingle2.setInitiator(this.getInitiator());
            }
            if (jingle2.getResponder() == null) {
                jingle2.setResponder(this.getResponder());
            }
            if (jingle2.getSid() == null) {
                jingle2.setSid(this.getSid());
            }
            JID jID = this.getConnection().getMyJID();
            System.err.println(this.getResponder());
            System.err.println(jID);
            System.err.println(this.getInitiator());
            System.err.println(this.getResponder().equals(jID));
            JID jID2 = this.getResponder().equals(jID) ? this.getInitiator() : this.getResponder();
            JID jID3 = jingle2.getTo();
            if (jingle2.getTo() == null) {
                jID3 = jingle != null ? jingle.getFrom() : jID2;
            }
            this.getConnection().send((Packet)new InfoQuery(jID3, jingle2.getType(), jingle2.getPacketID(), (IQExtension)jingle2));
        }
    }

    public void sendFormattedJingle(Jingle jingle) {
        this.sendFormattedJingle(null, jingle);
    }

    protected Jingle errorMalformedStanza(Jingle jingle) {
        return JingleSession.createError(jingle.getPacketID(), jingle.getFrom(), this.getConnection().getMyJID(), 400, "Bad Request");
    }

    public void sendAck(Jingle jingle) {
        if (jingle != null && jingle.getType().equals("set")) {
            this.getConnection().send((Packet)new InfoQuery(jingle.getFrom(), "result", jingle.getPacketID(), null));
        }
    }

    public synchronized void sendContentInfo(ContentInfo contentInfo) {
        if (this.isValid()) {
            this.sendFormattedJingle(new Jingle(new JingleContentInfo(contentInfo)));
        }
    }

    protected PayloadType.Audio getAcceptedAudioPayloadType(Jingle jingle) throws XMPPException {
        PayloadType.Audio audio = null;
        ArrayList arrayList = jingle.getDescriptionsList();
        if (jingle.getAction().equals((Object)Jingle.Action.SESSIONACCEPT)) {
            if (arrayList.size() > 1) {
                throw new XMPPException("Unsupported feature: the number of accepted content descriptions is greater than 1.");
            }
            if (arrayList.size() == 1) {
                JingleContentDescription jingleContentDescription = (JingleContentDescription)((Object)arrayList.get(0));
                if (jingleContentDescription.getJinglePayloadTypesCount() > 1) {
                    throw new XMPPException("Unsupported feature: the number of accepted payload types is greater than 1.");
                }
                if (jingleContentDescription.getJinglePayloadTypesCount() == 1) {
                    JingleContentDescription.JinglePayloadType jinglePayloadType = (JingleContentDescription.JinglePayloadType)jingleContentDescription.getJinglePayloadTypesList().get(0);
                    audio = (PayloadType.Audio)jinglePayloadType.getPayloadType();
                }
            }
        }
        return audio;
    }

    protected TransportCandidate getAcceptedLocalCandidate(Jingle jingle) throws XMPPException {
        ArrayList arrayList = jingle.getTransportsList();
        TransportCandidate transportCandidate = null;
        if (jingle.getAction().equals((Object)Jingle.Action.SESSIONACCEPT)) {
            if (arrayList.size() > 1) {
                throw new XMPPException("Unsupported feature: the number of accepted transports is greater than 1.");
            }
            if (arrayList.size() == 1) {
                JingleTransport jingleTransport = (JingleTransport)((Object)arrayList.get(0));
                if (jingleTransport.getCandidatesCount() > 1) {
                    throw new XMPPException("Unsupported feature: the number of accepted transport candidates is greater than 1.");
                }
                if (jingleTransport.getCandidatesCount() == 1) {
                    JingleTransport.JingleTransportCandidate jingleTransportCandidate = (JingleTransport.JingleTransportCandidate)jingleTransport.getCandidatesList().get(0);
                    transportCandidate = jingleTransportCandidate.getMediaTransport();
                }
            }
        }
        return transportCandidate;
    }

    public int hashCode() {
        return Jingle.getSessionHash(this.getSid(), this.getInitiator());
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        JingleSession jingleSession = (JingleSession)object;
        if (this.initiator == null) {
            if (jingleSession.initiator != null) {
                return false;
            }
        } else if (!this.initiator.equals(jingleSession.initiator)) {
            // empty if block
        }
        if (this.responder == null ? jingleSession.responder != null : !this.responder.equals(jingleSession.responder)) {
            return false;
        }
        return !(this.sid == null ? jingleSession.sid != null : !this.sid.equals(jingleSession.sid));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unregisterInstanceFor(Backend backend) {
        HashMap hashMap = sessions;
        synchronized (hashMap) {
            sessions.remove(backend);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerInstance() {
        HashMap hashMap = sessions;
        synchronized (hashMap) {
            sessions.put(this.getConnection(), this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JingleSession getInstanceFor(Backend backend) {
        if (backend == null) {
            throw new IllegalArgumentException("Connection cannot be null");
        }
        JingleSession jingleSession = null;
        HashMap hashMap = sessions;
        synchronized (hashMap) {
            if (sessions.containsKey(backend)) {
                jingleSession = (JingleSession)sessions.get(backend);
            }
        }
        return jingleSession;
    }

    private void installConnectionListeners(final Backend backend) {
        if (backend != null) {
            Class<?> clazz = class$nu$fw$jeti$events$StatusChangeListener;
            if (clazz == null) {
                clazz = class$nu$fw$jeti$events$StatusChangeListener = new StatusChangeListener[0].getClass().getComponentType();
            }
            backend.addListener(clazz, (JETIListener)new StatusChangeListener(){

                public void connectionChanged(boolean bl) {
                    if (!bl) {
                        JingleSession.this.unregisterInstanceFor(backend);
                    }
                }

                public void ownPresenceChanged(int n, String string) {
                }

                public void exit() {
                    JingleSession.this.unregisterInstanceFor(backend);
                }
            });
        }
    }

    public void addMediaListener(JingleMediaListener jingleMediaListener) {
        if (this.getMediaNeg() != null) {
            this.getMediaNeg().addListener(jingleMediaListener);
        }
    }

    public void removeMediaListener(JingleMediaListener jingleMediaListener) {
        if (this.getMediaNeg() != null) {
            this.getMediaNeg().removeListener(jingleMediaListener);
        }
    }

    public void addTransportListener(JingleTransportListener jingleTransportListener) {
        if (this.getTransportNeg() != null) {
            this.getTransportNeg().addListener(jingleTransportListener);
        }
    }

    public void removeTransportListener(JingleTransportListener jingleTransportListener) {
        if (this.getTransportNeg() != null) {
            this.getTransportNeg().removeListener(jingleTransportListener);
        }
    }

    protected void triggerSessionClosed(String string) {
        Object object;
        System.out.println("seession closed trig");
        Object object2 = this.getTransportNeg().getOfferedCandidates().iterator();
        while (object2.hasNext()) {
            object = object2.next();
            ((TransportCandidate)object).removeCandidateEcho();
        }
        object2 = this.getListenersList();
        object = ((ArrayList)object2).iterator();
        while (object.hasNext()) {
            JingleListener jingleListener = (JingleListener)object.next();
            if (!(jingleListener instanceof JingleSessionListener)) continue;
            JingleSessionListener jingleSessionListener = (JingleSessionListener)jingleListener;
            jingleSessionListener.sessionClosed(string, this);
        }
        this.close();
        if (this.jingleMediaSession != null) {
            this.jingleMediaSession.stopTrasmit();
            this.jingleMediaSession.stopReceive();
        }
    }

    protected void triggerSessionClosedOnError(XMPPException xMPPException) {
        Object object;
        Object object2 = this.getTransportNeg().getOfferedCandidates().iterator();
        while (object2.hasNext()) {
            object = object2.next();
            ((TransportCandidate)object).removeCandidateEcho();
        }
        object2 = this.getListenersList();
        object = ((ArrayList)object2).iterator();
        while (object.hasNext()) {
            JingleListener jingleListener = (JingleListener)object.next();
            if (!(jingleListener instanceof JingleSessionListener)) continue;
            JingleSessionListener jingleSessionListener = (JingleSessionListener)jingleListener;
            jingleSessionListener.sessionClosedOnError(xMPPException, this);
        }
        this.close();
        if (this.jingleMediaSession != null) {
            this.jingleMediaSession.stopTrasmit();
            this.jingleMediaSession.stopReceive();
        }
    }

    protected void triggerSessionEstablished(PayloadType payloadType, TransportCandidate transportCandidate, TransportCandidate transportCandidate2) {
        Object object;
        Object object2;
        ArrayList arrayList = this.getListenersList();
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            object2 = (JingleListener)iterator.next();
            if (!(object2 instanceof JingleSessionListener)) continue;
            object = (JingleSessionListener)object2;
            object.sessionEstablished(payloadType, transportCandidate, transportCandidate2, this);
        }
        if (this.jingleMediaManager != null) {
            transportCandidate.removeCandidateEcho();
            transportCandidate2.removeCandidateEcho();
            this.jingleMediaSession = this.jingleMediaManager.createMediaSession(payloadType, transportCandidate, transportCandidate2, this);
            this.jingleMediaSession.addMediaReceivedListener(this);
            if (this.jingleMediaSession != null) {
                this.jingleMediaSession.startTrasmit();
                this.jingleMediaSession.startReceive();
                object2 = this.getTransportNeg().getOfferedCandidates().iterator();
                while (object2.hasNext()) {
                    object = (TransportCandidate)object2.next();
                    ((TransportCandidate)object).removeCandidateEcho();
                }
            }
        }
    }

    protected void triggerMediaReceived(String string) {
        ArrayList arrayList = this.getListenersList();
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            JingleListener jingleListener = (JingleListener)iterator.next();
            if (!(jingleListener instanceof JingleSessionListener)) continue;
            JingleSessionListener jingleSessionListener = (JingleSessionListener)jingleListener;
            jingleSessionListener.sessionMediaReceived(this, string);
        }
    }

    protected void triggerSessionRedirect(String string) {
        ArrayList arrayList = this.getListenersList();
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            JingleListener jingleListener = (JingleListener)iterator.next();
            if (!(jingleListener instanceof JingleSessionListener)) continue;
            JingleSessionListener jingleSessionListener = (JingleSessionListener)jingleListener;
            jingleSessionListener.sessionRedirected(string, this);
        }
    }

    protected void triggerSessionDeclined(String string) {
        Object object;
        Object object2;
        ArrayList arrayList = this.getListenersList();
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            object2 = (JingleListener)iterator.next();
            if (!(object2 instanceof JingleSessionListener)) continue;
            object = (JingleSessionListener)object2;
            object.sessionDeclined(string, this);
        }
        object2 = this.getTransportNeg().getOfferedCandidates().iterator();
        while (object2.hasNext()) {
            object = (TransportCandidate)object2.next();
            ((TransportCandidate)object).removeCandidateEcho();
        }
    }

    public abstract void start(JingleSessionRequest var1) throws XMPPException;

    public void terminate() throws XMPPException {
        this.terminate("Closed Locally");
    }

    public void terminate(String string) throws XMPPException {
        if (this.isClosed()) {
            return;
        }
        System.out.println("closssinngg State: " + this.getState());
        Jingle jingle = new Jingle(Jingle.Action.SESSIONTERMINATE);
        jingle.setType("set");
        this.sendFormattedJingle(jingle);
        this.triggerSessionClosed(string);
    }

    public void close() {
        if (this.isClosed()) {
            return;
        }
        this.destroyMediaNeg();
        this.destroyTransportNeg();
        System.out.println("Negotiation Closed: " + this.getConnection().getMyJID() + " " + this.sid);
        this.closed = true;
        super.close();
    }

    public boolean isClosed() {
        return this.closed;
    }

    public static Jingle createError(String string, JID jID, JID jID2, int n, String string2) {
        XMPPError xMPPError = new XMPPError(string2, n);
        System.out.println("Created Error Packet:" + xMPPError);
        return new Jingle(string, jID, xMPPError);
    }

    public void mediaReceived(String string) {
        this.triggerMediaReceived(string);
    }

    public IQExtension dispatchIncomingPacket(Jingle jingle, String string) throws XMPPException {
        return this.dispatchIncomingPacket(jingle, string);
    }
}

