/*
 * Decompiled with CFR 0.152.
 */
package nu.fw.jeti.plugins.jingle.jingle;

import java.util.ArrayList;
import nu.fw.jeti.jabber.Backend;
import nu.fw.jeti.jabber.elements.IQExtension;
import nu.fw.jeti.jabber.elements.XMPPError;
import nu.fw.jeti.plugins.jingle.XMPPException;
import nu.fw.jeti.plugins.jingle.jingle.listeners.JingleListener;
import nu.fw.jeti.plugins.jingle.packet.Jingle;

public abstract class JingleNegotiator {
    private State state;
    private Backend connection;
    private final ArrayList listeners = new ArrayList();
    private String expectedAckId;
    private static final /* synthetic */ Class class$java$lang$Object;

    public JingleNegotiator() {
        this(null);
    }

    public JingleNegotiator(Backend backend) {
        this.connection = backend;
        this.state = null;
    }

    public Backend getConnection() {
        return this.connection;
    }

    public void setConnection(Backend backend) {
        this.connection = backend;
    }

    public boolean invalidState() {
        return this.state == null;
    }

    public State getState() {
        return this.state;
    }

    public Class getStateClass() {
        if (this.state != null) {
            return this.state.getClass();
        }
        Class<?> clazz = class$java$lang$Object;
        if (clazz == null) {
            clazz = class$java$lang$Object = new Object[0].getClass().getComponentType();
        }
        return clazz;
    }

    protected void setState(State state) {
        boolean bl;
        System.out.println("change state " + this.state + "->" + state);
        boolean bl2 = bl = state != this.state;
        if (bl && this.state != null) {
            this.state.eventExit();
        }
        this.state = state;
        if (bl && this.state != null) {
            this.state.eventEnter();
        }
    }

    public void addExpectedId(String string) {
        this.expectedAckId = string;
    }

    public boolean isExpectedId(String string) {
        if (string != null) {
            return string.equals(this.expectedAckId);
        }
        return false;
    }

    public void removeExpectedId(String string) {
        this.addExpectedId(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(JingleListener jingleListener) {
        ArrayList arrayList = this.listeners;
        synchronized (arrayList) {
            this.listeners.add(jingleListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(JingleListener jingleListener) {
        ArrayList arrayList = this.listeners;
        synchronized (arrayList) {
            this.listeners.remove(jingleListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ArrayList getListenersList() {
        ArrayList arrayList;
        ArrayList arrayList2 = this.listeners;
        synchronized (arrayList2) {
            arrayList = new ArrayList(this.listeners);
        }
        return arrayList;
    }

    public abstract IQExtension dispatchIncomingPacket(Jingle var1, String var2) throws XMPPException;

    public void close() {
        this.setState(null);
    }

    public static class State {
        private JingleNegotiator neg;

        public State(JingleNegotiator jingleNegotiator) {
            this.neg = jingleNegotiator;
        }

        public JingleNegotiator getNegotiator() {
            return this.neg;
        }

        public void setNegotiator(JingleNegotiator jingleNegotiator) {
            this.neg = jingleNegotiator;
        }

        public Jingle eventAck(Jingle jingle) throws XMPPException {
            return null;
        }

        public void eventError(Jingle jingle) throws XMPPException {
            throw new JingleException(jingle.getError().getFirstXMPPError().getError());
        }

        public Jingle eventInvite() {
            throw new IllegalStateException("Negotiation can not be started in this state.");
        }

        public Jingle eventInitiate(Jingle jingle) throws XMPPException {
            return null;
        }

        public Jingle eventAccept(Jingle jingle) throws XMPPException {
            return null;
        }

        public Jingle eventRedirect(Jingle jingle) {
            return null;
        }

        public Jingle eventModify(Jingle jingle) {
            return null;
        }

        public Jingle eventDecline(Jingle jingle) throws JingleException {
            return null;
        }

        public Jingle eventInfo(Jingle jingle) throws XMPPException {
            return null;
        }

        public Jingle eventTerminate(Jingle jingle) throws XMPPException {
            if (this.neg != null && !this.neg.invalidState()) {
                this.neg.close();
            }
            return null;
        }

        public void eventEnter() {
        }

        public void eventExit() {
            if (this.neg != null) {
                this.neg.removeExpectedId(null);
            }
        }
    }

    public static class JingleException
    extends XMPPException {
        private final XMPPError error;

        public JingleException() {
            this.error = null;
        }

        public JingleException(String string) {
            super(string);
            this.error = null;
        }

        public JingleException(XMPPError xMPPError) {
            this.error = xMPPError;
        }

        public XMPPError getError() {
            return this.error;
        }
    }
}

