/*
 * Decompiled with CFR 0.152.
 */
package de.javawi.jstun.util;

import de.javawi.jstun.util.Utility;
import de.javawi.jstun.util.UtilityException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.StringTokenizer;

public class Address {
    int firstOctet;
    int secondOctet;
    int thirdOctet;
    int fourthOctet;

    public Address(int n, int n2, int n3, int n4) throws UtilityException {
        if (n < 0 || n > 255 || n2 < 0 || n2 > 255 || n3 < 0 || n3 > 255 || n4 < 0 || n4 > 255) {
            throw new UtilityException("Address is malformed.");
        }
        this.firstOctet = n;
        this.secondOctet = n2;
        this.thirdOctet = n3;
        this.fourthOctet = n4;
    }

    public Address(String string) throws UtilityException {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        if (stringTokenizer.countTokens() != 4) {
            throw new UtilityException("4 octets in address string are required.");
        }
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            int n2 = Integer.parseInt(stringTokenizer.nextToken());
            if (n2 < 0 || n2 > 255) {
                throw new UtilityException("Address is in incorrect format.");
            }
            switch (n) {
                case 0: {
                    this.firstOctet = n2;
                    ++n;
                    break;
                }
                case 1: {
                    this.secondOctet = n2;
                    ++n;
                    break;
                }
                case 2: {
                    this.thirdOctet = n2;
                    ++n;
                    break;
                }
                case 3: {
                    this.fourthOctet = n2;
                    ++n;
                }
            }
        }
    }

    public Address(byte[] byArray) throws UtilityException {
        if (byArray.length < 4) {
            throw new UtilityException("4 bytes are required.");
        }
        this.firstOctet = Utility.OneByteToInteger(byArray[0]);
        this.secondOctet = Utility.OneByteToInteger(byArray[1]);
        this.thirdOctet = Utility.OneByteToInteger(byArray[2]);
        this.fourthOctet = Utility.OneByteToInteger(byArray[3]);
    }

    public String toString() {
        return new String(this.firstOctet + "." + this.secondOctet + "." + this.thirdOctet + "." + this.fourthOctet);
    }

    public byte[] getBytes() throws UtilityException {
        byte[] byArray = new byte[]{Utility.IntegerToOneByte(this.firstOctet), Utility.IntegerToOneByte(this.secondOctet), Utility.IntegerToOneByte(this.thirdOctet), Utility.IntegerToOneByte(this.fourthOctet)};
        return byArray;
    }

    public InetAddress getInetAddress() throws UtilityException, UnknownHostException {
        byte[] byArray = new byte[]{Utility.IntegerToOneByte(this.firstOctet), Utility.IntegerToOneByte(this.secondOctet), Utility.IntegerToOneByte(this.thirdOctet), Utility.IntegerToOneByte(this.fourthOctet)};
        return InetAddress.getByAddress(byArray);
    }

    public boolean equals(Object object) {
        try {
            byte[] byArray = this.getBytes();
            byte[] byArray2 = ((Address)object).getBytes();
            return byArray[0] == byArray2[0] && byArray[1] == byArray2[1] && byArray[2] == byArray2[2] && byArray[3] == byArray2[3];
        }
        catch (UtilityException utilityException) {
            return false;
        }
    }
}

