/*
 * Decompiled with CFR 0.152.
 */
package de.javawi.jstun.test;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;

public class DiscoveryInfo {
    private InetAddress testIP;
    private boolean error = false;
    private int errorResponseCode = 0;
    private String errorReason;
    private boolean openAccess = false;
    private boolean blockedUDP = false;
    private boolean fullCone = false;
    private boolean restrictedCone = false;
    private boolean portRestrictedCone = false;
    private boolean symmetricCone = false;
    private boolean symmetricUDPFirewall = false;
    private InetAddress publicIP;

    public DiscoveryInfo(InetAddress inetAddress) {
        this.testIP = inetAddress;
    }

    public boolean isError() {
        return this.error;
    }

    public void setError(int n, String string) {
        this.error = true;
        this.errorResponseCode = n;
        this.errorReason = string;
    }

    public boolean isOpenAccess() {
        if (this.error) {
            return false;
        }
        return this.openAccess;
    }

    public void setOpenAccess() {
        this.openAccess = true;
    }

    public boolean isBlockedUDP() {
        if (this.error) {
            return false;
        }
        return this.blockedUDP;
    }

    public void setBlockedUDP() {
        this.blockedUDP = true;
    }

    public boolean isFullCone() {
        if (this.error) {
            return false;
        }
        return this.fullCone;
    }

    public void setFullCone() {
        this.fullCone = true;
    }

    public boolean isPortRestrictedCone() {
        if (this.error) {
            return false;
        }
        return this.portRestrictedCone;
    }

    public void setPortRestrictedCone() {
        this.portRestrictedCone = true;
    }

    public boolean isRestrictedCone() {
        if (this.error) {
            return false;
        }
        return this.restrictedCone;
    }

    public void setRestrictedCone() {
        this.restrictedCone = true;
    }

    public boolean isSymmetricCone() {
        if (this.error) {
            return false;
        }
        return this.symmetricCone;
    }

    public void setSymmetricCone() {
        this.symmetricCone = true;
    }

    public boolean isSymmetricUDPFirewall() {
        if (this.error) {
            return false;
        }
        return this.symmetricUDPFirewall;
    }

    public void setSymmetricUDPFirewall() {
        this.symmetricUDPFirewall = true;
    }

    public InetAddress getPublicIP() {
        return this.publicIP;
    }

    public void setPublicIP(InetAddress inetAddress) {
        this.publicIP = inetAddress;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Network interface: ");
        try {
            stringBuffer.append(NetworkInterface.getByInetAddress(this.testIP).getName());
        }
        catch (SocketException socketException) {
            stringBuffer.append("unknown");
        }
        stringBuffer.append("\n");
        stringBuffer.append("Local IP address: ");
        stringBuffer.append(this.testIP.getHostAddress());
        stringBuffer.append("\n");
        if (this.error) {
            stringBuffer.append(this.errorReason + " - Responsecode: " + this.errorResponseCode);
            return stringBuffer.toString();
        }
        stringBuffer.append("Result: ");
        if (this.openAccess) {
            stringBuffer.append("Open access to the Internet.\n");
        }
        if (this.blockedUDP) {
            stringBuffer.append("Firewall blocks UDP.\n");
        }
        if (this.fullCone) {
            stringBuffer.append("Full Cone NAT handles connections.\n");
        }
        if (this.restrictedCone) {
            stringBuffer.append("Restricted Cone NAT handles connections.\n");
        }
        if (this.portRestrictedCone) {
            stringBuffer.append("Port restricted Cone NAT handles connections.\n");
        }
        if (this.symmetricCone) {
            stringBuffer.append("Symmetric Cone NAT handles connections.\n");
        }
        if (this.symmetricUDPFirewall) {
            stringBuffer.append("Symmetric UDP Firewall handles connections.\n");
        }
        if (!(this.openAccess || this.blockedUDP || this.fullCone || this.restrictedCone || this.portRestrictedCone || this.symmetricCone || this.symmetricUDPFirewall)) {
            stringBuffer.append("unkown\n");
        }
        stringBuffer.append("Public IP address: ");
        if (this.publicIP != null) {
            stringBuffer.append(this.publicIP.getHostAddress());
        } else {
            stringBuffer.append("unknown");
        }
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }
}

