/*
 * Decompiled with CFR 0.152.
 */
package de.javawi.jstun.attribute;

import de.javawi.jstun.attribute.MessageAttribute;
import de.javawi.jstun.attribute.MessageAttributeException;
import de.javawi.jstun.attribute.MessageAttributeInterface;
import de.javawi.jstun.attribute.MessageAttributeParsingException;
import de.javawi.jstun.util.Address;
import de.javawi.jstun.util.Utility;
import de.javawi.jstun.util.UtilityException;

public class MappedResponseChangedSourceAddressReflectedFrom
extends MessageAttribute {
    int port;
    Address address;

    public MappedResponseChangedSourceAddressReflectedFrom() {
        try {
            this.port = 0;
            this.address = new Address("0.0.0.0");
        }
        catch (UtilityException utilityException) {
            utilityException.getMessage();
            utilityException.printStackTrace();
        }
    }

    public MappedResponseChangedSourceAddressReflectedFrom(MessageAttributeInterface.MessageAttributeType messageAttributeType) {
        super(messageAttributeType);
    }

    public int getPort() {
        return this.port;
    }

    public Address getAddress() {
        return this.address;
    }

    public void setPort(int n) throws MessageAttributeException {
        if (n > 65536 || n < 0) {
            throw new MessageAttributeException("Port value " + n + " out of range.");
        }
        this.port = n;
    }

    public void setAddress(Address address) {
        this.address = address;
    }

    public byte[] getBytes() throws UtilityException {
        byte[] byArray = new byte[12];
        System.arraycopy(Utility.IntegerToTwoBytes(MappedResponseChangedSourceAddressReflectedFrom.typeToInteger(this.type)), 0, byArray, 0, 2);
        System.arraycopy(Utility.IntegerToTwoBytes(8), 0, byArray, 2, 2);
        byArray[5] = Utility.IntegerToOneByte(1);
        System.arraycopy(Utility.IntegerToTwoBytes(this.port), 0, byArray, 6, 2);
        System.arraycopy(this.address.getBytes(), 0, byArray, 8, 4);
        return byArray;
    }

    protected static MappedResponseChangedSourceAddressReflectedFrom parse(MappedResponseChangedSourceAddressReflectedFrom mappedResponseChangedSourceAddressReflectedFrom, byte[] byArray) throws MessageAttributeParsingException {
        try {
            if (byArray.length < 8) {
                throw new MessageAttributeParsingException("Data array too short");
            }
            int n = Utility.OneByteToInteger(byArray[1]);
            if (n != 1) {
                throw new MessageAttributeParsingException("Family " + n + " is not supported");
            }
            byte[] byArray2 = new byte[2];
            System.arraycopy(byArray, 2, byArray2, 0, 2);
            mappedResponseChangedSourceAddressReflectedFrom.setPort(Utility.TwoBytesToInteger(byArray2));
            int n2 = Utility.OneByteToInteger(byArray[4]);
            int n3 = Utility.OneByteToInteger(byArray[5]);
            int n4 = Utility.OneByteToInteger(byArray[6]);
            int n5 = Utility.OneByteToInteger(byArray[7]);
            mappedResponseChangedSourceAddressReflectedFrom.setAddress(new Address(n2, n3, n4, n5));
            return mappedResponseChangedSourceAddressReflectedFrom;
        }
        catch (UtilityException utilityException) {
            throw new MessageAttributeParsingException("Parsing error");
        }
        catch (MessageAttributeException messageAttributeException) {
            throw new MessageAttributeParsingException("Port parsing error");
        }
    }

    public String toString() {
        return "Address " + this.address.toString() + ", Port " + this.port;
    }
}

