/*
 * Decompiled with CFR 0.152.
 */
package de.javawi.jstun.attribute;

import de.javawi.jstun.attribute.MessageAttribute;
import de.javawi.jstun.attribute.MessageAttributeException;
import de.javawi.jstun.attribute.MessageAttributeInterface;
import de.javawi.jstun.attribute.MessageAttributeParsingException;
import de.javawi.jstun.util.Utility;
import de.javawi.jstun.util.UtilityException;

public class ErrorCode
extends MessageAttribute {
    int responseCode;
    String reason;

    public ErrorCode() {
        super(MessageAttributeInterface.MessageAttributeType.ErrorCode);
    }

    public void setResponseCode(int n) throws MessageAttributeException {
        switch (n) {
            case 400: {
                this.reason = "Bad Request";
                break;
            }
            case 401: {
                this.reason = "Unauthorized";
                break;
            }
            case 420: {
                this.reason = "Unkown Attribute";
                break;
            }
            case 430: {
                this.reason = "Stale Credentials";
                break;
            }
            case 431: {
                this.reason = "Integrity Check Failure";
                break;
            }
            case 432: {
                this.reason = "Missing Username";
                break;
            }
            case 433: {
                this.reason = "Use TLS";
                break;
            }
            case 500: {
                this.reason = "Server Error";
                break;
            }
            case 600: {
                this.reason = "Global Failure";
                break;
            }
            default: {
                throw new MessageAttributeException("Response Code is not valid");
            }
        }
        this.responseCode = n;
    }

    public int getResponseCode() {
        return this.responseCode;
    }

    public String getReason() {
        return this.reason;
    }

    public byte[] getBytes() throws UtilityException {
        int n = this.reason.length();
        if (n % 4 != 0) {
            n += 4 - n % 4;
        }
        byte[] byArray = new byte[n += 4];
        System.arraycopy(Utility.IntegerToTwoBytes(ErrorCode.typeToInteger(this.type)), 0, byArray, 0, 2);
        System.arraycopy(Utility.IntegerToTwoBytes(n - 4), 0, byArray, 2, 2);
        int n2 = (int)Math.floor((double)this.responseCode / 100.0);
        byArray[6] = Utility.IntegerToOneByte(n2);
        byArray[7] = Utility.IntegerToOneByte(this.responseCode % 100);
        byte[] byArray2 = this.reason.getBytes();
        System.arraycopy(byArray2, 0, byArray, 8, byArray2.length);
        return byArray;
    }

    public static ErrorCode parse(byte[] byArray) throws MessageAttributeParsingException {
        try {
            if (byArray.length < 4) {
                throw new MessageAttributeParsingException("Data array too short");
            }
            byte by = byArray[3];
            int n = Utility.OneByteToInteger(by);
            if (n < 1 || n > 6) {
                throw new MessageAttributeParsingException("Class parsing error");
            }
            byte by2 = byArray[4];
            int n2 = Utility.OneByteToInteger(by2);
            if (n2 < 0 || n2 > 99) {
                throw new MessageAttributeParsingException("Number parsing error");
            }
            int n3 = n * 100 + n2;
            ErrorCode errorCode = new ErrorCode();
            errorCode.setResponseCode(n3);
            return errorCode;
        }
        catch (UtilityException utilityException) {
            throw new MessageAttributeParsingException("Parsing error");
        }
        catch (MessageAttributeException messageAttributeException) {
            throw new MessageAttributeParsingException("Parsing error");
        }
    }
}

