/*
 * Decompiled with CFR 0.152.
 */
package nu.fw.jeti.plugins.windowsutils;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import nu.fw.jeti.jabber.Backend;
import nu.fw.jeti.plugins.PreferencesPanel;
import nu.fw.jeti.plugins.windowsutils.Plugin;
import nu.fw.jeti.util.I18N;
import nu.fw.jeti.util.Preferences;

public class PrefPanel
extends PreferencesPanel {
    private JSlider slider;
    private Plugin plugin = new Plugin();

    public PrefPanel(final Backend backend) {
        if (!this.plugin.supportsAlpha()) {
            this.add(new JLabel(I18N.gettext((String)"windowsutils.Sorry_transparency_not_supported_by_your_OS")));
            return;
        }
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 5, 0, 3);
        this.slider = new JSlider(5, 100, Preferences.getInteger((String)"windowsutils", (String)"alpha", (int)70));
        this.slider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                PrefPanel.this.plugin.setWindowAlpha(backend.getMainWindow(), PrefPanel.this.slider.getValue());
            }
        });
        this.slider.setMajorTickSpacing(10);
        this.slider.setMinorTickSpacing(1);
        this.slider.setPaintTicks(true);
        this.slider.setPaintLabels(true);
        this.slider.setLabelTable(this.slider.createStandardLabels(10, 10));
        this.add(new JLabel(I18N.gettext((String)"windowsutils.Transparancy,_100%_is_opaque")), gridBagConstraints);
        this.add(this.slider, gridBagConstraints);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        this.add(Box.createVerticalGlue(), gridBagConstraints);
    }

    public void savePreferences() {
        if (this.plugin.supportsAlpha()) {
            Preferences.putInteger((String)"windowsutils", (String)"alpha", (int)this.slider.getValue());
        }
    }
}

