/*
 * Decompiled with CFR 0.152.
 */
package nu.fw.jeti.plugins.groupchat.handlers;

import nu.fw.jeti.jabber.JID;
import nu.fw.jeti.jabber.elements.Extension;
import nu.fw.jeti.jabber.handlers.ExtensionHandler;
import nu.fw.jeti.plugins.groupchat.elements.XMUCUser;
import nu.fw.jeti.plugins.groupchat.elements.XMUCUserInvite;
import nu.fw.jeti.util.Log;
import org.xml.sax.Attributes;

public class XMUCUserHandler
extends ExtensionHandler {
    private JID jid;
    private String nick;
    private String affiliation;
    private String role;
    private int statuscode;
    private String reason;
    private boolean decline;
    private boolean invite;

    public void startHandling(Attributes attributes) {
        this.jid = null;
        this.nick = null;
        this.affiliation = null;
        this.role = null;
        this.statuscode = 0;
        this.reason = null;
    }

    public void startElement(String string, Attributes attributes) {
        if (string.equals("invite")) {
            this.invite = true;
            this.checkJID(string, attributes.getValue("from"));
        } else if (string.equals("decline")) {
            this.decline = true;
            this.invite = true;
        }
        if (string.equals("item")) {
            this.checkJID(string, attributes.getValue("jid"));
            this.affiliation = attributes.getValue("affiliation");
            this.role = attributes.getValue("role");
            this.nick = attributes.getValue("nick");
        } else if (string.equals("status")) {
            try {
                this.statuscode = Integer.parseInt(attributes.getValue("code"));
            }
            catch (NumberFormatException numberFormatException) {
                Log.notParsedXML((String)("XMUC#User " + string + this.getText()));
            }
        } else {
            Log.notParsedXML((String)("XMUC#User " + string + this.getText()));
        }
    }

    private void checkJID(String string, String string2) {
        try {
            this.jid = JID.checkedJIDFromString((String)string2);
        }
        catch (InstantiationException instantiationException) {
            Log.notParsedXML((String)("XMUC#User " + string + this.getText()));
        }
    }

    public void endElement(String string) {
        if (string.equals("reason")) {
            this.reason = this.getText();
        }
        this.clearCurrentChars();
    }

    public Extension build() {
        if (this.invite) {
            return new XMUCUserInvite(this.jid, this.reason, this.decline);
        }
        return new XMUCUser(this.affiliation, this.role, this.nick, this.jid, this.statuscode, this.reason);
    }
}

