/*
 * Decompiled with CFR 0.152.
 */
package nu.fw.jeti.plugins.groupchat.elements;

import java.text.MessageFormat;
import nu.fw.jeti.backend.XExecutableExtension;
import nu.fw.jeti.jabber.Backend;
import nu.fw.jeti.jabber.JID;
import nu.fw.jeti.jabber.elements.Extension;
import nu.fw.jeti.jabber.elements.Packet;
import nu.fw.jeti.plugins.groupchat.Plugin;
import nu.fw.jeti.util.I18N;
import nu.fw.jeti.util.Popups;

public class XMUCUserInvite
extends Extension
implements XExecutableExtension {
    private JID user;
    private String reason;
    private boolean decline;

    public XMUCUserInvite(JID jID, String string) {
        this.user = jID;
        this.reason = string;
    }

    public XMUCUserInvite(JID jID, String string, boolean bl) {
        this.user = jID;
        this.reason = string;
        this.decline = bl;
    }

    public void execute(Packet packet, Backend backend) {
        if (this.decline) {
            String string = this.reason == null ? "{0}_has_declined_your_invitation" : "{0}_has_declined_your_invitation because of {1}";
            Popups.messagePopup((String)MessageFormat.format(I18N.gettext((String)string), this.user, this.reason), (String)I18N.gettext((String)"groupchat.Groupchat_Invitation"));
        } else {
            this.answerInvite(packet, backend);
        }
    }

    private void answerInvite(final Packet packet, final Backend backend) {
        Popups.OptionChoosed optionChoosed = new Popups.OptionChoosed(){

            public void optionChoosed(int n) {
                if (n == 1) {
                    JID jID = packet.getFrom();
                    JID jID2 = new JID(jID.getUser(), jID.getDomain(), backend.getMyJID().getUser());
                    Plugin.startGroupchat(jID2, backend);
                }
            }
        };
        Object[] objectArray = new Object[]{I18N.gettext((String)"groupchat.Decline"), I18N.gettext((String)"groupchat.Accept")};
        Popups.showOptionDialog((Object)MessageFormat.format(I18N.gettext((String)"groupchat.{0}_invites_you_to_room_{1}_on_{2}"), this.user, packet.getFrom().getUser(), packet.getFrom().getDomain()), (String)I18N.gettext((String)"groupchat.Groupchat_Invitation"), (int)0, (int)3, null, (Object[])objectArray, (Object)objectArray[1], (Popups.OptionChoosed)optionChoosed);
    }

    public boolean isDeclined() {
        return this.decline;
    }

    public String getReason() {
        return this.reason;
    }

    public void appendToXML(StringBuffer stringBuffer) {
        stringBuffer.append("<x xmlns='http://jabber.org/protocol/muc#user'>");
        stringBuffer.append("<invite");
        XMUCUserInvite.appendAttribute((StringBuffer)stringBuffer, (String)"to", (Object)this.user);
        stringBuffer.append(">");
        XMUCUserInvite.appendElement((StringBuffer)stringBuffer, (String)"reason", (String)this.reason);
        stringBuffer.append("</invite>");
        stringBuffer.append("</x>");
    }
}

